package com.ejianc.business.salary.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.salary.bean.SocialSecurityChangeSdetailEntity;
import com.ejianc.business.salary.bean.SocialSecurityChangeAdetailEntity;
/**
 * 社保公积金调整
 * 
 * @author generator
 * 
 */
 @TableName("ejc_salary_social_security_change")
public class SocialSecurityChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="create_user_name")
    private String createUserName; // 编制人
    @TableField(value="update_user_name")
    private String updateUserName; // 修改者
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="bill_date")
    private Date billDate; // 经办日期
    
    @TableField(exist=false)
    @SubEntity(serviceName="socialSecurityChangeSdetailService")
    private List<SocialSecurityChangeSdetailEntity> socialSecurityChangeSdetailList = new ArrayList<>(); // 社保公积金调整-社保明细
    @TableField(exist=false)
    @SubEntity(serviceName="socialSecurityChangeAdetailService")
    private List<SocialSecurityChangeAdetailEntity> socialSecurityChangeAdetailList = new ArrayList<>(); // 社保公积金调整-公积金明细

    @TableField(value="org_id")
    private Long orgId; // 单位id
    @TableField(value="org_name")
    private String orgName; // 单位名称

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    

    public List<SocialSecurityChangeSdetailEntity> getSocialSecurityChangeSdetailList() {
        return socialSecurityChangeSdetailList;
    }

    public void setSocialSecurityChangeSdetailList(List<SocialSecurityChangeSdetailEntity> socialSecurityChangeSdetailList) {
        this.socialSecurityChangeSdetailList = socialSecurityChangeSdetailList;
    }

    public List<SocialSecurityChangeAdetailEntity> getSocialSecurityChangeAdetailList() {
        return socialSecurityChangeAdetailList;
    }

    public void setSocialSecurityChangeAdetailList(List<SocialSecurityChangeAdetailEntity> socialSecurityChangeAdetailList) {
        this.socialSecurityChangeAdetailList = socialSecurityChangeAdetailList;
    }
}
