package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.AcSetRelateMapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.service.IAcSetRelateService;
import org.springframework.util.unit.DataUnit;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 账套组织关联表
 * 
 * @author generator
 * 
 */
@Service("acSetRelateService")
public class AcSetRelateServiceImpl extends BaseServiceImpl<AcSetRelateMapper, AcSetRelateEntity> implements IAcSetRelateService{

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayableService payableService;


    @Override
    public AcSetRelateVO queryDetailByOrgId(Long orgId, Integer orgType, String month) {
        AcSetRelateEntity entity = this.getOne(new QueryWrapper<AcSetRelateEntity>().eq("org_id", orgId));
        AcSetRelateVO acSetRelateVO = new AcSetRelateVO();
        if (null != entity){
            acSetRelateVO = BeanMapper.map(entity, AcSetRelateVO.class);
        }

        QueryWrapper<PayableEntity> queryWrapper = new QueryWrapper<>();
        //计算该组织对应数据
        if (null == orgType){
            CommonResponse<OrgVO> orgIdCrs = iOrgApi.getOneById(orgId);
            if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
                throw new BusinessException("查询组织信息失败！");
            }
            orgType = orgIdCrs.getData().getOrgType();
        }
        if(5 == orgType) {
            CommonResponse<OrgVO> parentByOrgId = iOrgApi.findParentByOrgId(orgId);
            if (!parentByOrgId.isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("查询组织信息失败！");
            }
            queryWrapper.in("org_id", iOrgApi.findChildrenByParentId(parentByOrgId.getData().getId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        } else {
            queryWrapper.in("org_id", iOrgApi.findChildrenByParentId(orgId).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        }

        List<PayableEntity> jsPayableList = payableService.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(jsPayableList) && jsPayableList.size() > 0){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");

            acSetRelateVO.setOrgBillNum(jsPayableList.size());
            acSetRelateVO.setOrgBillRegisterMny(jsPayableList.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            acSetRelateVO.setOrgBillApprovalMny(jsPayableList.stream().filter(p -> p.getPayableSumMny() != null && (p.getBillState() == 1 || p.getBillState() == 3)).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<PayableEntity> lastMonthData = new ArrayList<>();
            for (PayableEntity jspayableEntity : jsPayableList) {
                Date lastMonth = DateUtils.addMonths(jspayableEntity.getMonth(), 1);
                if (sdf.format(lastMonth).equals(month)){
                    lastMonthData.add(jspayableEntity);
                }
            }
            List<PayableEntity> thisMonthData = jsPayableList.stream().filter(e -> null != e.getMonth() && sdf.format(e.getMonth()).equals(month)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(lastMonthData)){
                acSetRelateVO.setLastMonthMny(lastMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                acSetRelateVO.setDifMonthMny(acSetRelateVO.getLastMonthMny());

                if (CollectionUtils.isNotEmpty(thisMonthData)){
                    acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub(acSetRelateVO.getLastMonthMny(), thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
            }else {
                acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub(BigDecimal.ZERO, thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }

        return acSetRelateVO;
    }
}
