/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.salary.bean.TaxEntity;
import com.ejianc.business.salary.bean.TaxModifyEntity;
import com.ejianc.business.salary.service.ITaxModifyService;
import com.ejianc.business.salary.service.ITaxService;
import com.ejianc.business.salary.vo.TaxDetailVO;
import com.ejianc.business.salary.vo.TaxVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"tax"})
public class TaxController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "TAX";
    @Autowired
    private ITaxService service;
    @Autowired
    private ITaxModifyService modifyService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TaxVO> saveOrUpdate(@RequestBody TaxVO saveOrUpdateVO) {
        List sbjnOrgNameList;
        TaxEntity entity = (TaxEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TaxEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        TaxVO vo = (TaxVO)BeanMapper.map((Object)this.service.selectById(entity.getId()), TaxVO.class);
        List detailIdList = vo.getDetailList().stream().filter(e -> null != e.getIsAdjust() && "2".equals(e.getIsAdjust())).map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(detailIdList)) {
            Map taxDetailMap = vo.getDetailList().stream().filter(e -> null != e.getIsAdjust() && "2".equals(e.getIsAdjust())).collect(Collectors.toMap(p -> p.getId(), Function.identity()));
            List taxModifyList = this.modifyService.list((Wrapper)new QueryWrapper().in((Object)"tax_bill_detail_id", detailIdList));
            if (CollectionUtils.isNotEmpty((Collection)taxModifyList)) {
                for (TaxModifyEntity taxModifyEntity : taxModifyList) {
                    taxModifyEntity.setTaxMny(((TaxDetailVO)taxDetailMap.get(taxModifyEntity.getTaxBillDetailId())).getTotalButuiTaxMny());
                }
                this.modifyService.saveOrUpdateBatch(taxModifyList, taxModifyList.size());
            }
        }
        vo.setSbjnOrgNameList(CollectionUtils.isNotEmpty(sbjnOrgNameList = vo.getDetailList().stream().filter(e -> null != e.getSbjnOrgName() && StringUtils.isNotBlank((CharSequence)e.getSbjnOrgName())).map(TaxDetailVO::getSbjnOrgName).distinct().collect(Collectors.toList())) && sbjnOrgNameList.size() > 0 ? sbjnOrgNameList : new ArrayList());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<TaxVO> queryDetail(Long id) {
        TaxVO vo;
        TaxEntity entity = (TaxEntity)((Object)this.service.selectById(id));
        List sbjnOrgNameList = (vo = (TaxVO)BeanMapper.map((Object)((Object)entity), TaxVO.class)).getDetailList().stream().filter(e -> null != e.getSbjnOrgName() && StringUtils.isNotBlank((CharSequence)e.getSbjnOrgName())).map(TaxDetailVO::getSbjnOrgName).distinct().collect(Collectors.toList());
        vo.setSbjnOrgNameList(CollectionUtils.isNotEmpty(sbjnOrgNameList) && sbjnOrgNameList.size() > 0 ? sbjnOrgNameList : new ArrayList());
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<TaxVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (TaxVO taxVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TaxVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("yfgzjsBillCode");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaxVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("yfgzjsBillCode");
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List resList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resList = BeanMapper.mapList((Iterable)list, TaxVO.class);
            resList.forEach(e -> e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription()));
        }
        HashMap beans = new HashMap();
        beans.put("records", resList);
        ExcelExport.getInstance().export("Tax-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTaxData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TaxVO>> refTaxData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), TaxVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"TaxDetail-import.xlsx", (String)"\u4e2a\u7a0e\u8ba1\u7b97-\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse = this.service.excelImport(request, response);
        return commonResponse;
    }
}

