/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.salary.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.salary.bean.AcSetRelateEntity;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.mapper.AcSetRelateMapper;
import com.ejianc.business.salary.service.IAcSetRelateService;
import com.ejianc.business.salary.service.IPayableService;
import com.ejianc.business.salary.vo.AcSetRelateVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="acSetRelateService")
public class AcSetRelateServiceImpl
extends BaseServiceImpl<AcSetRelateMapper, AcSetRelateEntity>
implements IAcSetRelateService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IPayableService payableService;

    @Override
    public AcSetRelateVO queryDetailByOrgId(Long orgId, Integer orgType, String month) {
        AcSetRelateEntity entity = (AcSetRelateEntity)((Object)this.getOne((Wrapper)new QueryWrapper().eq((Object)"org_id", (Object)orgId)));
        AcSetRelateVO acSetRelateVO = new AcSetRelateVO();
        if (null != entity) {
            acSetRelateVO = (AcSetRelateVO)BeanMapper.map((Object)((Object)entity), AcSetRelateVO.class);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null == orgType) {
            CommonResponse orgIdCrs = this.iOrgApi.getOneById(orgId);
            if (!orgIdCrs.isSuccess() || null == orgIdCrs.getData()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            orgType = ((OrgVO)orgIdCrs.getData()).getOrgType();
        }
        if (5 == orgType) {
            CommonResponse parentByOrgId = this.iOrgApi.findParentByOrgId(orgId);
            if (!parentByOrgId.isSuccess() || null == parentByOrgId.getData()) {
                throw new BusinessException("\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
            }
            queryWrapper.in((Object)"org_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(((OrgVO)parentByOrgId.getData()).getId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        } else {
            queryWrapper.in((Object)"org_id", (Collection)((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        }
        List allPayableList = this.payableService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)allPayableList) && allPayableList.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            List thisMonthData = allPayableList.stream().filter(e -> null != e.getMonth() && sdf.format(e.getMonth()).equals(month)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(thisMonthData)) {
                acSetRelateVO.setOrgBillNum(Integer.valueOf(thisMonthData.size()));
                acSetRelateVO.setOrgBillRegisterMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                acSetRelateVO.setOrgBillApprovalMny(thisMonthData.stream().filter(p -> p.getPayableSumMny() != null && (p.getBillState() == 1 || p.getBillState() == 3)).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            ArrayList<PayableEntity> lastMonthData = new ArrayList<PayableEntity>();
            for (PayableEntity jspayableEntity : allPayableList) {
                Date lastMonth = DateUtils.addMonths((Date)jspayableEntity.getMonth(), (int)1);
                if (!sdf.format(lastMonth).equals(month)) continue;
                lastMonthData.add(jspayableEntity);
            }
            if (CollectionUtils.isNotEmpty(lastMonthData)) {
                acSetRelateVO.setLastMonthMny(lastMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                acSetRelateVO.setDifMonthMny(acSetRelateVO.getLastMonthMny());
                if (CollectionUtils.isNotEmpty(thisMonthData)) {
                    acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub((BigDecimal)acSetRelateVO.getLastMonthMny(), (BigDecimal)thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
                }
            } else {
                acSetRelateVO.setDifMonthMny(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)thisMonthData.stream().filter(p -> p.getPayableSumMny() != null).map(PayableEntity::getPayableSumMny).reduce(BigDecimal.ZERO, BigDecimal::add)));
            }
        }
        return acSetRelateVO;
    }
}

