package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.vo.PayableDetailVO;
import com.ejianc.business.salary.vo.RosterVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.PayableMapper;
import com.ejianc.business.salary.bean.PayableEntity;
import com.ejianc.business.salary.service.IPayableService;

import java.util.Date;
import java.util.List;

/**
 * 应发工资上传
 * 
 * @author generator
 * 
 */
@Service("payableService")
public class PayableServiceImpl extends BaseServiceImpl<PayableMapper, PayableEntity> implements IPayableService{

    @Override
    public List<PayableDetailVO> getDetailByOrg(Date month, List<Long> orgIds) {
        return baseMapper.getDetailByOrg(month,orgIds);
    }

    @Override
    public List<PayableDetailVO> getDetail(Date month) {
        return baseMapper.getDetail(month);
    }

    @Override
    public List<RosterVO> getUserByOrgCode(List<String> orgCode1,List<String> orgCode2,Integer month) {
        return baseMapper.getUserByOrgCode(orgCode1,orgCode2,month);
    }
}
