package com.ejianc.business.salary.mapper;

import com.ejianc.business.salary.bean.JspayableAdjustEntity;
import com.ejianc.business.salary.bean.PushcwEntity;
import com.ejianc.business.salary.dto.PayrollActualMnyDTO;
import com.ejianc.business.salary.vo.PushcwVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.salary.bean.PayrollEntity;

import java.util.Date;
import java.util.List;

/**
 * 工资单-主实体
 * 
 * @author generator
 * 
 */
@Mapper
public interface PayrollMapper extends BaseCrudMapper<PayrollEntity> {

    List<PushcwEntity> getActualMny(Date month, Long companyId);

    List<PushcwEntity> getAcActualMny(Date month, Long companyId);

    List<PushcwEntity> getIdCardActualMny(Date month, Long companyId);



    //更新子表实付金额
    void updateActualMnyDetail(String companyIdAndMonth);
    //更新主表实付金额
    void updateActualMny(String companyIdAndMonth);

    List<JspayableAdjustEntity> getSbGjj(Date month, Long companyId);

    List<JspayableAdjustEntity> getGs(Date month, Long companyId);

    List<JspayableAdjustEntity> getDbyb(Date month, Long companyId);


}
