package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.vo.*;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.JspayableMapper;
import com.ejianc.business.salary.bean.JspayableEntity;
import com.ejianc.business.salary.service.IJspayableService;

import java.util.Date;
import java.util.List;

/**
 * 应发工资计算
 * 
 * @author generator
 * 
 */
@Service("jspayableService")
public class JspayableServiceImpl extends BaseServiceImpl<JspayableMapper, JspayableEntity> implements IJspayableService{

    @Override
    public List<JspayableDetailVO> getDetailSum(Date month,List<Long> companyId) {
        return baseMapper.getDetailSum(month,companyId);
    }

    @Override
    public List<JspayableSourceVO> getDetailSource(Date month,List<Long> companyId) {
        return baseMapper.getDetailSource(month,companyId);
    }

    @Override
    public List<SourceDetailVO> querySourceDetail(String idCard, Date period,Long companyId) {
        return baseMapper.querySourceDetail(idCard,period,companyId);
    }

    @Override
    public List<RosterAttendanceVO> queryAttendanceDetail(Date month,List<Long> companyId, List<String> idCards) {
        return baseMapper.queryAttendanceDetail(month,companyId, idCards);
    }

    @Override
    public List<RosterSbVO> querySbDetail(List<String> idCards,List<Long> companyId) {
        return baseMapper.querySbDetail(idCards,companyId);
    }

    @Override
    public List<RosterSbVO> queryGjjDetail(List<String> idCards,List<Long> companyId) {
        return baseMapper.queryGjjDetail(idCards,companyId);
    }
}
