package com.ejianc.business.salary.service.impl;

import com.ejianc.business.salary.bean.RosterSocialSecurityEntity;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.salary.mapper.RosterAccumulationFundMapper;
import com.ejianc.business.salary.bean.RosterAccumulationFundEntity;
import com.ejianc.business.salary.service.IRosterAccumulationFundService;

import java.util.Date;
import java.util.List;

/**
 * 人员花名册-公积金
 * 
 * @author generator
 * 
 */
@Service("rosterAccumulationFundService")
public class RosterAccumulationFundServiceImpl extends BaseServiceImpl<RosterAccumulationFundMapper, RosterAccumulationFundEntity> implements IRosterAccumulationFundService{

    @Override
    public void updateAccumulationFund(List<RosterAccumulationFundEntity> entities) {
        for (RosterAccumulationFundEntity entity : entities) {
            QueryParam param = new QueryParam();
            param.getParams().put("idCard", new Parameter(QueryParam.EQ, entity.getIdCard()));
            param.getParams().put("dataState", new Parameter(QueryParam.EQ, "启用"));
            List<RosterAccumulationFundEntity> rosterSocialSecurityEntities = this.queryList(param);

            if (CollectionUtils.isNotEmpty(rosterSocialSecurityEntities)){
                for (RosterAccumulationFundEntity rosterSocialSecurityEntity : rosterSocialSecurityEntities) {
                    rosterSocialSecurityEntity.setDataState("停用");
                    rosterSocialSecurityEntity.setEndTime(new Date());
                }
            }

            entity.setId(null);
            entity.setDataState("启用");
            entity.setStartTime(new Date());
            rosterSocialSecurityEntities.add(entity);
            this.saveOrUpdateBatch(rosterSocialSecurityEntities);
        }
    }

    @Override
    public void updateAccumulationFundState(String socialDepartmentName) {
        if ("郑州一建集团有限公司".equals(socialDepartmentName)){
            baseMapper.updateAccumulationFundStateLz();
        }
        baseMapper.updateAccumulationFundState(socialDepartmentName);
    }
}
