package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.ProductorInfoEntity;
/**
 * 工程管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_project_info")
public class ProjectInfoEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="name")
    private String name; // 工程名称
    @TableField(value="customer_id")
    private Long customerId; // 客户id
    @TableField(value="customer_name")
    private String customerName; // 客户名称
    @TableField(value="owner_id")
    private Long ownerId; // 业主id
    @TableField(value="owner_name")
    private String ownerName; // 业主名称
    @TableField(value="project_start_time")
    private Date projectStartTime; // 工期开始时间
    @TableField(value="project_end_time")
    private Date projectEndTime; // 工期结束时间
    @TableField(value="advance_charge")
    private BigDecimal advanceCharge; // 预付款
    @TableField(value="settlement_time")
    private Date settlementTime; // 结清时间
    @TableField(value="customer_linker_id")
    private Long customerLinkerId; // 客户联系人id
    @TableField(value="customer_linke_name")
    private String customerLinkeName; // 客户联系人名称
    @TableField(value="customer_linke_mobile")
    private String customerLinkeMobile; // 客户联系人电话
    @TableField(value="customer_quality_demand")
    private String customerQualityDemand; // 客户质量需求
    @TableField(value="other_matters")
    private String otherMatters; // 其他事项
    @TableField(value="is_laboratory_examine")
    private Integer isLaboratoryExamine; // 是否需要实验室审核:1 是 0 否
    @TableField(value="region_id")
    private Long regionId; // 区域id
    @TableField(value="region_name")
    private String regionName; // 区域名称
    @TableField(value="print_customer_name")
    private String printCustomerName; // 打印客户名称
    @TableField(value="print_supply_name")
    private String printSupplyName; // 打印供应商名称
    @TableField(value="amount_total")
    private BigDecimal amountTotal; // 合同金额
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编码
    @TableField(value="project_type")
    private String projectType; // 工程类型
    @TableField(value="turn_formal_date")
    private Date turnFormalDate; // 转正式工程日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="change_id")
    private Long changeId; // 变更单据id
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="profitcenter_id")
    private Long profitcenterId; // 利润中心id
    @TableField(value="profitcenter_name")
    private String profitcenterName; // 利润中心名称
    @TableField(value="collection_status")
    private String collectionStatus; // 收款情况
    @TableField(value="control_amount")
    private BigDecimal controlAmount; // 控制金额
    @TableField(value="iscontrol")
    private Integer iscontrol; // 是否应用控制额度
    @TableField(value="org_id")
    private java.lang.Long orgId; // 所属组织id
    @TableField(value="org_name")
    private java.lang.String orgName; // 所属组织名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="productorInfoService",pidName = "projectId")//此处有pid="xxx"，默认值pid="pid"
    private List<ProductorInfoEntity> productorInfoList = new ArrayList<>(); // 工程产品信息
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }
    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }
    public Date getProjectStartTime() {
        return projectStartTime;
    }

    public void setProjectStartTime(Date projectStartTime) {
        this.projectStartTime = projectStartTime;
    }
    public Date getProjectEndTime() {
        return projectEndTime;
    }

    public void setProjectEndTime(Date projectEndTime) {
        this.projectEndTime = projectEndTime;
    }
    public BigDecimal getAdvanceCharge() {
        return advanceCharge;
    }

    public void setAdvanceCharge(BigDecimal advanceCharge) {
        this.advanceCharge = advanceCharge;
    }
    public Date getSettlementTime() {
        return settlementTime;
    }

    public void setSettlementTime(Date settlementTime) {
        this.settlementTime = settlementTime;
    }
    public Long getCustomerLinkerId() {
        return customerLinkerId;
    }

    public void setCustomerLinkerId(Long customerLinkerId) {
        this.customerLinkerId = customerLinkerId;
    }
    public String getCustomerLinkeName() {
        return customerLinkeName;
    }

    public void setCustomerLinkeName(String customerLinkeName) {
        this.customerLinkeName = customerLinkeName;
    }
    public String getCustomerLinkeMobile() {
        return customerLinkeMobile;
    }

    public void setCustomerLinkeMobile(String customerLinkeMobile) {
        this.customerLinkeMobile = customerLinkeMobile;
    }
    public String getCustomerQualityDemand() {
        return customerQualityDemand;
    }

    public void setCustomerQualityDemand(String customerQualityDemand) {
        this.customerQualityDemand = customerQualityDemand;
    }
    public String getOtherMatters() {
        return otherMatters;
    }

    public void setOtherMatters(String otherMatters) {
        this.otherMatters = otherMatters;
    }
    public Integer getIsLaboratoryExamine() {
        return isLaboratoryExamine;
    }

    public void setIsLaboratoryExamine(Integer isLaboratoryExamine) {
        this.isLaboratoryExamine = isLaboratoryExamine;
    }
    public Long getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }
    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }
    public String getPrintCustomerName() {
        return printCustomerName;
    }

    public void setPrintCustomerName(String printCustomerName) {
        this.printCustomerName = printCustomerName;
    }
    public String getPrintSupplyName() {
        return printSupplyName;
    }

    public void setPrintSupplyName(String printSupplyName) {
        this.printSupplyName = printSupplyName;
    }
    public BigDecimal getAmountTotal() {
        return amountTotal;
    }

    public void setAmountTotal(BigDecimal amountTotal) {
        this.amountTotal = amountTotal;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public Date getTurnFormalDate() {
        return turnFormalDate;
    }

    public void setTurnFormalDate(Date turnFormalDate) {
        this.turnFormalDate = turnFormalDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public String getCollectionStatus() {
        return collectionStatus;
    }

    public void setCollectionStatus(String collectionStatus) {
        this.collectionStatus = collectionStatus;
    }
    public BigDecimal getControlAmount() {
        return controlAmount;
    }

    public void setControlAmount(BigDecimal controlAmount) {
        this.controlAmount = controlAmount;
    }
    public Integer getIscontrol() {
        return iscontrol;
    }

    public void setIscontrol(Integer iscontrol) {
        this.iscontrol = iscontrol;
    }
    
    public List<ProductorInfoEntity> getProductorInfoList() {
        return productorInfoList;
    }

    public void setProductorInfoList(List<ProductorInfoEntity> productorInfoList) {
        this.productorInfoList = productorInfoList;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
