package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.SignfreightdetailEntity;
/**
 * 运费签认单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_signfreight")
public class SignfreightEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="transport_id")
    private Long transportId; // 运输商主键
    @TableField(value="transport_name")
    private String transportName; // 运输商名称
    @TableField(value="check_total_money")
    private BigDecimal checkTotalMoney; // 勾选总金额
    @TableField(value="sign_money")
    private BigDecimal signMoney; // 签认金额
    @TableField(value="payment_status")
    private Integer paymentStatus; // 付款状态  0-付款完成 1-未付款 2-部分付款
    @TableField(value="payment_money")
    private BigDecimal paymentMoney; // 已付款金额
    @TableField(value="not_payment_money")
    private BigDecimal notPaymentMoney; // 未付款金额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="signfreightdetailService",pidName = "mid")
    private List<SignfreightdetailEntity> signfreightdetailList = new ArrayList<>(); // 运费签认单子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getTransportId() {
        return transportId;
    }

    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getCheckTotalMoney() {
        return checkTotalMoney;
    }

    public void setCheckTotalMoney(BigDecimal checkTotalMoney) {
        this.checkTotalMoney = checkTotalMoney;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }
    public BigDecimal getPaymentMoney() {
        return paymentMoney;
    }

    public void setPaymentMoney(BigDecimal paymentMoney) {
        this.paymentMoney = paymentMoney;
    }
    public BigDecimal getNotPaymentMoney() {
        return notPaymentMoney;
    }

    public void setNotPaymentMoney(BigDecimal notPaymentMoney) {
        this.notPaymentMoney = notPaymentMoney;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    

    public List<SignfreightdetailEntity> getSignfreightdetailList() {
        return signfreightdetailList;
    }

    public void setSignfreightdetailList(List<SignfreightdetailEntity> signfreightdetailList) {
        this.signfreightdetailList = signfreightdetailList;
    }
}
