package com.ejianc.business.sale.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.production.task.vo.ShipperfareVO;
import com.ejianc.business.sale.vo.SignfreightdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.vo.ManualshipmentVO;

/**
 * 发货管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("manualshipment")
public class ManualshipmentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    @Autowired
    private IManualshipmentService service;

    @Autowired
    private SessionManager sessionManager;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ManualshipmentVO> saveOrUpdate(@RequestBody ManualshipmentVO saveOrUpdateVO) {
    	ManualshipmentEntity entity = BeanMapper.map(saveOrUpdateVO, ManualshipmentEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setShipmentType(0);
                entity.setFreightStatus(1);
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setPaidMoney(new BigDecimal(0.00));
        entity.setOutstandingMoney(entity.getFreight());
    	service.saveOrUpdate(entity, false);
    	ManualshipmentVO vo = BeanMapper.map(entity, ManualshipmentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ManualshipmentVO> queryDetail(Long id) {
    	ManualshipmentEntity entity = service.selectById(id);
    	ManualshipmentVO vo = BeanMapper.map(entity, ManualshipmentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ManualshipmentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ManualshipmentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ManualshipmentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ManualshipmentEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Manualshipment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refManualshipmentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> refManualshipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  发货确认列表数据
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/receipt", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> receipt(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("freight_status",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 修改发货单的运费确认状态和实收数据
     */
    @RequestMapping(value = "/updateFreightStatus", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>>updateFreightStatus(@RequestBody List<ManualshipmentVO> saveOrUpdateVO) {
        for(ManualshipmentVO manualshipmentVO : saveOrUpdateVO){
            ManualshipmentEntity manualshipment =  service.getById(manualshipmentVO.getId());
            manualshipment.setFreightStatus(0);
            manualshipment.setFreightTime(new Date());
            manualshipment.setConfirmNumber(manualshipmentVO.getConfirmNumber());
            CommonResponse<ShippersInfoApiVO> commonResponse =  baseApi.getShippersInfo(manualshipment.getNumberPlate(),manualshipment.getOrgId());
            if(commonResponse.getCode() == 0){
                BigDecimal freight = this.freightCount(manualshipment.getDistance(),manualshipmentVO.getConfirmNumber(),commonResponse.getData().getShippersfareVOS());
                manualshipment.setFreight(freight);
            }else {
                throw new BusinessException(commonResponse.getMsg());
            }
            service.updateById(manualshipment);
        }
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("freight_status",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success("确认成功！",pageData);
    }

    /**
     * @Description queryList 根据运输商id查询改运输商上个月的运费情况
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/freightList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignfreightdetailVO>> freightList(@RequestBody QueryParam param) {

        QueryWrapper<ManualshipmentEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("shippers_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("date").getValue() != null){
            //param.getParams().remove("customer_name");
            String[] strs = param.getParams().get("date").getValue().toString().split(",");
            String starttime = strs[0].toString() + " 00:00:00";
            String endtiem = strs[1].toString() + " 23:59:59";
            queryWrapper.between("freight_time",starttime,endtiem);//签认之后就可开票
        }

        queryWrapper.eq("freight_status",0);
        List<ManualshipmentEntity> list = service.list(queryWrapper);
        List<SignfreightdetailVO> signfreightdetailVO = new ArrayList<>();
        for(ManualshipmentEntity manualshipmentEntity : list){
            SignfreightdetailVO SignfreightdetailList = new SignfreightdetailVO();
            SignfreightdetailList.setId(manualshipmentEntity.getId());
            SignfreightdetailList.setConsignmentDate(manualshipmentEntity.getShipDate());
            SignfreightdetailList.setConsignmentType(manualshipmentEntity.getShipmentType());
            SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getConfirmNumber());
            SignfreightdetailList.setDistance(manualshipmentEntity.getDistance());
            SignfreightdetailList.setFreight(manualshipmentEntity.getFreight());
            SignfreightdetailList.setRowState("add");
            signfreightdetailVO.add(SignfreightdetailList);
        }
        return CommonResponse.success("查询列表数据成功！",signfreightdetailVO);
    }

    //计算运费
    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShippersfareVO> shippersfareVO){
        BigDecimal freight = new BigDecimal(0.0);
        if(distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0){
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }else{
            for (int i = 0; i < shippersfareVO.size(); i++) {
                if(i == 0){
                    freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                    continue;
                }else {
                    if(distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0){
                        //最终距离 - 开始距离
                        BigDecimal distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        continue;
                    }else {
                        //最终距离 - 开始距离
                        BigDecimal distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        break;
                    }
                }
            }
        }
        return freight;
    }


}
