package com.ejianc.business.sale.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.vo.InvoicedetialVO;
import com.ejianc.business.sale.vo.ReceivablesdetialVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.vo.SalesorderVO;

/**
 * 销售单信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salesorder")
public class SalesorderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sale-salesorder";//此处需要根据实际修改

    @Autowired
    private ISalesorderService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SalesorderVO> saveOrUpdate(@RequestBody SalesorderVO saveOrUpdateVO) {
    	SalesorderEntity entity = BeanMapper.map(saveOrUpdateVO, SalesorderEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SalesorderVO vo = BeanMapper.map(entity, SalesorderVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalesorderVO> queryDetail(Long id) {
    	SalesorderEntity entity = service.selectById(id);
    	SalesorderVO vo = BeanMapper.map(entity, SalesorderVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesorderVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SalesorderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalesorderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SalesorderEntity> page = service.queryPage(param,false);
        IPage<SalesorderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesorderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SalesorderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Salesorder-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSalesorderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> refSalesorderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SalesorderEntity> page = service.queryPage(param,false);
        IPage<SalesorderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesorderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> list(@RequestBody QueryParam param) {

        QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("customer_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("customer_id",param.getParams().get("customer_id").getValue());
        }
        if(param.getParams().get("profitcenter_id").getValue() != null){
            //param.getParams().remove("profitcenter_id");
            queryWrapper.eq("profitcenter_id",param.getParams().get("profitcenter_id").getValue());
        }
        if(param.getParams().get("project_id").getValue() != null){
            //param.getParams().remove("project_id");
            queryWrapper.eq("project_id",param.getParams().get("project_id").getValue());
        }
        if(param.getParams().get("worksite_id").getValue() != null){
            //param.getParams().remove("worksite_id");
            queryWrapper.eq("worksite_id",param.getParams().get("worksite_id").getValue());
        }
        if(param.getParams().get("saleDate").getValue() != null ){
            //param.getParams().remove("saleDate");
            String[] strs = param.getParams().get("saleDate").getValue().toString().split(",");
            String starttime = strs[0].toString();
            String endtiem = strs[1].toString();
            queryWrapper.between("sale_date",starttime,endtiem);
        }
        queryWrapper.isNull("is_sign");
        IPage<SalesorderEntity> page = new Page<>();
        List<SalesorderEntity> list = service.list(queryWrapper);
        page.setRecords(list);
        //IPage<SalesorderEntity> page = service.queryPage(param,false);
        IPage<SalesorderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesorderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/customerlist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalesorderVO>> customerlist(@RequestBody QueryParam param) {

        QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("customer_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("customer_id",param.getParams().get("customer_id").getValue());
        }
        queryWrapper.isNull("is_sign");
        IPage<SalesorderEntity> page = new Page<>();
        List<SalesorderEntity> list = service.list(queryWrapper);
        page.setRecords(list);
        //IPage<SalesorderEntity> page = service.queryPage(param,false);
        IPage<SalesorderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesorderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 查询收款管理销售单列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/receivableslist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ReceivablesdetialVO>> receivableslist(@RequestBody QueryParam param) {

        QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("customer_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("customer_id",param.getParams().get("customer_id").getValue());
        }
        if(param.getParams().get("chooseDate").getValue() != null){
            //param.getParams().remove("customer_name");
            String date = param.getParams().get("chooseDate").getValue().toString();
            String starttime = date + "-01-01 00:00:00";
            String endtiem = date + "-12-31 23:59:59";
            queryWrapper.between("sign_date",starttime,endtiem);
        }
        queryWrapper.eq("is_sign",0);
        queryWrapper.ne("uncollected_moeny",new BigDecimal(0.00000000));
        List<SalesorderEntity> list = service.list(queryWrapper);
        List<ReceivablesdetialVO> receivablesdetialVOList = new ArrayList<>();
        for(SalesorderEntity salesorderEntity : list){
            ReceivablesdetialVO receivablesdetialVO = new ReceivablesdetialVO();
            receivablesdetialVO.setId(salesorderEntity.getId());
            receivablesdetialVO.setBillCode(salesorderEntity.getBillCode());
            receivablesdetialVO.setProjectId(salesorderEntity.getProjectId());
            receivablesdetialVO.setProjectName(salesorderEntity.getProjectName());
            receivablesdetialVO.setWorksiteId(salesorderEntity.getWorksiteId());
            receivablesdetialVO.setWorksiteName(salesorderEntity.getWorksiteName());
            receivablesdetialVO.setSignDate(salesorderEntity.getSignDate());
            receivablesdetialVO.setReceivableMoney(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
            if(salesorderEntity.getReceivedMoeny().doubleValue() != 0.00){
                receivablesdetialVO.setOtherReceivedMoney(salesorderEntity.getReceivedMoeny());
                receivablesdetialVO.setReceivedMoney(new BigDecimal(0.00));
            }else{
                receivablesdetialVO.setReceivedMoney(salesorderEntity.getReceivedMoeny());
                receivablesdetialVO.setOtherReceivedMoney(new BigDecimal(0.00));
            }
            receivablesdetialVO.setUncollectedMoney(salesorderEntity.getUncollectedMoeny());
            receivablesdetialVO.setSaleId(salesorderEntity.getId());
            receivablesdetialVO.setRowState("add");
            receivablesdetialVOList.add(receivablesdetialVO);
        }
        return CommonResponse.success("查询列表数据成功！",receivablesdetialVOList);
    }

    /**
     * @Description queryList 查询收款管理销售单列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/invoicelist", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<InvoicedetialVO>> invoicelist(@RequestBody QueryParam param) {

        QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
        if(param.getParams().get("customer_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("customer_id",param.getParams().get("customer_id").getValue());
        }
        if(param.getParams().get("accountingaDate").getValue() != null){
            //param.getParams().remove("customer_name");
            String[] strs = param.getParams().get("accountingaDate").getValue().toString().split(",");
            String starttime = strs[0].toString();
            String endtiem = strs[1].toString();
            //逻辑不确定  可能是签认之后就可以开票，也可能是收款之后才可以开票
            //queryWrapper.between("receivables_date",starttime,endtiem);//收款之后才可以开票
            queryWrapper.between("sign_date",starttime,endtiem);//签认之后就可开票
        }
        //queryWrapper.eq("is_receivables",0);//收款之后才可以开票
        queryWrapper.eq("is_sign",0);//签认之后就可开票
        //如果签认之后就可以开票那么在签认之后需要回写销售单中发票已开金额=0.00，发票未开金额=销售总额-调账金额  这个逻辑未写
        //如果是收款之后才开票，需要将
        //queryWrapper.ne("not_invoice_moeny",new BigDecimal(0.00000000));
        List<SalesorderEntity> list = service.list(queryWrapper);
        List<InvoicedetialVO> invoicedetialVOVOList = new ArrayList<>();
        for(SalesorderEntity salesorderEntity : list){
            InvoicedetialVO invoicedetialVO = new InvoicedetialVO();
            invoicedetialVO.setId(salesorderEntity.getId());
            invoicedetialVO.setBillCode(salesorderEntity.getBillCode());
            invoicedetialVO.setProjectId(salesorderEntity.getProjectId());
            invoicedetialVO.setProjectName(salesorderEntity.getProjectName());
            invoicedetialVO.setWorksiteId(salesorderEntity.getWorksiteId());
            invoicedetialVO.setWorksiteName(salesorderEntity.getWorksiteName());
            //以下可能错误
            invoicedetialVO.setReceivablesDate(salesorderEntity.getReceivablesDate());
            invoicedetialVO.setInvoiceMoney(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
            if(salesorderEntity.getReceivedMoeny().doubleValue() != 0.00){
                invoicedetialVO.setOtherReceivedMoney(salesorderEntity.getReceivedMoeny());
                invoicedetialVO.setReceivedMoney(new BigDecimal(0.00));
            }else{
                invoicedetialVO.setReceivedMoney(salesorderEntity.getReceivedMoeny());
                invoicedetialVO.setOtherReceivedMoney(new BigDecimal(0.00));
            }
            invoicedetialVO.setUncollectedMoney(salesorderEntity.getUncollectedMoeny());
            invoicedetialVO.setSaleId(salesorderEntity.getId());
            invoicedetialVO.setRowState("add");
            invoicedetialVOVOList.add(invoicedetialVO);
        }
        return CommonResponse.success("查询列表数据成功！",invoicedetialVOVOList);
    }
}
