package com.ejianc.business.sale.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.ProjectInfoEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.controller.*;
import com.ejianc.business.sale.salesorder.vo.CloseVO;
import com.ejianc.business.sale.salesorder.vo.MasterVO;
import com.ejianc.business.sale.salesorder.vo.ProductInfoVO;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.business.sale.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@RestController
@RequestMapping("/api/sale/masterData")
public class MasterDataApi {
    @Autowired
    private ProjectInfoController projectInfoController;//工程管理
    @Autowired
    private ContractController contractController;//销售合同
    @Autowired
    private ConstructionsiteController constructionsiteController;//工地信息
    @Autowired
    private SignController signController;//销售签认单
    @Autowired
    private SalesreconciliationController salesreconciliationController;//销售调账单
    @Autowired
    private PaymentController paymentController;//付款管理
    @Autowired
    private InvoiceController invoiceController;//发票管理
    @Autowired
    private ManualshipmentController manualshipmentController;//发票管理

    /**
     * 主数据360度查询接口
     */
    @RequestMapping(value = "/selectMasterList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse selectMasterList(@RequestBody MasterVO masterVO){
        CommonResponse co = new CommonResponse<>();
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(masterVO.getPageIndex());
        queryParam.setPageSize(masterVO.getPageSize());
        queryParam.setOrderMap(masterVO.getOrderMap());
        switch (masterVO.getStatus()){
            case 1:
                queryParam.getParams().put("customer_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<ProjectInfoVO>> projectInfo = projectInfoController.queryList(queryParam);
                if(projectInfo.getCode() == 0){
                    co.setData(projectInfo.getData());
                }else{
                    throw new BusinessException(projectInfo.getMsg());
                }
                break;
            case 2:
                queryParam.getParams().put("customer_manage_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<ContractVO>> contract = contractController.queryList(queryParam);
                if(contract.getCode() == 0){
                    co.setData(contract.getData());
                }else{
                    throw new BusinessException(contract.getMsg());
                }
                break;
            case 3:
                queryParam.getParams().put("contacts_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<ConstructionsiteVO>> constructionsite = constructionsiteController.queryList(queryParam);
                if(constructionsite.getCode() == 0){
                    co.setData(constructionsite.getData());
                }else{
                    throw new BusinessException(constructionsite.getMsg());
                }
                break;
            case 4:
                queryParam.getParams().put("customer_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<SignVO>> sign =  signController.queryList(queryParam);
                if(sign.getCode() == 0){
                    co.setData(sign.getData());
                }else{
                    throw new BusinessException(sign.getMsg());
                }
                break;
            case 5:
                queryParam.getParams().put("customer_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<SalesreconciliationVO>> salesreconciliation =  salesreconciliationController.queryList(queryParam);
                if(salesreconciliation.getCode() == 0){
                    co.setData(salesreconciliation.getData());
                }else{
                    throw new BusinessException(salesreconciliation.getMsg());
                }
                break;
            case 6:
                queryParam.getParams().put("transport_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<PaymentVO>> payment = paymentController.queryList(queryParam);
                if(payment.getCode() == 0){
                    co.setData(payment.getData());
                }else{
                    throw new BusinessException(payment.getMsg());
                }
                break;
            case 7:
                queryParam.getParams().put("customer_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<InvoiceVO>> invoice = invoiceController.queryList(queryParam);
                if(invoice.getCode() == 0){
                    co.setData(invoice.getData());
                }else{
                    throw new BusinessException(invoice.getMsg());
                }
                break;
            case 8:
                queryParam.getParams().put("customer_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<ManualshipmentVO>> manualshipment =  manualshipmentController.queryList(queryParam);
                if(manualshipment.getCode() == 0){
                    co.setData(manualshipment.getData());
                }else{
                    throw new BusinessException(manualshipment.getMsg());
                }
                break;
            case 9:
                queryParam.getParams().put("shippers_id",new Parameter(QueryParam.EQ, masterVO.getId()));
                CommonResponse<IPage<ManualshipmentVO>> manualshipments =  manualshipmentController.queryList(queryParam);
                if(manualshipments.getCode() == 0){
                    co.setData(manualshipments.getData());
                }else{
                    throw new BusinessException(manualshipments.getMsg());
                }
                break;
        }
        return CommonResponse.success("查询成功",co);
    };

}
