package com.ejianc.business.sale.service.impl;

import com.ejianc.business.sale.bean.ReceivablesEntity;
import com.ejianc.business.sale.bean.ReceivablesdetialEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.service.IReceivablesService;
import com.ejianc.business.sale.service.IReceivablesdetialService;
import com.ejianc.business.sale.service.ISalesorderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("receivables")
public class ReceivablesBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IReceivablesService receivablesService;
	@Autowired
	private IReceivablesdetialService receivablesdetialService;
	@Autowired
	private ISalesorderService salesorderService;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ReceivablesEntity receivablesEntity = receivablesService.getById(billId);
		if(receivablesEntity.getReceivablesdetialList() != null){
			for(ReceivablesdetialEntity receivablesdetialEntity : receivablesEntity.getReceivablesdetialList()){
				SalesorderEntity salesorderEntity = salesorderService.getById(receivablesdetialEntity.getSaleId());
				salesorderEntity.setReceivablesDate(new Date());
				salesorderEntity.setReceivedMoeny(receivablesdetialEntity.getDistributionMoney());
				salesorderEntity.setUncollectedMoeny(salesorderEntity.getUncollectedMoeny().subtract(receivablesdetialEntity.getDistributionMoney()));
				if(salesorderEntity.getUncollectedMoeny().doubleValue() == 0.00){
					salesorderEntity.setIsReceivables(0);
				}else{
					salesorderEntity.setIsReceivables(1);
				}
				salesorderService.updateById(salesorderEntity);
				receivablesdetialEntity.setReceivedMoney(receivablesdetialEntity.getDistributionMoney());
				receivablesdetialService.updateById(receivablesdetialEntity);
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
