package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.task.vo.ShipperfareVO;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.controller.ManualshipmentController;
import com.ejianc.business.sale.salesorder.vo.ProductionTaskApiVo;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.WeighinginfoMapper;
import com.ejianc.business.sale.bean.WeighinginfoEntity;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 无人值守称重信息
 * 
 * @author generator
 * 
 */
@Service("weighinginfoService")
public class WeighinginfoServiceImpl extends BaseServiceImpl<WeighinginfoMapper, WeighinginfoEntity> implements IWeighinginfoService {
    @Qualifier("com.ejianc.business.production.task.api.ProductionTaskApi")
    @Autowired
    private com.ejianc.business.production.task.api.ProductionTaskApi productionTaskApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IManualshipmentService manualshipmentService;

    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    @Override
    @Transactional(readOnly=true)
    public CommonResponse saveManualshipment(WeighinginfoApiVO weighinginfoApiVO) {
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),weighinginfoApiVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        //称重方式 = 皮重 只需要保存数据就行
        if(weighinginfoApiVO.getWeighingMethod() == 2){
            //查询第一次进场时的皮重
            QueryWrapper<WeighinginfoEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("is_accounting",1);
            queryWrapper.eq("number_plate",weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq("org_id",weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = this.getOne(queryWrapper);
            if(weighinginfoEntity != null){
                weighinginfoEntity.setIsAccounting(0);
                this.updateById(weighinginfoEntity);
                WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
                weighinginfoEntitys.setIsAccounting(1);
                this.save(weighinginfoEntitys);
            }else {
                WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
                weighinginfoEntitys.setIsAccounting(1);
                this.save(weighinginfoEntitys);
            }
            return CommonResponse.success("保存成功!");
        }
        //称重方式 = 一次称重 调取主数据接口获取运输商信息和调取生产接口获取生产任务信息
        if(weighinginfoApiVO.getWeighingMethod() == 0){
            //接口返回的信息
            ProductionTaskApiVo productionTaskApiVo = this.productionTaskApiVo(String.valueOf(weighinginfoApiVO.getProductiontaskId()),weighinginfoApiVO.getNumberPlate());
            //生成自动发货单
            ManualshipmentEntity manualshipmentEntity = new ManualshipmentEntity();
            manualshipmentEntity.setBillCode(billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            manualshipmentEntity.setShipDate(new Date());
            manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
            manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
            manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setFreightStatus(1);
            // 接口返回的皮重需要修改
            manualshipmentEntity.setTare(productionTaskApiVo.getTare());
            // 净重 = 毛重 -皮重
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(productionTaskApiVo.getTare()));
            manualshipmentEntity.setShippingMethod(0);
            manualshipmentEntity.setFreightStatus(1);
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            //计算运费
            BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(),manualshipmentEntity.getNetWeight(),productionTaskApiVo.getShipperfareVOS());
            manualshipmentEntity.setFreight(freight);
            //保存数据
            manualshipmentService.save(manualshipmentEntity);
            //将本条数据保存到临时表中
            WeighinginfoEntity weighinginfoEntity = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
            weighinginfoEntity.setIsAccounting(0);
            this.save(weighinginfoEntity);
        }
        if(weighinginfoApiVO.getWeighingMethod() == 1){
            //接口返回的信息
            ProductionTaskApiVo productionTaskApiVo = this.productionTaskApiVo(String.valueOf(weighinginfoApiVO.getProductiontaskId()),weighinginfoApiVO.getNumberPlate());
            //生成自动发货单
            ManualshipmentEntity manualshipmentEntity = new ManualshipmentEntity();
            manualshipmentEntity.setBillCode(billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            manualshipmentEntity.setShipDate(new Date());
            manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
            manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
            manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setFreightStatus(1);
            //
            QueryWrapper<WeighinginfoEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("is_accounting",1);
            queryWrapper.eq("number_plate",weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq("org_id",weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = this.getOne(queryWrapper);
            manualshipmentEntity.setTare(weighinginfoEntity.getWeight());
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(weighinginfoEntity.getWeight()));
            manualshipmentEntity.setShippingMethod(0);
            manualshipmentEntity.setFreightStatus(1);
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            // 计算运费
            BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(),manualshipmentEntity.getNetWeight(),productionTaskApiVo.getShipperfareVOS());
            manualshipmentEntity.setFreight(freight);
            //保存数据
            manualshipmentService.save(manualshipmentEntity);
            //将上条数据的核算信息修改
            weighinginfoEntity.setIsAccounting(0);
            this.updateById(weighinginfoEntity);
            //将本条数据保存到临时表中
            WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
            weighinginfoEntitys.setIsAccounting(1);
            weighinginfoEntitys.setFirstTimeId(weighinginfoEntity.getId());
            this.save(weighinginfoEntitys);
        }
        return CommonResponse.success("生成成功!");
    }

    //调用接口将接口数据放入返回数据vo中
    private ProductionTaskApiVo productionTaskApiVo(String taskId, String carCode){
        CommonResponse<com.ejianc.business.production.task.vo.ProductionTaskApiVo> productionTaskApiVo =  productionTaskApi.getproductiontask(taskId,carCode);
        ProductionTaskApiVo productionTaskVo = new ProductionTaskApiVo();
        if(productionTaskApiVo.getCode() == 0){
            productionTaskVo.setProductId(productionTaskApiVo.getData().getProductId());
            productionTaskVo.setProductName(productionTaskApiVo.getData().getProductName());
            productionTaskVo.setProjectId(productionTaskApiVo.getData().getProjectId());
            productionTaskVo.setProjectName(productionTaskApiVo.getData().getProjectName());
            productionTaskVo.setCustomerManageId(productionTaskApiVo.getData().getCustomerManageId());
            productionTaskVo.setCustomerManageName(productionTaskApiVo.getData().getCustomerManageName());
            productionTaskVo.setDistance(productionTaskApiVo.getData().getDistance());
            productionTaskVo.setShipperId(productionTaskApiVo.getData().getShipperId());
            productionTaskVo.setShipperMName(productionTaskApiVo.getData().getShipperMName());
            productionTaskVo.setShipperVehicleId(productionTaskApiVo.getData().getShipperVehicleId());
            productionTaskVo.setShipperVehicleName(productionTaskApiVo.getData().getShipperVehicleName());
            productionTaskVo.setWorksiteId(productionTaskApiVo.getData().getWorksiteId());
            productionTaskVo.setWorksiteName(productionTaskApiVo.getData().getWorksiteName());
            productionTaskVo.setShipperfareVOS(productionTaskApiVo.getData().getShippersfareVOS());
            productionTaskVo.setOrgId(productionTaskApiVo.getData().getOrgId());
            productionTaskVo.setOrgName(productionTaskApiVo.getData().getOrgName());
            productionTaskVo.setTare(productionTaskApiVo.getData().getTare());
        }else{
            throw  new BusinessException(productionTaskApiVo.getMsg());
        }
        return productionTaskVo;
    }
    //计算运费
    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShipperfareVO> shippersfareVO){
        BigDecimal freight = new BigDecimal(0.0);
        if(distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0){
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }else{
            for (int i = 0; i < shippersfareVO.size(); i++) {
                if(i == 0){
                    freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                    continue;
                }else {
                    if(distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0){
                        //最终距离 - 开始距离
                        BigDecimal distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        continue;
                    }else {
                        //最终距离 - 开始距离
                        BigDecimal distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        break;
                    }
                }
            }
        }
        return freight;
    }


}
