package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 合同目标
 * 
 * @author generator
 * 
 */
public class ContactAimVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy", timezone = "GMT+8")
    private Date year; // 年度
    private BigDecimal thisYearAim; // 本年度合同目标金额
    private BigDecimal lastYearContactThis; // 本市上年结转合同额
    private BigDecimal lastYearContactOther; // 外埠上年结转合同额
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Date getYear() {
        return year;
    }

    public void setYear(Date year) {
        this.year = year;
    }
    public BigDecimal getThisYearAim() {
        return thisYearAim;
    }

    public void setThisYearAim(BigDecimal thisYearAim) {
        this.thisYearAim = thisYearAim;
    }
    public BigDecimal getLastYearContactThis() {
        return lastYearContactThis;
    }

    public void setLastYearContactThis(BigDecimal lastYearContactThis) {
        this.lastYearContactThis = lastYearContactThis;
    }
    public BigDecimal getLastYearContactOther() {
        return lastYearContactOther;
    }

    public void setLastYearContactOther(BigDecimal lastYearContactOther) {
        this.lastYearContactOther = lastYearContactOther;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
}
