package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sale.vo.SignfreightdetailVO;

/**
 * 运费签认单
 * 
 * @author generator
 * 
 */
public class SignfreightVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long transportId; // 运输商主键
    private String transportName; // 运输商名称
    private BigDecimal checkTotalMoney; // 勾选总金额
    private BigDecimal signMoney; // 签认金额
    private Integer paymentStatus; // 付款状态  0-付款完成 1-未付款 2-部分付款
    private BigDecimal paymentMoney; // 已付款金额
    private BigDecimal notPaymentMoney; // 未付款金额
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String abstracts; // 摘要
    
    private List<SignfreightdetailVO> signfreightdetailList = new ArrayList<>(); // 运费签认单子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getTransportId() {
        return transportId;
    }

    @ReferDeserialTransfer
    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getCheckTotalMoney() {
        return checkTotalMoney;
    }

    public void setCheckTotalMoney(BigDecimal checkTotalMoney) {
        this.checkTotalMoney = checkTotalMoney;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }
    public BigDecimal getPaymentMoney() {
        return paymentMoney;
    }

    public void setPaymentMoney(BigDecimal paymentMoney) {
        this.paymentMoney = paymentMoney;
    }
    public BigDecimal getNotPaymentMoney() {
        return notPaymentMoney;
    }

    public void setNotPaymentMoney(BigDecimal notPaymentMoney) {
        this.notPaymentMoney = notPaymentMoney;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    
     public List<SignfreightdetailVO> getSignfreightdetailList() {
        return signfreightdetailList;
     }

     public void setSignfreightdetailList(List<SignfreightdetailVO> signfreightdetailList) {
        this.signfreightdetailList = signfreightdetailList;
     }
}
