package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 销售合同
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_contract")
public class ContractEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="customer_manage_id")
    private Long customerManageId; // 客户管理档案id
    @TableField(value="customer_manage_name")
    private String customerManageName; // 客户管理档案名称
    @TableField(value="project_id")
    private Long projectId; // 工程id
    @TableField(value="project_name")
    private String projectName; // 工程名称
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="is_this_city")
    private Integer isThisCity; // 是否在本市:1 是 0 否
    @TableField(value="contract_amount")
    private BigDecimal contractAmount; // 合同金额
    @TableField(value="year")
    private Date year; // 所在年
    @TableField(value="month")
    private Integer month; // 所在月
    @TableField(value="week")
    private Integer week; // 所在周
    @TableField(value="address")
    private String address; // 项目地点
    @TableField(value="remark")
    private String remark; // 备注
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="change_id")
    private Long changeId; // 变更单据id
    @TableField(value="change_state")
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="pessession")
    private Long pessession; // 项目属地
    @TableField(value="contract_time")
    private Date contractTime; // 合同日期
    @TableField(value="serial_number")
    private String serialNumber; // 流水号
    @TableField(value="dept")
    private Long dept; // 部门
    @TableField(value="dept_name")
    private String deptName; // 部门名称
    @TableField(value="agent_id")
    private Long agentId; // 经办人id
    @TableField(value="agent_name")
    private String agentName; // 经办人名称
    @TableField(value="contract_type")
    private String contractType; // 合同类型
    @TableField(value="contract_category")
    private String contractCategory; // 合同类别
    @TableField(value="relative_type")
    private String relativeType; // 相对方类型
    @TableField(value="credit_code")
    private String creditCode; // 信用代码
    @TableField(value="id_number")
    private String idNumber; // 身份证号
    @TableField(value="opposite_party")
    private String oppositeParty; // 相对方
    @TableField(value="counterparty_contat")
    private String counterpartyContat; // 相对方联系人
    @TableField(value="contact_information")
    private String contactInformation; // 联系方式
    @TableField(value="content")
    private String content; // 合同内容简要叙述
    @TableField(value="payment_request")
    private String paymentRequest; // 合同履约方式和付款要求
    @TableField(value="signed_number")
    private Integer signedNumber; // 签订份数
    @TableField(value="describes")
    private String describes; // 合同持有情况描述
    @TableField(value="subject_matter")
    private String subjectMatter; // 标的物
    @TableField(value="money_capital")
    private String moneyCapital; // 金额大写
    @TableField(value="is_major_contracts")
    private Long isMajorContracts; // 是否属于重大合同


    @TableField(exist=false)
    @SubEntity(serviceName="contractdetatilService",pidName = "mid")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractdetatilEntity> contractdetatilList = new ArrayList<>(); // 工程产品信息
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getCustomerManageId() {
        return customerManageId;
    }

    public void setCustomerManageId(Long customerManageId) {
        this.customerManageId = customerManageId;
    }
    public String getCustomerManageName() {
        return customerManageName;
    }

    public void setCustomerManageName(String customerManageName) {
        this.customerManageName = customerManageName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getIsThisCity() {
        return isThisCity;
    }

    public void setIsThisCity(Integer isThisCity) {
        this.isThisCity = isThisCity;
    }
    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }
    public Date getYear() {
        return year;
    }

    public void setYear(Date year) {
        this.year = year;
    }
    public Integer getMonth() {
        return month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }
    public Integer getWeek() {
        return week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Long getPessession() {
        return pessession;
    }

    public void setPessession(Long pessession) {
        this.pessession = pessession;
    }

    public List<ContractdetatilEntity> getContractdetatilList() {
        return contractdetatilList;
    }

    public void setContractdetatilList(List<ContractdetatilEntity> contractdetatilList) {
        this.contractdetatilList = contractdetatilList;
    }

    public Date getContractTime() {
        return contractTime;
    }

    public void setContractTime(Date contractTime) {
        this.contractTime = contractTime;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Long getDept() {
        return dept;
    }

    public void setDept(Long dept) {
        this.dept = dept;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType;
    }

    public String getContractCategory() {
        return contractCategory;
    }

    public void setContractCategory(String contractCategory) {
        this.contractCategory = contractCategory;
    }

    public String getRelativeType() {
        return relativeType;
    }

    public void setRelativeType(String relativeType) {
        this.relativeType = relativeType;
    }

    public String getCreditCode() {
        return creditCode;
    }

    public void setCreditCode(String creditCode) {
        this.creditCode = creditCode;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public String getOppositeParty() {
        return oppositeParty;
    }

    public void setOppositeParty(String oppositeParty) {
        this.oppositeParty = oppositeParty;
    }

    public String getCounterpartyContat() {
        return counterpartyContat;
    }

    public void setCounterpartyContat(String counterpartyContat) {
        this.counterpartyContat = counterpartyContat;
    }

    public String getContactInformation() {
        return contactInformation;
    }

    public void setContactInformation(String contactInformation) {
        this.contactInformation = contactInformation;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getPaymentRequest() {
        return paymentRequest;
    }

    public void setPaymentRequest(String paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public Integer getSignedNumber() {
        return signedNumber;
    }

    public void setSignedNumber(Integer signedNumber) {
        this.signedNumber = signedNumber;
    }

    public String getDescribes() {
        return describes;
    }

    public void setDescribes(String describes) {
        this.describes = describes;
    }

    public String getSubjectMatter() {
        return subjectMatter;
    }

    public void setSubjectMatter(String subjectMatter) {
        this.subjectMatter = subjectMatter;
    }

    public String getMoneyCapital() {
        return moneyCapital;
    }

    public void setMoneyCapital(String moneyCapital) {
        this.moneyCapital = moneyCapital;
    }

    public Long getIsMajorContracts() {
        return isMajorContracts;
    }

    public void setIsMajorContracts(Long isMajorContracts) {
        this.isMajorContracts = isMajorContracts;
    }
}
