package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.PaymentEntity;
import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.OpeninvoiceMapper;
import com.ejianc.business.sale.bean.OpeninvoiceEntity;
import com.ejianc.business.sale.service.IOpeninvoiceService;

/**
 * 开票信息
 * 
 * @author generator
 * 
 */
@Service("openinvoiceService")
public class OpeninvoiceServiceImpl extends BaseServiceImpl<OpeninvoiceMapper, OpeninvoiceEntity> implements IOpeninvoiceService{

    @Autowired
    private ProjectInfoMapper projectInfoMapper;

    @Override
    public IPage<OpeninvoiceEntity> getOpeninvoice(QueryParam param) {
        IPage<OpeninvoiceEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        IPage<OpeninvoiceEntity> page1 = this.projectInfoMapper.getOpeninvoice(page, new QueryWrapper<OpeninvoiceEntity>()
                .eq("tenant_id",param.getParams().get("tenantId").getValue())
                .eq("dr","0")
                .eq("signfreight_id",param.getParams().get("signfreightId").getValue())
                .orderByDesc("create_time"));
        return page1;
    }
}
