/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesreconciliationEntity;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.business.sale.vo.SalesreconciliationVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"salesreconciliation"})
public class SalesreconciliationController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sale-salesreconciliation";
    private static final String CODE = "sale-salesorder";
    @Autowired
    private ISalesreconciliationService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    @Transient
    public CommonResponse<SalesreconciliationVO> saveOrUpdate(@RequestBody SalesreconciliationVO saveOrUpdateVO) {
        SalesreconciliationEntity entity = (SalesreconciliationEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SalesreconciliationEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setStatus(0);
                entity.setBillCode((String)billCode.getData());
                if (entity.getAdjustmentAmount().signum() > 0) {
                    SalesorderVO salesorderVO = new SalesorderVO();
                    salesorderVO.setSalesorderType(2);
                    salesorderVO.setProjectId(entity.getProjectId());
                    salesorderVO.setProjectName(entity.getProjectName());
                    salesorderVO.setCustomerId(entity.getCustomerId().toString());
                    salesorderVO.setCustomerName(entity.getCustomerName());
                    salesorderVO.setSaleDate(new Date());
                    salesorderVO.setIsSign(1);
                    Calendar cal = Calendar.getInstance();
                    int month = cal.get(2) + 1;
                    int year = cal.get(1);
                    String mon = "";
                    mon = month < 10 ? "0" + month : String.valueOf(month);
                    salesorderVO.setReceivablesTime(year + "-" + mon);
                    salesorderVO.setReceivablesDate(new Date());
                    salesorderVO.setProfitcenterId(entity.getProfitcenterId());
                    salesorderVO.setProfitcenterName(entity.getProfitcenterName());
                    salesorderVO.setOrgId(entity.getOrgId());
                    salesorderVO.setOrgName(entity.getOrgName());
                    if (entity.getProductId() == null) {
                        salesorderVO.setSalesTotalMoney(entity.getAdjustmentAmount());
                        BillCodeParam codeParam = BillCodeParam.build((String)CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salesorderVO);
                        CommonResponse code = this.billCodeApi.generateBillCode(codeParam);
                        SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)BeanMapper.map((Object)((Object)salesorderVO), SalesorderEntity.class));
                        salesorderEntity.setBillCode((String)code.getData());
                        this.salesorderService.save((Object)salesorderEntity);
                    } else {
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"id", (Object)entity.getProductId());
                        queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
                        ProductorInfoEntity productorInfoEntity = (ProductorInfoEntity)((Object)this.productorInfoService.getOne((Wrapper)queryWrapper));
                        ArrayList<SalesorderdetilsVO> list = new ArrayList<SalesorderdetilsVO>();
                        SalesorderdetilsVO salesorderdetilsVO = new SalesorderdetilsVO();
                        salesorderdetilsVO.setProductId(productorInfoEntity.getProductId());
                        salesorderdetilsVO.setProductName(productorInfoEntity.getProductName());
                        salesorderdetilsVO.setSpecName(productorInfoEntity.getSpecName());
                        salesorderdetilsVO.setStoneName(productorInfoEntity.getStoneName());
                        salesorderdetilsVO.setAsphaltName(productorInfoEntity.getAsphaltName());
                        salesorderdetilsVO.setCategoryId1(productorInfoEntity.getCategoryId1());
                        salesorderdetilsVO.setCategoryName1(productorInfoEntity.getCategoryName1());
                        salesorderdetilsVO.setThousandRate1(productorInfoEntity.getThousandRate1());
                        salesorderdetilsVO.setCategoryId2(productorInfoEntity.getCategoryId2());
                        salesorderdetilsVO.setCategoryName2(productorInfoEntity.getCategoryName2());
                        salesorderdetilsVO.setThousandRate2(productorInfoEntity.getThousandRate2());
                        salesorderdetilsVO.setCategoryId3(productorInfoEntity.getCategoryId3());
                        salesorderdetilsVO.setCategoryName3(productorInfoEntity.getCategoryName3());
                        salesorderdetilsVO.setThousandRate3(productorInfoEntity.getThousandRate3());
                        salesorderdetilsVO.setUnitPrice(productorInfoEntity.getUnitPrice());
                        salesorderdetilsVO.setRowState("add");
                        list.add(salesorderdetilsVO);
                        salesorderVO.setSalesorderdetilsList(list);
                        salesorderVO.setSalesTotalMoney(entity.getAdjustmentAmount());
                        BillCodeParam codeParam = BillCodeParam.build((String)CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salesorderVO);
                        CommonResponse code = this.billCodeApi.generateBillCode(codeParam);
                        SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)BeanMapper.map((Object)((Object)salesorderVO), SalesorderEntity.class));
                        if (!code.isSuccess()) {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        salesorderEntity.setBillCode((String)code.getData());
                        this.salesorderService.saveOrUpdate((Object)salesorderEntity, false);
                    }
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        SalesreconciliationVO vo = (SalesreconciliationVO)((Object)BeanMapper.map((Object)((Object)entity), SalesreconciliationVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesreconciliationVO> queryDetail(Long id) {
        SalesreconciliationEntity entity = (SalesreconciliationEntity)((Object)this.service.selectById(id));
        SalesreconciliationVO vo = (SalesreconciliationVO)((Object)BeanMapper.map((Object)((Object)entity), SalesreconciliationVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"salesreconciliation_id", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"is_Sign", (Object)0);
        List salesorderEntity = this.salesorderService.list((Wrapper)queryWrapper);
        if (salesorderEntity != null) {
            vo.setSalesorderVO(BeanMapper.mapList((Iterable)salesorderEntity, SalesorderVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesreconciliationVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SalesreconciliationVO salesreconciliationVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SalesreconciliationVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesreconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Salesreconciliation-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSalesreconciliationData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SalesreconciliationVO>> refSalesreconciliationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        String customerId;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (customerId = (_con = JSONObject.parseObject((String)condition)).getString("customerId")) != null) {
            param.getParams().put("customer_id", new Parameter("eq", (Object)customerId));
            param.getParams().put("status", new Parameter("eq", (Object)"0"));
            param.getParams().put("adjustment_amount", new Parameter("lt", (Object)new BigDecimal(0.0)));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SalesreconciliationVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getMoney"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SalesreconciliationVO> getMoney(@RequestParam String customerId, String projectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"sum(sales_total_money) as total"});
        queryWrapper.eq((Object)"customer_id", (Object)customerId);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        Map map = this.salesorderService.getMap((Wrapper)queryWrapper);
        Double total = map == null ? Double.valueOf(0.0) : Double.valueOf(String.valueOf(map.get("total")));
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.select(new String[]{"sum(received_moeny) as received"});
        queryWrapper1.eq((Object)"customer_id", (Object)customerId);
        queryWrapper1.eq((Object)"project_id", (Object)projectId);
        queryWrapper1.isNotNull((Object)"received_moeny");
        Map map1 = this.salesorderService.getMap((Wrapper)queryWrapper1);
        Double received = map1 == null ? Double.valueOf(0.0) : Double.valueOf(String.valueOf(map1.get("received")));
        SalesreconciliationVO salesreconciliationVO = new SalesreconciliationVO();
        salesreconciliationVO.setTotalAmount(BigDecimal.valueOf(total));
        salesreconciliationVO.setUncollectedAmount(BigDecimal.valueOf(total - received));
        return CommonResponse.success((String)"\u67e5\u8be2\u91d1\u989d\u6210\u529f\uff01", (Object)((Object)salesreconciliationVO));
    }
}

