/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesreconciliationEntity;
import com.ejianc.business.sale.bean.SignEntity;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.service.ISignService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesreconciliationVO;
import com.ejianc.business.sale.vo.SignVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sign"})
public class SignController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISignService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private ISalesreconciliationService salesreconciliationService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public CommonResponse<SignVO> saveOrUpdate(@RequestBody SignVO saveOrUpdateVO) {
        SignEntity entity = (SignEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), SignEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setSignStatus(1);
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setSignMoney(new BigDecimal(0.0));
        entity.setSignBalance(entity.getBookTotalMoney());
        this.service.saveOrUpdate((Object)entity, false);
        if (saveOrUpdateVO.getSalesreconciliationVO().size() == 0) {
            for (Object salesorderVO : saveOrUpdateVO.getSalesorderVO()) {
                SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getById(salesorderVO.getId()));
                if (salesorderEntity == null) continue;
                salesorderEntity.setSignId(entity.getId());
                salesorderEntity.setIsSign(2);
                if (salesorderVO.getAccountAdjustmentMoeny() == null) {
                    salesorderEntity.setAccountAdjustmentMoeny(new BigDecimal(0.0));
                } else {
                    salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                }
                this.salesorderService.updateById((Object)salesorderEntity);
            }
        } else {
            entity.setReceivablesMoney(saveOrUpdateVO.getBookTotalMoney().subtract(saveOrUpdateVO.getSalesreconciliationVO().get(0).getDistributionMoeny()));
            SalesreconciliationEntity salesreconciliationEntity = (SalesreconciliationEntity)((Object)this.salesreconciliationService.getById(saveOrUpdateVO.getSalesreconciliationVO().get(0).getSalesreconciliationId()));
            if (salesreconciliationEntity != null) {
                salesreconciliationEntity.setSignId(entity.getId());
                salesreconciliationEntity.setDistributionMoeny(saveOrUpdateVO.getSalesreconciliationVO().get(0).getDistributionMoeny());
                salesreconciliationEntity.setStatus(2);
                this.salesreconciliationService.updateById((Object)salesreconciliationEntity);
            }
            for (SalesorderVO salesorderVO : saveOrUpdateVO.getSalesorderVO()) {
                Object salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getById(salesorderVO.getId()));
                if (salesorderEntity == null) continue;
                salesorderEntity.setSignId(entity.getId());
                salesorderEntity.setSalesreconciliationId(salesreconciliationEntity.getId());
                if (salesorderVO.getAccountAdjustmentMoeny() == null) {
                    salesorderEntity.setAccountAdjustmentMoeny(new BigDecimal(0.0));
                } else {
                    salesorderEntity.setAccountAdjustmentMoeny(salesorderVO.getAccountAdjustmentMoeny());
                }
                salesorderEntity.setIsSign(2);
                this.salesorderService.updateById(salesorderEntity);
            }
        }
        SignVO vo = (SignVO)((Object)BeanMapper.map((Object)((Object)entity), SignVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"status", (Object)2);
        List salesreconciliationVO = BeanMapper.mapList((Iterable)this.salesreconciliationService.list((Wrapper)queryWrapper), SalesreconciliationVO.class);
        if (salesreconciliationVO != null) {
            for (SalesreconciliationVO salesreconciliation : salesreconciliationVO) {
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny()));
            }
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        queryWrapper1.eq((Object)"is_Sign", (Object)2);
        List salesorderList = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper1), SalesorderVO.class);
        if (salesorderList != null) {
            vo.setSalesorderList(salesorderList);
        }
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"customer_name", (Object)entity.getCustomerName());
        queryWrapper2.eq((Object)"dr", (Object)0);
        queryWrapper2.eq((Object)"is_Sign", (Object)1);
        List salesorderVO = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper2), SalesorderVO.class);
        if (salesorderVO != null) {
            vo.setSalesorderVO(salesorderVO);
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SignVO> queryDetail(Long id) {
        SignEntity entity = (SignEntity)((Object)this.service.selectById(id));
        SignVO vo = (SignVO)((Object)BeanMapper.map((Object)((Object)entity), SignVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        if (vo.getSignStatus().equals(1)) {
            queryWrapper.eq((Object)"status", (Object)2);
        } else {
            queryWrapper.eq((Object)"status", (Object)1);
        }
        List salesreconciliationVO = BeanMapper.mapList((Iterable)this.salesreconciliationService.list((Wrapper)queryWrapper), SalesreconciliationVO.class);
        if (salesreconciliationVO != null) {
            for (SalesreconciliationVO salesreconciliation : salesreconciliationVO) {
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny()));
            }
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        if (vo.getSignStatus().equals(1)) {
            queryWrapper1.eq((Object)"is_Sign", (Object)2);
        } else {
            queryWrapper1.eq((Object)"is_Sign", (Object)0);
        }
        List salesorderlist = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper1), SalesorderVO.class);
        if (salesorderlist != null) {
            vo.setSalesorderList(salesorderlist);
        }
        QueryWrapper queryWrapper2 = new QueryWrapper();
        queryWrapper2.eq((Object)"customer_name", (Object)entity.getCustomerName());
        queryWrapper2.eq((Object)"dr", (Object)0);
        queryWrapper2.eq((Object)"is_Sign", (Object)1);
        List salesorderVO = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper2), SalesorderVO.class);
        if (salesorderVO != null) {
            vo.setSalesorderVO(salesorderVO);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SignVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (SignVO signVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        for (SignVO signVO : vos) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"sign_id", (Object)signVO.getId());
            SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getOne((Wrapper)queryWrapper));
            salesorderEntity.setSignId(null);
            salesorderEntity.setSalesreconciliationId(null);
            salesorderEntity.setAccountAdjustmentMoeny(null);
            salesorderEntity.setIsSign(1);
            this.salesorderService.updateById((Object)salesorderEntity);
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper.eq((Object)"sign_id", (Object)signVO.getId());
            SalesreconciliationEntity salesreconciliationEntity = (SalesreconciliationEntity)((Object)this.salesreconciliationService.getOne((Wrapper)queryWrapper1));
            salesreconciliationEntity.setSignId(null);
            salesreconciliationEntity.setDistributionMoeny(null);
            salesreconciliationEntity.setStatus(0);
            this.salesreconciliationService.updateById((Object)salesreconciliationEntity);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SignVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Sign-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSignData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SignVO>> refSignData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SignVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"signId"})
    @ResponseBody
    public CommonResponse<SignVO> signId(@RequestParam(value="signId") Long signId) {
        SignEntity signEntity = (SignEntity)((Object)this.service.selectById(signId));
        signEntity.setSignMoney(signEntity.getSignBalance());
        SignVO signVO = (SignVO)((Object)BeanMapper.map((Object)((Object)signEntity), SignVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_id", (Object)signEntity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"status", (Object)2);
        List salesreconciliationVO = BeanMapper.mapList((Iterable)this.salesreconciliationService.list((Wrapper)queryWrapper), SalesreconciliationVO.class);
        if (salesreconciliationVO != null) {
            for (SalesreconciliationVO salesreconciliation : salesreconciliationVO) {
                salesreconciliation.setSalesreconciliationId(salesreconciliation.getId());
                salesreconciliation.setAdjustmentBalance(salesreconciliation.getAdjustmentAmount().subtract(salesreconciliation.getDistributionMoeny().abs()));
            }
            signVO.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"sign_id", (Object)signEntity.getId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        queryWrapper1.eq((Object)"is_Sign", (Object)2);
        List salesorderlist = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper1), SalesorderVO.class);
        if (salesorderlist != null) {
            signVO.setSalesorderList(salesorderlist);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6210\u529f\uff01", (Object)((Object)signVO));
    }

    @RequestMapping(value={"/sign"}, method={RequestMethod.POST})
    @ResponseBody
    @Transactional
    public CommonResponse<SignVO> saveSign(@RequestBody SignVO saveVO) {
        SignEntity entity = (SignEntity)((Object)this.service.getById(saveVO.getId()));
        entity.setSignMoney(saveVO.getSignMoney());
        entity.setSignBalance(new BigDecimal(0.0));
        entity.setSignStatus(0);
        entity.setSignTime(new Date());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(1, 2);
        entity.setFailureTime(cal.getTime());
        this.service.updateById((Object)entity);
        if (saveVO.getSalesreconciliationVO().size() > 0) {
            SalesreconciliationEntity salesreconciliationEntity = (SalesreconciliationEntity)((Object)this.salesreconciliationService.getById(saveVO.getSalesreconciliationVO().get(0).getSalesreconciliationId()));
            salesreconciliationEntity.setAdjustmentBalance(salesreconciliationEntity.getAdjustmentAmount().subtract(salesreconciliationEntity.getDistributionMoeny()));
            if (salesreconciliationEntity.getAdjustmentBalance().doubleValue() == 0.0) {
                salesreconciliationEntity.setStatus(1);
            }
            this.salesreconciliationService.updateById((Object)salesreconciliationEntity);
        }
        if (saveVO.getSalesorderList().size() > 0) {
            for (SalesorderVO salesorderVO : saveVO.getSalesorderList()) {
                SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getById(salesorderVO.getId()));
                salesorderEntity.setIsSign(0);
                salesorderEntity.setSignDate(new Date());
                salesorderEntity.setReceivedMoeny(new BigDecimal(0.0));
                salesorderEntity.setInvoiceMoeny(new BigDecimal(0.0));
                if (salesorderEntity.getAccountAdjustmentMoeny() != null) {
                    salesorderEntity.setUncollectedMoeny(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
                    salesorderEntity.setNotInvoiceMoeny(salesorderEntity.getSalesTotalMoney().subtract(salesorderEntity.getAccountAdjustmentMoeny()));
                }
                this.salesorderService.updateById((Object)salesorderEntity);
            }
        }
        SignVO vo = (SignVO)((Object)BeanMapper.map((Object)((Object)entity), SignVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"status", (Object)1);
        List salesreconciliationVO = BeanMapper.mapList((Iterable)this.salesreconciliationService.list((Wrapper)queryWrapper), SalesreconciliationVO.class);
        if (salesreconciliationVO != null) {
            vo.setSalesreconciliationVO(salesreconciliationVO);
        }
        QueryWrapper queryWrapper1 = new QueryWrapper();
        queryWrapper1.eq((Object)"sign_id", (Object)entity.getId());
        queryWrapper1.eq((Object)"dr", (Object)0);
        queryWrapper1.eq((Object)"is_Sign", (Object)0);
        List salesorderlist = BeanMapper.mapList((Iterable)this.salesorderService.list((Wrapper)queryWrapper1), SalesorderVO.class);
        if (salesorderlist != null) {
            vo.setSalesorderList(salesorderlist);
        }
        return CommonResponse.success((String)"\u7b7e\u8ba4\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

