/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.InvoiceEntity;
import com.ejianc.business.sale.bean.InvoicedetialEntity;
import com.ejianc.business.sale.bean.ReceivablessummaryEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.service.IInvoiceService;
import com.ejianc.business.sale.service.IInvoicedetialService;
import com.ejianc.business.sale.service.IReceivablessummaryService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="invoice")
public class InvoiceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceService invoiceService;
    @Autowired
    private IInvoicedetialService invoicedetialService;
    @Autowired
    private IReceivablessummaryService receivablessummaryService;
    @Autowired
    private ISalesorderService salesorderService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        InvoiceEntity invoiceEntity = (InvoiceEntity)((Object)this.invoiceService.selectById(billId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"DISTINCT receivables_time"});
        queryWrapper.eq((Object)"mid", (Object)invoiceEntity.getId());
        List invoicedetialList = this.invoicedetialService.list((Wrapper)queryWrapper);
        for (InvoicedetialEntity invoicedetialEntity : invoicedetialList) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"mid", (Object)invoiceEntity.getId());
            wrapper.eq((Object)"receivables_time", (Object)invoicedetialEntity.getReceivablesTime());
            wrapper.select(new String[]{"sum(distribution_money) as total "});
            Map map = this.invoicedetialService.getMap((Wrapper)wrapper);
            Double total = Double.valueOf(String.valueOf(map.get("total")));
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                QueryWrapper queryWrapper1 = new QueryWrapper();
                queryWrapper1.eq((Object)"mid", (Object)invoiceEntity.getId());
                queryWrapper1.eq((Object)"consignment_date", (Object)sdf.parse(invoicedetialEntity.getReceivablesTime()));
                ReceivablessummaryEntity receivablessummaryEntity = (ReceivablessummaryEntity)((Object)this.receivablessummaryService.getOne((Wrapper)queryWrapper1));
                if (receivablessummaryEntity != null) {
                    receivablessummaryEntity.setSummaryMoney(BigDecimal.valueOf(total));
                    this.receivablessummaryService.updateById((Object)receivablessummaryEntity);
                    continue;
                }
                ReceivablessummaryEntity receivablessummaryVO = new ReceivablessummaryEntity();
                receivablessummaryVO.setMid(invoiceEntity.getId());
                receivablessummaryVO.setConsignmentDate(sdf.parse(invoicedetialEntity.getReceivablesTime()));
                receivablessummaryVO.setSummaryMoney(BigDecimal.valueOf(total));
                this.receivablessummaryService.saveOrUpdate((Object)receivablessummaryVO, false);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------\u8fdb\u6765\u5566--------");
        InvoiceEntity invoiceEntity = (InvoiceEntity)((Object)this.invoiceService.selectById(billId));
        if (invoiceEntity.getInvoicedetialList() != null) {
            this.logger.info("---------\u4e0d\u4e3a\u7a7a--------");
            for (InvoicedetialEntity invoicedetial : invoiceEntity.getInvoicedetialList()) {
                SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getById(invoicedetial.getSaleId()));
                salesorderEntity.setInvoiceMoeny(invoicedetial.getDistributionMoney().add(salesorderEntity.getInvoiceMoeny()));
                salesorderEntity.setNotInvoiceMoeny(salesorderEntity.getNotInvoiceMoeny().subtract(invoicedetial.getDistributionMoney()));
                if (salesorderEntity.getNotInvoiceMoeny().doubleValue() == 0.0) {
                    salesorderEntity.setIsInvoice(0);
                } else {
                    salesorderEntity.setIsInvoice(1);
                }
                this.logger.info("---------\u5df2\u4fee\u65391--------");
                this.salesorderService.updateById((Object)salesorderEntity);
                invoicedetial.setReceivedMoney(invoicedetial.getDistributionMoney());
                invoicedetial.setUncollectedMoney(invoicedetial.getInvoiceMoney().subtract(invoicedetial.getDistributionMoney().add(invoicedetial.getOtherReceivedMoney())));
                this.logger.info("---------\u5df2\u4fee\u65392--------");
                this.invoicedetialService.updateById((Object)invoicedetial);
            }
        }
        this.logger.info("---------\u7ed3\u675f--------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

