/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.task.api.ProductionTaskApi;
import com.ejianc.business.production.task.vo.ShipperfareVO;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.bean.WeighinginfoEntity;
import com.ejianc.business.sale.mapper.WeighinginfoMapper;
import com.ejianc.business.sale.salesorder.vo.ProductionTaskApiVo;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="weighinginfoService")
public class WeighinginfoServiceImpl
extends BaseServiceImpl<WeighinginfoMapper, WeighinginfoEntity>
implements IWeighinginfoService {
    @Qualifier(value="com.ejianc.business.production.task.api.ProductionTaskApi")
    @Autowired
    private ProductionTaskApi productionTaskApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IManualshipmentService manualshipmentService;
    private static final String BILL_CODE = "sale-manualshipment";

    @Override
    @Transactional(readOnly=true)
    public CommonResponse saveManualshipment(WeighinginfoApiVO weighinginfoApiVO) {
        CommonResponse commonResponse;
        ManualshipmentEntity manualshipmentEntity;
        BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)weighinginfoApiVO);
        CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
        ProductionTaskApiVo productionTaskApiVo = this.productionTaskApiVo(String.valueOf(weighinginfoApiVO.getProductiontaskId()), weighinginfoApiVO.getNumberPlate());
        if (weighinginfoApiVO.getWeighingMethod() == 2) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"is_accounting", (Object)1);
            queryWrapper.eq((Object)"number_plate", (Object)weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq((Object)"org_id", (Object)weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = (WeighinginfoEntity)((Object)this.getOne((Wrapper)queryWrapper));
            if (weighinginfoEntity != null) {
                weighinginfoEntity.setIsAccounting(0);
                this.updateById((Object)weighinginfoEntity);
                WeighinginfoEntity weighinginfoEntitys = (WeighinginfoEntity)((Object)BeanMapper.map((Object)weighinginfoApiVO, WeighinginfoEntity.class));
                weighinginfoEntitys.setIsAccounting(1);
                this.save((Object)weighinginfoEntitys);
            } else {
                WeighinginfoEntity weighinginfoEntitys = (WeighinginfoEntity)((Object)BeanMapper.map((Object)weighinginfoApiVO, WeighinginfoEntity.class));
                weighinginfoEntitys.setIsAccounting(1);
                this.save((Object)weighinginfoEntitys);
            }
            return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f!");
        }
        if (weighinginfoApiVO.getWeighingMethod() == 0) {
            manualshipmentEntity = new ManualshipmentEntity();
            manualshipmentEntity.setBillCode((String)billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            manualshipmentEntity.setShipDate(new Date());
            manualshipmentEntity.setNumberPlateId(productionTaskApiVo.getTransPortId());
            manualshipmentEntity.setUnitId(productionTaskApiVo.getUnitId());
            manualshipmentEntity.setUnitName(productionTaskApiVo.getUnitName());
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setOrderName(productionTaskApiVo.getOrderName());
            manualshipmentEntity.setOrderMobile(productionTaskApiVo.getOrderMobile());
            manualshipmentEntity.setTransportRoute(productionTaskApiVo.getTransportRoute());
            manualshipmentEntity.setTaskId(weighinginfoApiVO.getProductiontaskId().toString());
            manualshipmentEntity.setPrintCustomer(productionTaskApiVo.getPrintCustomerName());
            manualshipmentEntity.setPrintConstruction(productionTaskApiVo.getPrintWorksiteName());
            manualshipmentEntity.setPrintProducts(productionTaskApiVo.getPrintProductName());
            manualshipmentEntity.setPrintSupplier(productionTaskApiVo.getPrintSupplyName());
            manualshipmentEntity.setInspection("\u5408\u683c");
            manualshipmentEntity.setShipDates(new Date());
            manualshipmentEntity.setReceiptStatus(1);
            manualshipmentEntity.setTare(productionTaskApiVo.getTare());
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(productionTaskApiVo.getTare()));
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            if (productionTaskApiVo.getTransportMethod().equals("\u4ee3\u8fd0")) {
                manualshipmentEntity.setShippingMethod(0);
                manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
                manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
                manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
                BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(), manualshipmentEntity.getNetWeight(), productionTaskApiVo.getShipperfareVOS());
                manualshipmentEntity.setFreight(freight);
            } else {
                manualshipmentEntity.setShippingMethod(1);
                manualshipmentEntity.setFreight(new BigDecimal(0.0));
            }
            this.manualshipmentService.save((Object)manualshipmentEntity);
            WeighinginfoEntity weighinginfoEntity = (WeighinginfoEntity)((Object)BeanMapper.map((Object)weighinginfoApiVO, WeighinginfoEntity.class));
            weighinginfoEntity.setIsAccounting(0);
            this.save((Object)weighinginfoEntity);
        }
        if (weighinginfoApiVO.getWeighingMethod() == 1) {
            manualshipmentEntity = new ManualshipmentEntity();
            manualshipmentEntity.setBillCode((String)billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            manualshipmentEntity.setShipDate(new Date());
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setNumberPlateId(productionTaskApiVo.getTransPortId());
            manualshipmentEntity.setUnitId(productionTaskApiVo.getUnitId());
            manualshipmentEntity.setUnitName(productionTaskApiVo.getUnitName());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setOrderName(productionTaskApiVo.getOrderName());
            manualshipmentEntity.setOrderMobile(productionTaskApiVo.getOrderMobile());
            manualshipmentEntity.setTransportRoute(productionTaskApiVo.getTransportRoute());
            manualshipmentEntity.setTaskId(weighinginfoApiVO.getProductiontaskId().toString());
            manualshipmentEntity.setPrintCustomer(productionTaskApiVo.getPrintCustomerName());
            manualshipmentEntity.setPrintConstruction(productionTaskApiVo.getPrintWorksiteName());
            manualshipmentEntity.setPrintProducts(productionTaskApiVo.getPrintProductName());
            manualshipmentEntity.setPrintSupplier(productionTaskApiVo.getPrintSupplyName());
            manualshipmentEntity.setInspection("\u5408\u683c");
            manualshipmentEntity.setShipDates(new Date());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"is_accounting", (Object)1);
            queryWrapper.eq((Object)"number_plate", (Object)weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq((Object)"org_id", (Object)weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = (WeighinginfoEntity)((Object)this.getOne((Wrapper)queryWrapper));
            manualshipmentEntity.setTare(weighinginfoEntity.getWeight());
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(weighinginfoEntity.getWeight()));
            manualshipmentEntity.setReceiptStatus(1);
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            if (productionTaskApiVo.getTransportMethod().equals("\u4ee3\u8fd0")) {
                manualshipmentEntity.setShippingMethod(0);
                manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
                manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
                manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
                BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(), manualshipmentEntity.getNetWeight(), productionTaskApiVo.getShipperfareVOS());
                manualshipmentEntity.setFreight(freight);
            } else {
                manualshipmentEntity.setShippingMethod(1);
                manualshipmentEntity.setFreight(new BigDecimal(0.0));
            }
            this.manualshipmentService.save((Object)manualshipmentEntity);
            weighinginfoEntity.setIsAccounting(0);
            this.updateById((Object)weighinginfoEntity);
            WeighinginfoEntity weighinginfoEntitys = (WeighinginfoEntity)((Object)BeanMapper.map((Object)weighinginfoApiVO, WeighinginfoEntity.class));
            weighinginfoEntitys.setIsAccounting(1);
            weighinginfoEntitys.setFirstTimeId(weighinginfoEntity.getId());
            this.save((Object)weighinginfoEntitys);
        }
        if ((commonResponse = this.productionTaskApi.updateTransportState(productionTaskApiVo.getTransPortId(), Integer.valueOf(2))).getCode() != 0) {
            throw new BusinessException(commonResponse.getMsg());
        }
        return CommonResponse.success((String)"\u751f\u6210\u6210\u529f!");
    }

    private ProductionTaskApiVo productionTaskApiVo(String taskId, String carCode) {
        CommonResponse productionTaskApiVo = this.productionTaskApi.getproductiontask(taskId, carCode);
        ProductionTaskApiVo productionTaskVo = new ProductionTaskApiVo();
        if (productionTaskApiVo.getCode() != 0) {
            throw new BusinessException(productionTaskApiVo.getMsg());
        }
        productionTaskVo.setProductId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getProductId());
        productionTaskVo.setProductName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getProductName());
        productionTaskVo.setProjectId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getProjectId());
        productionTaskVo.setProjectName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getProjectName());
        productionTaskVo.setCustomerManageId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getCustomerManageId());
        productionTaskVo.setCustomerManageName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getCustomerManageName());
        productionTaskVo.setDistance(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getDistance());
        productionTaskVo.setShipperId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getShipperId());
        productionTaskVo.setShipperMName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getShipperMName());
        productionTaskVo.setShipperVehicleId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getShipperVehicleId());
        productionTaskVo.setShipperVehicleName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getShipperVehicleName());
        productionTaskVo.setWorksiteId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getWorksiteId());
        productionTaskVo.setWorksiteName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getWorksiteName());
        productionTaskVo.setShipperfareVOS(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getShippersfareVOS());
        productionTaskVo.setOrgId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getOrgId());
        productionTaskVo.setOrgName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getOrgName());
        productionTaskVo.setTransportMethod(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getTransportMethod());
        productionTaskVo.setTare(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getTare());
        productionTaskVo.setTransPortId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getTransPortId());
        productionTaskVo.setUnitId(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getUnitId());
        productionTaskVo.setUnitName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getUnitName());
        productionTaskVo.setOrderName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getOrderName());
        productionTaskVo.setOrderMobile(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getOrderMobile());
        productionTaskVo.setTransportRoute(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getTransportRoute());
        productionTaskVo.setPrintCustomerName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getPrintCustomerName());
        productionTaskVo.setPrintSupplyName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getPrintSupplyName());
        productionTaskVo.setPrintWorksiteName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getWorksiteName());
        productionTaskVo.setPrintProductName(((com.ejianc.business.production.task.vo.ProductionTaskApiVo)productionTaskApiVo.getData()).getPrintProductName());
        return productionTaskVo;
    }

    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShipperfareVO> shippersfareVO) {
        BigDecimal freight = new BigDecimal(0.0);
        if (distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0) {
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }
        for (int i = 0; i < shippersfareVO.size(); ++i) {
            BigDecimal fee;
            BigDecimal distan;
            if (i == 0) {
                freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                continue;
            }
            if (distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0) {
                distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                freight = freight.add(fee);
                continue;
            }
            distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
            fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
            freight = freight.add(fee);
            break;
        }
        return freight;
    }
}

