package com.ejianc.business.sale.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.base.bases.vo.SettlementPerioddetailVO;
import com.ejianc.business.base.bases.vo.ShippersInfoApiVO;
import com.ejianc.business.base.bases.vo.ShippersfareVO;
import com.ejianc.business.production.task.api.ProductionTaskApi;
import com.ejianc.business.production.task.vo.TasktransportVO;
import com.ejianc.business.sale.bean.*;
import com.ejianc.business.sale.service.*;
import com.ejianc.business.sale.vo.SignfreightdetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sale.vo.ManualshipmentVO;

/**
 * 发货管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("manualshipment")
public class ManualshipmentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改
    private static final String BILL_CODES = "sale-salesorder";//此处需要根据实际修改

    @Autowired
    private IManualshipmentService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private ISalesdeliveryService salesdeliveryService;
    @Autowired
    private ISalesorderdetilsService salesorderdetilsService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private IProjectInfoService projectInfoService;
    @Autowired
    private ITransportContactService transportContactService;
    @Qualifier("com.ejianc.business.production.task.api.ProductionTaskApi")
    @Autowired
    private ProductionTaskApi productionTaskApi;

    @Autowired
    private SessionManager sessionManager;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<ManualshipmentVO> saveOrUpdate(@RequestBody ManualshipmentVO saveOrUpdateVO) {
    	ManualshipmentEntity entity = BeanMapper.map(saveOrUpdateVO, ManualshipmentEntity.class);
        ProductorInfoEntity productorInfoEntity = productorInfoService.getById(entity.getProductId());
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setShipmentType(0);
                //entity.setFreightStatus(1);
                entity.setReceiptStatus(1);
                entity.setInspection("合格");
                entity.setShipDates(entity.getShipDate());
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行

                entity.setProductUnitPrice(productorInfoEntity.getUnitPrice());//记录产品单价
                if(productorInfoEntity.getVarietiesId1() != null){
                    entity.setPrintAdmixture(productorInfoEntity.getVarietiesName1() + productorInfoEntity.getThousandRate1().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    if(productorInfoEntity.getVarietiesId2() != null){
                        entity.setPrintAdmixture(entity.getPrintAdmixture() + "+" + productorInfoEntity.getVarietiesName2() + productorInfoEntity.getThousandRate2().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                        if(productorInfoEntity.getVarietiesName3() != null){
                            entity.setPrintAdmixture(entity.getPrintAdmixture() + "+" + productorInfoEntity.getVarietiesName3() + productorInfoEntity.getThousandRate3().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                        }
                    }
                }

            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        if(entity.getShippingMethod() == 0){
            entity.setPrintShippersName(entity.getShippersName());
            //修改
            if(entity.getId() != null){
                ManualshipmentEntity manualshipmentEntity =  service.getById(entity.getId());
                if(manualshipmentEntity != null){
                    //自运转代运
                    if(!entity.getShippingMethod().equals(productorInfoEntity.getTransportMethod()) && !entity.getShippingMethod().equals(manualshipmentEntity.getShippingMethod())){
                        entity.setProductUnitPrice(entity.getProductUnitPrice().add(productorInfoEntity.getFreightPoor()));
                    }
                }
            }
        }else{
            entity.setPrintShippersName(null);
            //修改
            if(entity.getId() != null){
                ManualshipmentEntity manualshipmentEntity =  service.getById(entity.getId());
                //代运转自运
                if(!entity.getShippingMethod().equals(productorInfoEntity.getTransportMethod()) && !entity.getShippingMethod().equals(manualshipmentEntity.getShippingMethod())){
                    entity.setProductUnitPrice(entity.getProductUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                }
            }
        }
        if(entity.getShippingMethod() == 0){
            CommonResponse<ShippersInfoApiVO> commonResponse =  baseApi.getShippersInfo(entity.getNumberPlate(),entity.getOrgId());
            if(commonResponse.getCode() == 0){
                if(commonResponse.getData().getShippersfareVOS().size() > 0){
                    BigDecimal freight = this.freightCount(entity.getDistance(),entity.getNetWeight(),commonResponse.getData().getShippersfareVOS());
                    entity.setFreight(freight);
                }else{
                    entity.setFreight(new BigDecimal(0.00));
                }
            }else {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        entity.setPaidMoney(new BigDecimal(0.00));
        entity.setOutstandingMoney(entity.getFreight());
    	service.saveOrUpdate(entity, false);
        //回写重量和发货时间到运输车辆 生产任务单状态 2=已发货
        TasktransportVO tasktransportVO = new TasktransportVO();
        tasktransportVO.setId(entity.getNumberPlateId());
        tasktransportVO.setTransportCount(entity.getNetWeight());
        tasktransportVO.setTransportTime(entity.getShipDate());
        tasktransportVO.setTransportStatue(2);
        CommonResponse commonResponse2 = productionTaskApi.updateTransport(tasktransportVO);
        if(commonResponse2.getCode() != 0){
            throw new BusinessException(commonResponse2.getMsg());
        }
//        //回写生产任务单状态 2=已发货
//        CommonResponse commonResponse = productionTaskApi.updateTransportState(entity.getNumberPlateId(), 2);
//        if(commonResponse.getCode() != 0){
//            throw new BusinessException(commonResponse.getMsg());
//        }
        //回写车辆状态 1= 无任务
        if(entity.getCarId() != null){
            CommonResponse commonResponse1 = baseApi.updatestatus(entity.getCarId(),1);
            if(commonResponse1.getCode() != 0){
                throw new BusinessException(commonResponse1.getMsg());
            }
        }
    	ManualshipmentVO vo = BeanMapper.map(entity, ManualshipmentVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ManualshipmentVO> queryDetail(Long id) {
    	ManualshipmentEntity entity = service.selectById(id);
    	ManualshipmentVO vo = BeanMapper.map(entity, ManualshipmentVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ManualshipmentVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ManualshipmentVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                CommonResponse commonResponse = productionTaskApi.updateTransportState(service.getById(vo.getId()).getNumberPlateId(), 1);
                if(commonResponse.getCode() != 0){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        service.removeByIds(vos.stream().map(ManualshipmentVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        fuzzyFields.add("numberPlate");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            if(manualshipmentEntity.getReceiptStatus() == 1){
                manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
            }
        }
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("shipDate");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ManualshipmentEntity> list = service.queryList(param);
        List<ManualshipmentVO> vo = BeanMapper.mapList(list,ManualshipmentVO.class);
        for(ManualshipmentVO manualshipmentVO : vo){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            manualshipmentVO.setShips(sdf.format(manualshipmentVO.getShipDate()));
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vo);
        ExcelExport.getInstance().export("Manualshipment-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refManualshipmentData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> refManualshipmentData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  发货确认列表数据
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/receipt", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ManualshipmentVO>> receipt(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        /** 租户隔离 */
        param.getParams().put("receipt_status",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageSize(9999999);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 修改发货单的运费确认状态和实收数据
     */
    @RequestMapping(value = "/updateFreightStatus", method = RequestMethod.POST)
    @ResponseBody
    @Transactional(rollbackFor=Exception.class)
    public CommonResponse<IPage<ManualshipmentVO>>updateFreightStatus(@RequestBody List<ManualshipmentVO> saveOrUpdateVO) {
        for(ManualshipmentVO manualshipmentVO : saveOrUpdateVO){
            ManualshipmentEntity manualshipment =  service.getById(manualshipmentVO.getId());
            manualshipment.setFreightStatus(1);
            manualshipment.setReceiptStatus(0);
            manualshipment.setReason(manualshipmentVO.getReason());
            manualshipment.setAbstracts(manualshipmentVO.getAbstracts());
            manualshipment.setFreightTime(new Date());
            manualshipment.setConfirmNumber(manualshipmentVO.getConfirmNumber());
            manualshipment.setBillState(3);
            BigDecimal freight = new BigDecimal(0.00);
            if(manualshipment.getShippingMethod() == 0){
                CommonResponse<ShippersInfoApiVO> commonResponse =  baseApi.getShippersInfo(manualshipment.getNumberPlate(),manualshipment.getOrgId());
                if(commonResponse.getCode() == 0){
                    if(commonResponse.getData().getShippersfareVOS().size() > 0){
                        if(manualshipmentVO.getReason() != null){
                            if(manualshipmentVO.getReason().equals("本厂原因")){
                                freight = this.freightCount(manualshipmentVO.getDistance(),manualshipmentVO.getNetWeight(),commonResponse.getData().getShippersfareVOS());
                            }else{
                                freight = this.freightCount(manualshipmentVO.getDistance(),manualshipmentVO.getConfirmNumber(),commonResponse.getData().getShippersfareVOS());
                            }
                            manualshipment.setFreight(freight);
                        }else{
                            freight = this.freightCount(manualshipmentVO.getDistance(),manualshipmentVO.getNetWeight(),commonResponse.getData().getShippersfareVOS());
                            manualshipment.setFreight(freight);
                        }
                    }else{
                        manualshipment.setFreight(new BigDecimal(0.00));
                    }
                }else {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
            service.updateById(manualshipment);
        }
//        //根据客户id、项目id、工地id、发货日期去重
//        List<ManualshipmentVO> list = saveOrUpdateVO.stream().collect(
//                Collectors.collectingAndThen(
//                        Collectors.toCollection(() -> new TreeSet<>(
//                                Comparator.comparing(jackpot -> jackpot.getCustomerId() + ";" + jackpot.getProjectId()
//                                        + ";" + jackpot.getWorksiteId() + ";" + jackpot.getShipDates()
//                                ))),ArrayList::new
//                )
//        );
        this.saveSale(saveOrUpdateVO);
        QueryParam param = new QueryParam();
        /** 租户隔离 */
        param.getParams().put("receipt_status",new Parameter(QueryParam.EQ,1));
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ManualshipmentEntity> page = service.queryPage(param,false);
        IPage<ManualshipmentVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        for(ManualshipmentEntity manualshipmentEntity : page.getRecords()){
            manualshipmentEntity.setConfirmNumber(manualshipmentEntity.getNetWeight());
        }
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ManualshipmentVO.class));
        return CommonResponse.success("确认成功！",pageData);
    }

    /**
     * @Description queryList 根据运输商id查询改运输商上个月的运费情况
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     *
     */
    @RequestMapping(value = "/freightList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<SignfreightdetailVO>> freightList(@RequestBody QueryParam param) {

        QueryWrapper<ManualshipmentEntity> queryWrapper = new QueryWrapper<>();
        QueryWrapper<TransportContactEntity> queryWrapper1 = new QueryWrapper<>();
        if(param.getParams().get("shippers_id").getValue() != null){
            //param.getParams().remove("customer_name");
            queryWrapper.eq("shippers_id",param.getParams().get("shippers_id").getValue());
            queryWrapper1.eq("shippers_id",param.getParams().get("shippers_id").getValue());
        }
        if(param.getParams().get("date").getValue() != null){
            String orgid = param.getParams().get("orgId").getValue().toString();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            Date d = new Date(Long.valueOf(param.getParams().get("date").getValue().toString()));
            String date = sdf.format(d);
            String starttime;
            String endtiem ;
            // 调用接口
            CommonResponse<SettlementPerioddetailVO> commonResponse = baseApi.querysettlement(date,orgid);
            if(commonResponse.getCode() == 0){
               Date start = commonResponse.getData().getStartDate();
               Date end = commonResponse.getData().getEndDate();
                SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                starttime = sd.format(start);
                endtiem = sd.format(end);
            }else{
                throw new BusinessException(commonResponse.getMsg());
            }
            //param.getParams().remove("customer_name");
            queryWrapper.between("freight_time",starttime,endtiem);
            queryWrapper1.between("transport_date",starttime,endtiem);
        }

        queryWrapper.eq("freight_status",1);
        List<ManualshipmentEntity> list = service.list(queryWrapper);
        List<TransportContactEntity> transportContactEntity = transportContactService.list(queryWrapper1);
        List<SignfreightdetailVO> signfreightdetailVO = new ArrayList<>();
        for(ManualshipmentEntity manualshipmentEntity : list){
            SignfreightdetailVO SignfreightdetailList = new SignfreightdetailVO();
            SignfreightdetailList.setId(manualshipmentEntity.getId());
            SignfreightdetailList.setBillCode(manualshipmentEntity.getBillCode());
            SignfreightdetailList.setNumberPlate(manualshipmentEntity.getNumberPlate());
            SignfreightdetailList.setConsignmentDate(manualshipmentEntity.getShipDate());
            SignfreightdetailList.setConsignmentType(manualshipmentEntity.getShipmentType());
            if(manualshipmentEntity.getReason() == null){
                SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getNetWeight());
            }else{
                if(manualshipmentEntity.getReason().equals("本厂原因")){
                    SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getNetWeight());
                }else if(manualshipmentEntity.getReason().equals("运输原因")){
                    SignfreightdetailList.setConfirmNumber(manualshipmentEntity.getConfirmNumber());
                }
            }
            SignfreightdetailList.setDistance(manualshipmentEntity.getDistance());
            SignfreightdetailList.setFreight(manualshipmentEntity.getFreight());
            SignfreightdetailList.setManualshipmentId(manualshipmentEntity.getId());
            SignfreightdetailList.setRowState("add");
            signfreightdetailVO.add(SignfreightdetailList);
        }
        for (TransportContactEntity transportContactEntity1 : transportContactEntity){
            SignfreightdetailVO SignfreightdetailList = new SignfreightdetailVO();
            SignfreightdetailList.setId(transportContactEntity1.getId());
            SignfreightdetailList.setBillCode(transportContactEntity1.getBillCode());
            SignfreightdetailList.setConsignmentDate(transportContactEntity1.getTransportDate());
            SignfreightdetailList.setConsignmentType(2);
            SignfreightdetailList.setConfirmNumber(transportContactEntity1.getShippersQuantity());
            SignfreightdetailList.setFreight(transportContactEntity1.getMoney());
            SignfreightdetailList.setManualshipmentId(transportContactEntity1.getId());
            SignfreightdetailList.setRowState("add");
            signfreightdetailVO.add(SignfreightdetailList);

        }
        return CommonResponse.success("查询列表数据成功！",signfreightdetailVO);
    }

    //计算运费
    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShippersfareVO> shippersfareVO){
        BigDecimal freight = new BigDecimal(0.0);
//        if(distance.equals(freight)){
//            freight = new BigDecimal(0.00);
//        }else{
//        }
        if(distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0){
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }else{
            for (int i = 0; i < shippersfareVO.size(); i++) {
                if(i == 0){
                    freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                    continue;
                }else {
                    if(distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0){
                        //最终距离 - 开始距离
                        BigDecimal distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        continue;
                    }else {
                        //最终距离 - 开始距离
                        BigDecimal distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        break;
                    }
                }
            }
        }
        return freight;
    }

    //计算运费
    private Boolean saveSale(List<ManualshipmentVO> saveOrUpdateVO){
        //去重后的集合
        for(ManualshipmentVO manualshipmentVO : saveOrUpdateVO){
            //查询销售单
            QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("customer_id",manualshipmentVO.getCustomerId().toString());
            queryWrapper.eq("project_id",manualshipmentVO.getProjectId());
            queryWrapper.eq("worksite_id",manualshipmentVO.getWorksiteId());
            queryWrapper.eq("sale_date",manualshipmentVO.getShipDates());
            queryWrapper.eq("salesorder_type",0);
            SalesorderEntity salesorderEntity = salesorderService.getOne(queryWrapper);
            //如果销售单存在 直接保存销售发货单，不存在先生成销售单,在保存销售单子表
            if(salesorderEntity != null){
                SalesdeliveryEntity salesdeliveryEntity = new SalesdeliveryEntity();
                salesdeliveryEntity.setMid(salesorderEntity.getId());
                salesdeliveryEntity.setBillCode(manualshipmentVO.getBillCode());
                salesdeliveryEntity.setCustomerId(manualshipmentVO.getCustomerId());
                salesdeliveryEntity.setCustomerName(manualshipmentVO.getCustomerName());
                salesdeliveryEntity.setProjectId(manualshipmentVO.getProjectId());
                salesdeliveryEntity.setProjectName(manualshipmentVO.getProjectName());
                salesdeliveryEntity.setWorksiteId(manualshipmentVO.getWorksiteId());
                salesdeliveryEntity.setWorksiteName(manualshipmentVO.getWorksiteName());
                salesdeliveryEntity.setProductId(manualshipmentVO.getProductId());
                salesdeliveryEntity.setProductName(manualshipmentVO.getProductName());
                salesdeliveryEntity.setShipDate(manualshipmentVO.getShipDate());
                salesdeliveryEntity.setNumberPlate(manualshipmentVO.getNumberPlate());
                salesdeliveryEntity.setNetWeight(manualshipmentVO.getNetWeight());
                salesdeliveryEntity.setShippingMethod(manualshipmentVO.getShippingMethod());
                salesdeliveryEntity.setFreight(manualshipmentVO.getFreight());
                salesdeliveryEntity.setShipmentType(manualshipmentVO.getShipmentType());
                salesdeliveryEntity.setConfirmNumber(manualshipmentVO.getConfirmNumber());
                salesdeliveryEntity.setReceiptStatus(0);
                salesdeliveryEntity.setShipDates(manualshipmentVO.getShipDates());
                //保存销售发货单子表
                salesdeliveryService.save(salesdeliveryEntity);
                //根据产品id和运输方式去重
                QueryWrapper<SalesdeliveryEntity> queryWrapper1 = new QueryWrapper();
                queryWrapper1.select("DISTINCT product_id,shipping_method");
                queryWrapper1.eq("mid",salesorderEntity.getId());
                List<SalesdeliveryEntity> salesdeliverylist = salesdeliveryService.list(queryWrapper1);
                for(SalesdeliveryEntity salesdelivery : salesdeliverylist){
                    //根据产品id、主表id、运输方式查询销售产品子表是否存在
                    QueryWrapper<SalesorderdetilsEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("product_info_id",salesdelivery.getProductId());
                    queryWrapper2.eq("salesorder_id",salesorderEntity.getId());
                    queryWrapper2.eq("shipping_method",salesdelivery.getShippingMethod());
                    SalesorderdetilsEntity salesorderdetilsEntity = salesorderdetilsService.getOne(queryWrapper2);
                    //存在汇总实收数量到销售产品子表，如果不存在生成一条销售产品信息
                    if(salesorderdetilsEntity != null){
                        //根据销售单主表id、产品id、运输方式汇总实收数量到销售产品表总的销售数量
                        QueryWrapper<SalesdeliveryEntity> queryWrapper3 = new QueryWrapper<>();
                        queryWrapper3.select("sum(confirm_number) as number");
                        queryWrapper3.eq("mid",salesorderEntity.getId());
                        queryWrapper3.eq("product_id",salesdelivery.getProductId());
                        queryWrapper3.eq("shipping_method",salesdelivery.getShippingMethod());
                        Map<String, Object> map = salesdeliveryService.getMap(queryWrapper3);
                        Double number = Double.valueOf(String.valueOf(map.get("number")));
                        salesorderdetilsEntity.setSalesVolume(BigDecimal.valueOf(number));
                        salesorderdetilsEntity.setSalesAmount(salesorderdetilsEntity.getSalesVolume().multiply(salesorderdetilsEntity.getUnitPrice()));
                        salesorderdetilsEntity.setProductionQuantity(BigDecimal.valueOf(number));
                        salesorderdetilsEntity.setProductionAmount(salesorderdetilsEntity.getSalesVolume().multiply(salesorderdetilsEntity.getUnitPrice()));
                        salesorderdetilsService.updateById(salesorderdetilsEntity);
                    }else{
                        //根据工程产品表id查询工程产品信息
                        ProductorInfoEntity productorInfoEntity = productorInfoService.getById(salesdelivery.getProductId());
                        //新建销售产品信息
                        SalesorderdetilsEntity salesorderdetils = new SalesorderdetilsEntity();
                        salesorderdetils.setSalesorderId(salesorderEntity.getId());
                        salesorderdetils.setProductName(productorInfoEntity.getProductName());
                        salesorderdetils.setSpecName(productorInfoEntity.getSpecName());
                        salesorderdetils.setStoneName(productorInfoEntity.getStoneName());
                        salesorderdetils.setAsphaltName(productorInfoEntity.getAsphaltName());
                        salesorderdetils.setProductInfoId(productorInfoEntity.getId());
                        salesorderdetils.setProductId(productorInfoEntity.getProductId());
                        salesorderdetils.setShippingMethod(salesdelivery.getShippingMethod());
                        if(productorInfoEntity.getTransportMethod().equals(salesdelivery.getShippingMethod())){
                            salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice());
                        }else{
                            salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                        }
                        salesorderdetils.setVarietiesId1(productorInfoEntity.getVarietiesId1());
                        salesorderdetils.setVarietiesName1(productorInfoEntity.getVarietiesName1());
                        salesorderdetils.setCategoryId1(productorInfoEntity.getCategoryId1());
                        salesorderdetils.setCategoryName1(productorInfoEntity.getCategoryName1());
                        salesorderdetils.setThousandRate1(productorInfoEntity.getThousandRate1());

                        salesorderdetils.setVarietiesId2(productorInfoEntity.getVarietiesId2());
                        salesorderdetils.setVarietiesName2(productorInfoEntity.getVarietiesName2());
                        salesorderdetils.setCategoryId2(productorInfoEntity.getCategoryId2());
                        salesorderdetils.setCategoryName2(productorInfoEntity.getCategoryName2());
                        salesorderdetils.setThousandRate2(productorInfoEntity.getThousandRate2());

                        salesorderdetils.setVarietiesId3(productorInfoEntity.getVarietiesId3());
                        salesorderdetils.setVarietiesName3(productorInfoEntity.getVarietiesName3());
                        salesorderdetils.setCategoryId3(productorInfoEntity.getCategoryId3());
                        salesorderdetils.setCategoryName3(productorInfoEntity.getCategoryName3());
                        salesorderdetils.setThousandRate3(productorInfoEntity.getThousandRate3());

                        QueryWrapper<SalesdeliveryEntity> queryWrapper3 = new QueryWrapper<>();
                        queryWrapper3.select("sum(confirm_number) as number");
                        queryWrapper3.eq("mid",salesorderEntity.getId());
                        queryWrapper3.eq("product_id",salesdelivery.getProductId());
                        queryWrapper3.eq("shipping_method",salesdelivery.getShippingMethod());
                        Map<String, Object> map = salesdeliveryService.getMap(queryWrapper3);
                        Double number = Double.valueOf(String.valueOf(map.get("number")));
                        salesorderdetils.setSalesVolume(BigDecimal.valueOf(number));
                        salesorderdetils.setSalesAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                        salesorderdetils.setProductionAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                        salesorderdetils.setProductionQuantity(BigDecimal.valueOf(number));
                        salesorderdetilsService.save(salesorderdetils);
                    }
                }

                //根据销售单id汇总销售产品表中的销售金额 并且修改
                QueryWrapper<SalesorderdetilsEntity> queryWrapper2 = new QueryWrapper<>();
                queryWrapper2.select("sum(sales_amount) as amount");
                queryWrapper2.eq("salesorder_id",salesorderEntity.getId());
                Map<String, Object> map = salesorderdetilsService.getMap(queryWrapper2);
                Double amount = Double.valueOf(String.valueOf(map.get("amount")));
                salesorderEntity.setSalesTotalMoney(BigDecimal.valueOf(amount));
                salesorderService.updateById(salesorderEntity);
            }else{
                ProjectInfoEntity projectInfoEntity = projectInfoService.getById(manualshipmentVO.getProjectId());
                //新建销售单
                SalesorderEntity salesorderEntity1 = new SalesorderEntity();
                salesorderEntity1.setProjectId(manualshipmentVO.getProjectId());
                salesorderEntity1.setProjectName(manualshipmentVO.getProjectName());
                salesorderEntity1.setCustomerId(manualshipmentVO.getCustomerId().toString());
                salesorderEntity1.setCustomerName(manualshipmentVO.getCustomerName());
                salesorderEntity1.setWorksiteId(manualshipmentVO.getWorksiteId());
                salesorderEntity1.setWorksiteName(manualshipmentVO.getWorksiteName());
                salesorderEntity1.setSaleDate(manualshipmentVO.getShipDates());
                salesorderEntity1.setSalesorderType(0);
                salesorderEntity1.setOrgId(projectInfoEntity.getOrgId());
                salesorderEntity1.setOrgName(projectInfoEntity.getOrgName());
                salesorderEntity1.setProfitcenterId(projectInfoEntity.getProfitcenterId());
                salesorderEntity1.setProfitcenterName(projectInfoEntity.getProfitcenterName());
                salesorderEntity1.setIsSign(1);
                Calendar cal = Calendar.getInstance();
                int month = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                String mon = "";
                if(month < 10){
                    mon = "0"+ month;
                }else{
                    mon = String.valueOf(month);
                }
                salesorderEntity1.setReceivablesTime(year + "-" + mon);
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODES,InvocationInfoProxy.getTenantid(),manualshipmentVO);
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    salesorderEntity1.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                //保存销售单
                salesorderService.save(salesorderEntity1);
                //查询销售单
                SalesorderEntity salesorderEntitys = salesorderService.getOne(queryWrapper);
                //新建销售发货单
                SalesdeliveryEntity salesdeliveryEntity = new SalesdeliveryEntity();
                salesdeliveryEntity.setMid(salesorderEntitys.getId());
                salesdeliveryEntity.setBillCode(manualshipmentVO.getBillCode());
                salesdeliveryEntity.setCustomerId(manualshipmentVO.getCustomerId());
                salesdeliveryEntity.setCustomerName(manualshipmentVO.getCustomerName());
                salesdeliveryEntity.setProjectId(manualshipmentVO.getProjectId());
                salesdeliveryEntity.setProjectName(manualshipmentVO.getProjectName());
                salesdeliveryEntity.setWorksiteId(manualshipmentVO.getWorksiteId());
                salesdeliveryEntity.setWorksiteName(manualshipmentVO.getWorksiteName());
                salesdeliveryEntity.setProductId(manualshipmentVO.getProductId());
                salesdeliveryEntity.setProductName(manualshipmentVO.getProductName());
                salesdeliveryEntity.setShipDate(manualshipmentVO.getShipDate());
                salesdeliveryEntity.setNumberPlate(manualshipmentVO.getNumberPlate());
                salesdeliveryEntity.setNetWeight(manualshipmentVO.getNetWeight());
                salesdeliveryEntity.setShippingMethod(manualshipmentVO.getShippingMethod());
                salesdeliveryEntity.setFreight(manualshipmentVO.getFreight());
                salesdeliveryEntity.setShipmentType(manualshipmentVO.getShipmentType());
                salesdeliveryEntity.setConfirmNumber(manualshipmentVO.getConfirmNumber());
                salesdeliveryEntity.setReceiptStatus(0);
                salesdeliveryEntity.setShipDates(manualshipmentVO.getShipDates());
                //保存销售发货单子表
                salesdeliveryService.save(salesdeliveryEntity);

                //根据产品id和运输方式去重
                QueryWrapper<SalesdeliveryEntity> queryWrapper1 = new QueryWrapper();
                queryWrapper1.select("DISTINCT product_id,shipping_method");
                queryWrapper1.eq("mid",salesorderEntitys.getId());
                List<SalesdeliveryEntity> salesdeliverylist = salesdeliveryService.list(queryWrapper1);
                for(SalesdeliveryEntity salesdelivery : salesdeliverylist){
                    //根据产品id、主表id、运输方式查询销售产品子表是否存在
                    QueryWrapper<SalesorderdetilsEntity> queryWrapper2 = new QueryWrapper<>();
                    queryWrapper2.eq("product_info_id",salesdelivery.getProductId());
                    queryWrapper2.eq("salesorder_id",salesorderEntitys.getId());
                    queryWrapper2.eq("shipping_method",salesdelivery.getShippingMethod());
                    SalesorderdetilsEntity salesorderdetilsEntity = salesorderdetilsService.getOne(queryWrapper2);
                    //存在汇总实收数量到销售产品子表，如果不存在生成一条销售产品信息
                    if(salesorderdetilsEntity != null){
                        //根据销售单主表id、产品id、运输方式汇总实收数量到销售产品表总的销售数量
                        QueryWrapper<SalesdeliveryEntity> queryWrapper3 = new QueryWrapper<>();
                        queryWrapper3.select("sum(confirm_number) as number");
                        queryWrapper3.eq("mid",salesorderEntitys.getId());
                        queryWrapper3.eq("product_id",salesdelivery.getProductId());
                        queryWrapper3.eq("shipping_method",salesdelivery.getShippingMethod());
                        Map<String, Object> map = salesdeliveryService.getMap(queryWrapper3);
                        Double number = Double.valueOf(String.valueOf(map.get("number")));
                        salesorderdetilsEntity.setSalesVolume(BigDecimal.valueOf(number));
                        salesorderdetilsEntity.setSalesAmount(salesorderdetilsEntity.getSalesVolume().add(salesorderdetilsEntity.getUnitPrice()));
                        salesorderdetilsService.updateById(salesorderdetilsEntity);
                    }else{
                        //根据工程产品表id查询工程产品信息
                        ProductorInfoEntity productorInfoEntity = productorInfoService.getById(salesdelivery.getProductId());
                        //新建销售产品信息
                        SalesorderdetilsEntity salesorderdetils = new SalesorderdetilsEntity();
                        salesorderdetils.setSalesorderId(salesorderEntitys.getId());
                        salesorderdetils.setProductName(productorInfoEntity.getProductName());
                        salesorderdetils.setSpecName(productorInfoEntity.getSpecName());
                        salesorderdetils.setStoneName(productorInfoEntity.getStoneName());
                        salesorderdetils.setAsphaltName(productorInfoEntity.getAsphaltName());
                        salesorderdetils.setProductInfoId(productorInfoEntity.getId());
                        salesorderdetils.setProductId(productorInfoEntity.getProductId());
                        salesorderdetils.setShippingMethod(salesdelivery.getShippingMethod());
                        if(productorInfoEntity.getTransportMethod().equals(salesdelivery.getShippingMethod())){
                            salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice());
                        }else{
                            salesorderdetils.setUnitPrice(productorInfoEntity.getUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                        }
                        salesorderdetils.setVarietiesId1(productorInfoEntity.getVarietiesId1());
                        salesorderdetils.setVarietiesName1(productorInfoEntity.getVarietiesName1());
                        salesorderdetils.setCategoryId1(productorInfoEntity.getCategoryId1());
                        salesorderdetils.setCategoryName1(productorInfoEntity.getCategoryName1());
                        salesorderdetils.setThousandRate1(productorInfoEntity.getThousandRate1());

                        salesorderdetils.setVarietiesId2(productorInfoEntity.getVarietiesId2());
                        salesorderdetils.setVarietiesName2(productorInfoEntity.getVarietiesName2());
                        salesorderdetils.setCategoryId2(productorInfoEntity.getCategoryId2());
                        salesorderdetils.setCategoryName2(productorInfoEntity.getCategoryName2());
                        salesorderdetils.setThousandRate2(productorInfoEntity.getThousandRate2());

                        salesorderdetils.setVarietiesId3(productorInfoEntity.getVarietiesId3());
                        salesorderdetils.setVarietiesName3(productorInfoEntity.getVarietiesName3());
                        salesorderdetils.setCategoryId3(productorInfoEntity.getCategoryId3());
                        salesorderdetils.setCategoryName3(productorInfoEntity.getCategoryName3());
                        salesorderdetils.setThousandRate3(productorInfoEntity.getThousandRate3());

                        QueryWrapper<SalesdeliveryEntity> queryWrapper3 = new QueryWrapper<>();
                        queryWrapper3.select("sum(confirm_number) as number");
                        queryWrapper3.eq("mid",salesorderEntitys.getId());
                        queryWrapper3.eq("product_id",salesdelivery.getProductId());
                        queryWrapper3.eq("shipping_method",salesdelivery.getShippingMethod());
                        Map<String, Object> map = salesdeliveryService.getMap(queryWrapper3);
                        Double number = Double.valueOf(String.valueOf(map.get("number")));
                        salesorderdetils.setSalesVolume(BigDecimal.valueOf(number));
                        salesorderdetils.setSalesAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                        salesorderdetils.setProductionAmount(salesorderdetils.getSalesVolume().multiply(salesorderdetils.getUnitPrice()));
                        salesorderdetils.setProductionQuantity(BigDecimal.valueOf(number));
                        salesorderdetilsService.save(salesorderdetils);
                    }
                }
                //根据销售单id汇总销售产品表中的销售金额 并且修改
                QueryWrapper<SalesorderdetilsEntity> queryWrapper2 = new QueryWrapper<>();
                queryWrapper2.select("sum(sales_amount) as amount");
                queryWrapper2.eq("salesorder_id",salesorderEntitys.getId());
                Map<String, Object> map = salesorderdetilsService.getMap(queryWrapper2);
                Double amount = Double.valueOf(String.valueOf(map.get("amount")));
                salesorderEntitys.setSalesTotalMoney(BigDecimal.valueOf(amount));
                salesorderService.updateById(salesorderEntitys);
            }
        }
        return true;
    }


}
