package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.InvoiceEntity;
import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.business.sale.service.IPaymentService;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.PaymentMapper;
import com.ejianc.business.sale.bean.PaymentEntity;

/**
 * 付款管理
 * 
 * @author generator
 * 
 */
@Service("paymentService")
public class PaymentServiceImpl extends BaseServiceImpl<PaymentMapper, PaymentEntity> implements IPaymentService {
    @Autowired
    private ProjectInfoMapper projectInfoMapper;

    @Override
    public IPage<PaymentEntity> getPayment(QueryParam param) {
        IPage<PaymentEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        IPage<PaymentEntity> page1 = this.projectInfoMapper.getPayment(page, new QueryWrapper<PaymentEntity>()
                .eq("tenant_id",param.getParams().get("tenantId").getValue())
                .eq("dr","0")
                .eq("manualshipment_id",param.getParams().get("manualshipmentId").getValue())
                .orderByDesc("create_time"));
        return page1;
    }
}
