package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sale.vo.OpeninvoicedetialVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 开票信息
 * 
 * @author generator
 * 
 */
public class OpeninvoiceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long transportId; // 运输商主键
    private String transportName; // 运输商名称
    private BigDecimal openinvoiceMoney; // 开票金额
    private BigDecimal notOpeninvoiceMoney; // 未开票金额
    private Long settlementType; // 结算方式id
    private String settlementName; // 结算方式名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date openinvoiceTime; // 开票日期
    private Integer openinvoiceStatus; // 开票状态
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String abstracts; // 摘要
    private BigDecimal balance; // 历史余额
    
    private List<OpeninvoicedetialVO> openinvoicedetialList = new ArrayList<>(); // 开票信息子表
    private List<OpeninvoicedetailsVO> openinvoicedetailsList = new ArrayList<>(); // 开票信息子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="ShippersRef")
    public Long getTransportId() {
        return transportId;
    }

    @ReferDeserialTransfer
    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public BigDecimal getOpeninvoiceMoney() {
        return openinvoiceMoney;
    }

    public void setOpeninvoiceMoney(BigDecimal openinvoiceMoney) {
        this.openinvoiceMoney = openinvoiceMoney;
    }
    public BigDecimal getNotOpeninvoiceMoney() {
        return notOpeninvoiceMoney;
    }

    public void setNotOpeninvoiceMoney(BigDecimal notOpeninvoiceMoney) {
        this.notOpeninvoiceMoney = notOpeninvoiceMoney;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getSettlementType() {
        return settlementType;
    }

    @ReferDeserialTransfer
    public void setSettlementType(Long settlementType) {
        this.settlementType = settlementType;
    }
    public String getSettlementName() {
        return settlementName;
    }

    public void setSettlementName(String settlementName) {
        this.settlementName = settlementName;
    }
    public Date getOpeninvoiceTime() {
        return openinvoiceTime;
    }

    public void setOpeninvoiceTime(Date openinvoiceTime) {
        this.openinvoiceTime = openinvoiceTime;
    }
    public Integer getOpeninvoiceStatus() {
        return openinvoiceStatus;
    }

    public void setOpeninvoiceStatus(Integer openinvoiceStatus) {
        this.openinvoiceStatus = openinvoiceStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    
     public List<OpeninvoicedetialVO> getOpeninvoicedetialList() {
        return openinvoicedetialList;
     }

     public void setOpeninvoicedetialList(List<OpeninvoicedetialVO> openinvoicedetialList) {
        this.openinvoicedetialList = openinvoicedetialList;
     }

    public List<OpeninvoicedetailsVO> getOpeninvoicedetailsList() {
        return openinvoicedetailsList;
    }

    public void setOpeninvoicedetailsList(List<OpeninvoicedetailsVO> openinvoicedetailsList) {
        this.openinvoicedetailsList = openinvoicedetailsList;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }
}
