package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sale.vo.ReceivablesdetialVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 收款管理
 * 
 * @author generator
 * 
 */
public class ReceivablesVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long customerId; // 客户主键
    private String customerName; // 客户名称
    private Long profitcenterId; // 利润中心id
    private String profitcenterName; // 利润中心名称
    private String payer; // 付款人
    private Long bankId; // 银行主键
    private String bankName; // 银行名称
    private String bankCode; // 银行账号
    private BigDecimal receivablesMoney; // 收款金额
    private BigDecimal notDistributionMoney; // 未分配金额
    private Long receivablesType; // 收款类型id
    private String receivablesName; // 收款类型名称
    private String receiptCode; // 收据号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkoutTime; // 结账年月日
    private Integer receivablesStatus; // 收款方式 0-正常收款  1-预收款
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String abstracts; // 摘要
    private BigDecimal balance; // 历史余额

    
    private List<ReceivablesdetialVO> receivablesdetialList = new ArrayList<>(); // 收款管理子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    @ReferDeserialTransfer
    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public String getPayer() {
        return payer;
    }

    public void setPayer(String payer) {
        this.payer = payer;
    }
    @ReferSerialTransfer(referCode="CustomerbankRef")
    public Long getBankId() {
        return bankId;
    }

    @ReferDeserialTransfer
    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankCode() {
        return bankCode;
    }

    public void setBankCode(String bankCode) {
        this.bankCode = bankCode;
    }

    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getNotDistributionMoney() {
        return notDistributionMoney;
    }

    public void setNotDistributionMoney(BigDecimal notDistributionMoney) {
        this.notDistributionMoney = notDistributionMoney;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getReceivablesType() {
        return receivablesType;
    }

    @ReferDeserialTransfer
    public void setReceivablesType(Long receivablesType) {
        this.receivablesType = receivablesType;
    }
    public String getReceivablesName() {
        return receivablesName;
    }

    public void setReceivablesName(String receivablesName) {
        this.receivablesName = receivablesName;
    }
    public String getReceiptCode() {
        return receiptCode;
    }

    public void setReceiptCode(String receiptCode) {
        this.receiptCode = receiptCode;
    }
    public Date getCheckoutTime() {
        return checkoutTime;
    }

    public void setCheckoutTime(Date checkoutTime) {
        this.checkoutTime = checkoutTime;
    }
    public Integer getReceivablesStatus() {
        return receivablesStatus;
    }

    public void setReceivablesStatus(Integer receivablesStatus) {
        this.receivablesStatus = receivablesStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
     public List<ReceivablesdetialVO> getReceivablesdetialList() {
        return receivablesdetialList;
     }

     public void setReceivablesdetialList(List<ReceivablesdetialVO> receivablesdetialList) {
        this.receivablesdetialList = receivablesdetialList;
     }

    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }
}
