package com.ejianc.business.sale.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.sale.bean.PaymentdetialEntity;
/**
 * 付款管理
 * 
 * @author generator
 * 
 */
 @TableName("ejc_sale_payment")
public class PaymentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="transport_id")
    private Long transportId; // 运输商主键
    @TableField(value="transport_name")
    private String transportName; // 运输商名称
    @TableField(value="payment_account")
    private String paymentAccount; // 付款账户
    @TableField(value="payment_money")
    private BigDecimal paymentMoney; // 付款金额
    @TableField(value="allicated_money")
    private BigDecimal allicatedMoney; // 已付款金额
    @TableField(value="unallocated_money")
    private BigDecimal unallocatedMoney; // 未付款金额
    @TableField(value="payment_type")
    private Long paymentType; // 付款类型id
    @TableField(value="payment_name")
    private String paymentName; // 付款类型名称
    @TableField(value="receipt_code")
    private String receiptCode; // 收据号
    @TableField(value="payment_time")
    private Date paymentTime; // 付款日期
    @TableField(value="payment_status")
    private Integer paymentStatus; // 付款状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="abstracts")
    private String abstracts; // 摘要
    @TableField(value="balance")
    private BigDecimal balance; // 历史余额

    
    
    @TableField(exist=false)
    @SubEntity(serviceName="paymentdetialService",pidName = "mid")
    private List<PaymentdetialEntity> paymentdetialList = new ArrayList<>(); // 付款管理子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getTransportId() {
        return transportId;
    }

    public void setTransportId(Long transportId) {
        this.transportId = transportId;
    }
    public String getTransportName() {
        return transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }
    public String getPaymentAccount() {
        return paymentAccount;
    }

    public void setPaymentAccount(String paymentAccount) {
        this.paymentAccount = paymentAccount;
    }
    public BigDecimal getPaymentMoney() {
        return paymentMoney;
    }

    public void setPaymentMoney(BigDecimal paymentMoney) {
        this.paymentMoney = paymentMoney;
    }
    public BigDecimal getAllicatedMoney() {
        return allicatedMoney;
    }

    public void setAllicatedMoney(BigDecimal allicatedMoney) {
        this.allicatedMoney = allicatedMoney;
    }
    public BigDecimal getUnallocatedMoney() {
        return unallocatedMoney;
    }

    public void setUnallocatedMoney(BigDecimal unallocatedMoney) {
        this.unallocatedMoney = unallocatedMoney;
    }
    public Long getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Long paymentType) {
        this.paymentType = paymentType;
    }
    public String getPaymentName() {
        return paymentName;
    }

    public void setPaymentName(String paymentName) {
        this.paymentName = paymentName;
    }
    public String getReceiptCode() {
        return receiptCode;
    }

    public void setReceiptCode(String receiptCode) {
        this.receiptCode = receiptCode;
    }
    public Date getPaymentTime() {
        return paymentTime;
    }

    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }
    public Integer getPaymentStatus() {
        return paymentStatus;
    }

    public void setPaymentStatus(Integer paymentStatus) {
        this.paymentStatus = paymentStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getAbstracts() {
        return abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }
    

    public List<PaymentdetialEntity> getPaymentdetialList() {
        return paymentdetialList;
    }

    public void setPaymentdetialList(List<PaymentdetialEntity> paymentdetialList) {
        this.paymentdetialList = paymentdetialList;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }
}
