package com.ejianc.business.sale.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.service.IBentitaService;
import com.ejianc.business.sale.utils.DateUtils;
import com.ejianc.business.sale.vo.BentitaVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 本厂替他厂发货
 *
 * @author biying
 */
@Controller
@RequestMapping("bentita")
public class BentitaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBentitaService service;

    @Autowired
    private IOrgApi iOrgApi;


    /**
     * 查询列表数据
     * @return
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BentitaVo>> queryReportList(@RequestBody QueryParam param) {
        List<BentitaVo> vo = new ArrayList<>();
        List<BentitaVo> bentitaVoIPage = service.selectAll();
                for (BentitaVo bentitaVo : bentitaVoIPage){
                    bentitaVo.setId(IdWorker.getId());
                    bentitaVo.setSalesorderId(bentitaVo.getSalesorderId());
                    bentitaVo.setSaleDate(bentitaVo.getSaleDate());
                    bentitaVo.setCustomerNames(bentitaVo.getCustomerNames());
                    bentitaVo.setPrintCustomerName(bentitaVo.getPrintCustomerName());
                    bentitaVo.setProjectName(bentitaVo.getProjectName());
                    bentitaVo.setWorksiteName(bentitaVo.getWorksiteName());
                    bentitaVo.setProfitcenterName(bentitaVo.getProfitcenterName());
                    bentitaVo.setProductName(bentitaVo.getProductName());
                    bentitaVo.setUnitPrice(bentitaVo.getUnitPrice());
                    bentitaVo.setSalesVolume(bentitaVo.getSalesVolume());
                    bentitaVo.setSalesAmount(bentitaVo.getSalesAmount());
                    bentitaVo.setOwnerName(bentitaVo.getOwnerName());
                    vo.add(bentitaVo);
                }
//        return CommonResponse.success("查询列表数据成功！", bentitaVoIPage);
//        IPage<BentitaVo> page = service.queryPage(param,false);
//        IPage<BentitaVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        IPage<BentitaVo> pageData = new Page<>(param.getPageIndex(), param.getPageSize(), bentitaVoIPage.size());
        pageData.setRecords(bentitaVoIPage);

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("saleDate");
        fuzzyFields.add("creatTime");
        fuzzyFields.add("customerNames");
        fuzzyFields.add("ownerName");
        fuzzyFields.add("printCustomerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        fuzzyFields.add("salesVolume");
        fuzzyFields.add("unitPrice");
        fuzzyFields.add("salesAmount");
        fuzzyFields.add("profitcenterName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
//        List<BentitaVo> list = service.queryList(param);
//        List<BentitaVo> salesOrderReportVOS=new ArrayList<>();
        //销售金额合计
        BigDecimal salesAmountAll = new BigDecimal("0.00");
        //销售数量合计
        BigDecimal salesVolumeAll = new BigDecimal("0.00");
//        String customerNames=list.get(0).getCustomerNames();
        List<BentitaVo> vo = new ArrayList<>();
        List<BentitaVo> bentitaVoIPage = service.selectAll();
        for (BentitaVo bentitaVo : bentitaVoIPage){
            bentitaVo.setId(IdWorker.getId());
            bentitaVo.setSalesorderId(bentitaVo.getSalesorderId());
            bentitaVo.setCreatTime(DateUtils.dateSimple(bentitaVo.getSaleDate()));
//            bentitaVo.setSaleDate(bentitaVo.getSaleDate());
            bentitaVo.setCustomerNames(bentitaVo.getCustomerNames());
            bentitaVo.setPrintCustomerName(bentitaVo.getPrintCustomerName());
            bentitaVo.setProjectName(bentitaVo.getProjectName());
            bentitaVo.setWorksiteName(bentitaVo.getWorksiteName());
            bentitaVo.setProfitcenterName(bentitaVo.getProfitcenterName());
            bentitaVo.setProductName(bentitaVo.getProductName());
            bentitaVo.setUnitPrice(bentitaVo.getUnitPrice());
            bentitaVo.setSalesVolume(bentitaVo.getSalesVolume());
            bentitaVo.setSalesAmount(bentitaVo.getSalesAmount());
            bentitaVo.setOwnerName(bentitaVo.getOwnerName());
            if (bentitaVo.getSalesAmount() != null){
                salesAmountAll=salesAmountAll.add(bentitaVo.getSalesAmount());
            }
            if (bentitaVo.getSalesVolume() != null){
                salesVolumeAll=salesVolumeAll.add(bentitaVo.getSalesVolume());
            }
            vo.add(bentitaVo);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", vo);
        beans.put("salesAmountAll", salesAmountAll);
        beans.put("salesVolumeAll", salesVolumeAll);
        ExcelExport.getInstance().export("BentitaVo-export.xlsx", beans, response);
    }

}
