package com.ejianc.business.sale.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.production.task.api.ProductionTaskApi;
import com.ejianc.business.production.task.vo.TasktransportVO;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.controller.ManualshipmentController;
import com.ejianc.business.sale.salesorder.vo.MasterVO;
import com.ejianc.business.sale.salesorder.vo.ProductiontasktransportVO;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

/**
 * @authoer:禹鹏杰
 * @createDate:2022/6/7
 * @description:分配车辆保存时直接生成发货管理
 */
@RestController
@RequestMapping("/api/sale/generateManualshipment")
public class GenerateManualshipmentApi implements Serializable {
    @Autowired
    private IManualshipmentService service;
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private ManualshipmentController manualshipmentController;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    /**
     * 生成发货管理
     */
    @PostMapping(value = "/savelist")
    public CommonResponse saveList(@RequestBody List<ProductiontasktransportVO> voList){
        if (!voList.isEmpty()){
            List<ManualshipmentEntity> manualshipmentVOS=new ArrayList<>();
            for (ProductiontasktransportVO productiontasktransportVO : voList) {
                ManualshipmentEntity manualshipmentVO = new ManualshipmentEntity();
                manualshipmentVO.setCarId(productiontasktransportVO.getShippersVehicleId());
                manualshipmentVO.setNumberPlateId(productiontasktransportVO.getId());
                manualshipmentVO.setNumberPlate(productiontasktransportVO.getShippersVehicleCode());
                manualshipmentVO.setCustomerId(productiontasktransportVO.getCustomerManageId());
                manualshipmentVO.setCustomerName(productiontasktransportVO.getCustomerManageName());
                manualshipmentVO.setProjectId(productiontasktransportVO.getProjectId());
                manualshipmentVO.setProjectName(productiontasktransportVO.getProjectName());
                manualshipmentVO.setProductName(productiontasktransportVO.getProductName());
                manualshipmentVO.setProductId(productiontasktransportVO.getProductId());
                manualshipmentVO.setWorksiteId(productiontasktransportVO.getWorksiteId());
                manualshipmentVO.setWorksiteName(productiontasktransportVO.getWorksiteName());
                manualshipmentVO.setUnitId(productiontasktransportVO.getUnitId());
                manualshipmentVO.setUnitName(productiontasktransportVO.getUnitName());
                manualshipmentVO.setShipDate(productiontasktransportVO.getTransportTime());
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                manualshipmentVO.setShipDates(sdf.format(productiontasktransportVO.getTransportTime()));
                manualshipmentVO.setTare(new BigDecimal("0"));
                manualshipmentVO.setGrossWeight(productiontasktransportVO.getTransportCount());
                manualshipmentVO.setNetWeight(productiontasktransportVO.getTransportCount());
                manualshipmentVO.setShippingMethod(1);
                manualshipmentVO.setShippersId(productiontasktransportVO.getShippersId());
                manualshipmentVO.setShippersName(productiontasktransportVO.getShippersName());
                manualshipmentVO.setDistance(productiontasktransportVO.getDistance());
                manualshipmentVO.setFreight(new BigDecimal("0"));
                manualshipmentVO.setOrgId(productiontasktransportVO.getOrgId());
                manualshipmentVO.setOrgName(productiontasktransportVO.getOrgName());
                manualshipmentVO.setTaskId(productiontasktransportVO.getTaskId().toString());
                manualshipmentVO.setUnitdistributeId(productiontasktransportVO.getUnitdistributeId().toString());
                manualshipmentVO.setOldTaskId(productiontasktransportVO.getOldTaskCode());
                manualshipmentVO.setShipmentType(0);
                manualshipmentVO.setFreightStatus(1);
                manualshipmentVO.setReceiptStatus(1);
                manualshipmentVO.setPrintShippersName("自运");
                //查询产品单价
                ProductorInfoEntity productorInfoEntity = productorInfoService.getById(productiontasktransportVO.getProductId());
                if(productorInfoEntity.getTransportMethod().equals(productiontasktransportVO.getTransportMethod())){
                    manualshipmentVO.setProductUnitPrice(productorInfoEntity.getUnitPrice());
                }else{
                    manualshipmentVO.setProductUnitPrice(productorInfoEntity.getUnitPrice().subtract(productorInfoEntity.getFreightPoor()));
                }
                //打印外加剂
                if(productorInfoEntity.getVarietiesId1() != null){
                    manualshipmentVO.setPrintAdmixture(productorInfoEntity.getVarietiesName1() + productorInfoEntity.getThousandRate1().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    if(productorInfoEntity.getVarietiesId2() != null){
                        manualshipmentVO.setPrintAdmixture("+" + productorInfoEntity.getVarietiesName2() + productorInfoEntity.getThousandRate2().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                        if(productorInfoEntity.getVarietiesName3() != null){
                            manualshipmentVO.setPrintAdmixture("+" + productorInfoEntity.getVarietiesName3() + productorInfoEntity.getThousandRate3().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                        }
                    }
                }
                manualshipmentVO.setTransportRoute(productiontasktransportVO.getTransportRoute());
                manualshipmentVO.setOrderName(productiontasktransportVO.getOrderName());
                manualshipmentVO.setOrderMobile(productiontasktransportVO.getOrderMobile());
                manualshipmentVO.setPrintCustomer(productiontasktransportVO.getPrintCustomerName());
                manualshipmentVO.setPrintConstruction(productiontasktransportVO.getPrintWorksiteName());
                manualshipmentVO.setPrintProducts(productiontasktransportVO.getPrintProductName());
                manualshipmentVO.setPrintSupplier(productiontasktransportVO.getPrintSupplyName());
                //计算金额  净重*单价
                manualshipmentVO.setMoney(manualshipmentVO.getProductUnitPrice().multiply(manualshipmentVO.getNetWeight()));
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),BeanMapper.map(manualshipmentVO,ManualshipmentVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if(billCode.isSuccess()) {
                    manualshipmentVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                }else{
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                manualshipmentVOS.add(manualshipmentVO);
            }
            //List<ManualshipmentEntity> manualshipmentEntities = BeanMapper.mapList(manualshipmentVOS, ManualshipmentEntity.class);
            service.saveOrUpdateBatch(manualshipmentVOS,manualshipmentVOS.size());
            for(ManualshipmentEntity saveOrUpdateVO : manualshipmentVOS){
                manualshipmentController.saveSale(saveOrUpdateVO);
            }
        }
        return CommonResponse.success("生成发货管理成功");
    }

    /**
     * 查询净重总和
     * @param
     * @return
     */
    @PostMapping(value = "/querynetWeight")
    public CommonResponse<BigDecimal> queryNetWeight(Long unitDistributeId){
        QueryWrapper queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("unitdistribute_id",unitDistributeId);
        List<ManualshipmentEntity> list = service.list(queryWrapper);
        BigDecimal netWeight=new BigDecimal("0");
        if (!list.isEmpty()) {
            for (ManualshipmentEntity manualshipmentEntity : list) {
                netWeight = netWeight.add(manualshipmentEntity.getNetWeight());
            }
        }
        return CommonResponse.success("查询净重成功",netWeight);
    }
}
