package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.bean.ProjectInfoEntity;
import com.ejianc.business.sale.mapper.ProjectInfoMapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.ReceivablesMapper;
import com.ejianc.business.sale.bean.ReceivablesEntity;
import com.ejianc.business.sale.service.IReceivablesService;

/**
 * 收款管理
 * 
 * @author generator
 * 
 */
@Service("receivablesService")
public class ReceivablesServiceImpl extends BaseServiceImpl<ReceivablesMapper, ReceivablesEntity> implements IReceivablesService{

    @Autowired
    private ProjectInfoMapper projectInfoMapper;

    @Override
    public IPage<ReceivablesEntity> getReceivables(QueryParam param) {
        IPage<ReceivablesEntity> page = new Page<>();
        page.setSize(param.getPageSize());
        page.setCurrent(param.getPageIndex());
        IPage<ReceivablesEntity> page1 = this.projectInfoMapper.getReceivables(page, new QueryWrapper<ReceivablesEntity>()
                .eq("tenant_id",param.getParams().get("tenantId").getValue())
                .eq("dr","0")
                .eq("sale_id",param.getParams().get("saleId").getValue())
                .orderByDesc("create_time"));
        return page1;
    }
}
