package com.ejianc.business.sale.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesreconciliationdetailEntity;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationdetailService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.data.annotation.Transient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.sale.bean.SalesreconciliationEntity;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.vo.SalesreconciliationVO;

/**
 * 销售调账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("salesreconciliation")
public class SalesreconciliationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "sale-salesreconciliation";//调账单单据编码
    private static final String CODE = "sale-salesorder";//销售单单据编码

    @Autowired
    private ISalesreconciliationService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private ISalesreconciliationdetailService salesreconciliationdetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    @Transient
    public CommonResponse<SalesreconciliationVO> saveOrUpdate(@RequestBody SalesreconciliationVO saveOrUpdateVO) {
    	SalesreconciliationEntity entity = BeanMapper.map(saveOrUpdateVO, SalesreconciliationEntity.class);
        if(entity.getAdjustmentAmount().signum() < 0 && !entity.getAdjustmentBalance().equals(new BigDecimal(0.00))){
            throw new BusinessException("调账金额未分配完不允许保存,请重新分配!");
        }

    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setStatus(0);
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                //如果调账金额是正数自动生成销售单
//                if(entity.getAdjustmentAmount().signum() > 0){
//                }
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            for(SalesreconciliationdetailEntity detailEntity : entity.getSalesreconciliationdetailList()){
                detailEntity.setId(null);
            }
        }else{
            if(saveOrUpdateVO.getSalesreconciliationdetailList().size() != 0 && saveOrUpdateVO.getBillState() == 0){
                QueryWrapper<SalesreconciliationdetailEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("mid",saveOrUpdateVO.getId());
                List<SalesreconciliationdetailEntity> list = salesreconciliationdetailService.list(queryWrapper);
                //取差集
                List<SalesreconciliationdetailEntity> resultList = list.stream()
                        .filter(item -> !saveOrUpdateVO.getSalesreconciliationdetailList().stream().map(e -> e.getId()).collect(Collectors.toList()).contains(item.getId()))
                        .collect(Collectors.toList());
                for (SalesreconciliationdetailEntity salesreconciliationdetailEntity : resultList){
                    salesreconciliationdetailEntity.setRowState("del");
                    entity.getSalesreconciliationdetailList().add(salesreconciliationdetailEntity);
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	SalesreconciliationVO vo = BeanMapper.map(entity, SalesreconciliationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalesreconciliationVO> queryDetail(Long id) {
    	SalesreconciliationEntity entity = service.selectById(id);
    	SalesreconciliationVO vo = BeanMapper.map(entity, SalesreconciliationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SalesreconciliationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SalesreconciliationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SalesreconciliationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SalesreconciliationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SalesreconciliationEntity> page = service.queryPage(param,false);
        IPage<SalesreconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesreconciliationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SalesreconciliationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Salesreconciliation-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSalesreconciliationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SalesreconciliationVO>> refSalesreconciliationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("customerName");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String customerId = _con.getString("customerId");
            String projectId = _con.getString("projectId");
            if(customerId != null){
                param.getParams().put("customer_id",new Parameter(QueryParam.EQ,customerId));
                param.getParams().put("status",new Parameter(QueryParam.EQ,"0"));
                param.getParams().put("adjustment_amount",new Parameter(QueryParam.LT,new BigDecimal(0.00)));
            }
            if(projectId != null){
                param.getParams().put("project_id",new Parameter(QueryParam.EQ,projectId));
            }
        }

        IPage<SalesreconciliationEntity> page = service.queryPage(param,false);
        IPage<SalesreconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SalesreconciliationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/getMoney", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SalesreconciliationVO> getMoney(@RequestParam String customerId, String projectId) {

        QueryWrapper<SalesorderEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("sum(receivable_money) as total");
        //queryWrapper.eq("is_Sign",0);
        queryWrapper.eq("customer_id",customerId);
        queryWrapper.eq("project_id",projectId);
        Map<String, Object> map = salesorderService.getMap(queryWrapper);
        Double total;
        if(map == null){
            total = 0.00;
        }else{
            total = Double.valueOf(String.valueOf(map.get("total")));
        }
        QueryWrapper<SalesorderEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.select("sum(received_moeny) as received");
        queryWrapper1.eq("customer_id",customerId);
        queryWrapper1.eq("project_id",projectId);
        queryWrapper1.isNotNull("received_moeny");
        Map<String, Object> map1 = salesorderService.getMap(queryWrapper1);
        Double received;
        if(map1 == null){
            received = 0.00;
        }else{
            received = Double.valueOf(String.valueOf(map1.get("received")));
        }
        SalesreconciliationVO salesreconciliationVO = new SalesreconciliationVO();
        salesreconciliationVO.setTotalAmount(BigDecimal.valueOf(total));
        salesreconciliationVO.setUncollectedAmount(BigDecimal.valueOf(total-received));

        return CommonResponse.success("查询金额成功！",salesreconciliationVO);
    }
}
