package com.ejianc.business.sale.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.*;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IProjectInfoService;
import com.ejianc.business.sale.utils.DateUtil;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;

/**
 * 发货信息的导入导出
 */
@Controller
@RequestMapping("manualshipmentController")
public class ExcelManualshipmentController implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IManualshipmentService iManualshipmentService;
    @Autowired
    private IManualshipmentService service;
    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadManualshipment")
    @ResponseBody
    public void downloadManualshipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "manualshipment-import.xlsx", "发货管理导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportManualshipment", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportManualshipment(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
//        返回导入合法的数据的VO
        List<ManualshipmentVO> successList = new ArrayList<>();
//        返回导入数据不合法的VO
        List<ManualshipmentVO> errorList = new ArrayList<>();
        HashMap<String, String> map = new HashMap<>();
        boolean isFailed = false;
        MultipartFile mf = null;
//        校验导入文件合法性
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
//            读取导入excel文件的数据
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
//                    获取导入数据的每一条数据校验合法性
                    List<String> data = result.get(i);
                    ManualshipmentVO VO = new ManualshipmentVO();
//                    具体逻辑 data.get（index）为获取某个单元格的数据
                    VO.setId(IdWorker.getId());

                    if ("自动发货".equals(data.get(1))) {
                        VO.setShipmentType(1);//自动发货
                    } else {
                        VO.setShipmentType(0);//手动发货
                    }
//                    VO.setShipmentType(StringUtils.isNotBlank(data.get(0)) ? new Integer(data.get(0)) : null);
                    VO.setShipDate(StringUtils.isNotBlank(data.get(1)) ? DateUtil.DoubleToDate(Double.valueOf(data.get(1))) : null);
                    VO.setCustomerName(StringUtils.isNotBlank(data.get(2)) ? data.get(2) : null);
                    VO.setProjectName(StringUtils.isNotBlank(data.get(3)) ? data.get(3) : null);
                    VO.setNumberPlate(StringUtils.isNotBlank(data.get(4)) ? data.get(4) : null);
                    VO.setProductName(StringUtils.isNotBlank(data.get(5)) ? data.get(5) : null);
                    VO.setWorksiteName(StringUtils.isNotBlank(data.get(6)) ? data.get(6) : null);
                    if("自运".equals(data.get(7))){
                        VO.setShippingMethod(1);
                    }else {
                        VO.setShippingMethod(0);
                    }
//                    VO.setShippingMethod(StringUtils.isNotBlank(data.get(7)) ? new Integer(data.get(7)) : null);
                    VO.setNetWeight(StringUtils.isNotBlank(data.get(8)) ? new BigDecimal(data.get(9)) : null);
                    VO.setConfirmNumber(StringUtils.isNotBlank(data.get(9)) ? new BigDecimal(data.get(9)) : null);
                    if ("已确认".equals(data.get(10))){
                        VO.setReceiptStatus(0);
                    }else {
                        VO.setReceiptStatus(1);
                    }
//                    VO.setReceiptStatus(StringUtils.isNotBlank(data.get(10)) ? new Integer(data.get(10)) : null);
//                    每一条数据都要设置租户id
                    VO.setTenantId(InvocationInfoProxy.getTenantid());
//                    每一条数据设置组织id
                    VO.setOrgId(InvocationInfoProxy.getOrgId());
//                    每一条数据设置创建人
                    VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
//                    每一条数据设置创建时间
                    VO.setCreateTime(new Date());
//                    校验每一个单元格的合法性 如不能为空 或重复性校验
                    if (StringUtils.isEmpty(data.get(4)) || data.get(4) == null) {
//                        如果不合法设置错误信息
                        VO.setErrorMsg("'车牌'不能为空！");
//                        添加到不合法信息数据的VO里
                        errorList.add(VO);
//                        退出本次循环
                        continue;
                    }
//                    else {
//                        QueryWrapper query = new QueryWrapper();
//                        query.eq("project_name", data.get(0));
////                        query.eq("org_id", InvocationInfoProxy.getOrgId());
//                        ManualshipmentEntity entity = iManualshipmentService.getOne(query);
//                        if (entity != null && (entity.getId() != null || entity.getId() != 0)) {
//                            VO.setCustomerId(entity.getId());
//                        } else {
//                            VO.setErrorMsg("工程信息库里未查找到工程名称，请检查！");
//                            errorList.add(VO);
//                            continue;
//                        }
//                    }
//                  如果校验合法 将这条数据放入合法的list里面
                    successList.add(VO);
                }
//                插入保存逻辑 当不合法的数据为空时才插入保存到数据库
                if (errorList.size() == 0) {
//                    如果都合法 将所有的合法数据由VO转换为Entity进行批量保存 如果涉及到子表则需要主表和子表分开保存
                    List<ManualshipmentEntity> manualshipmentEntities = BeanMapper.mapList(successList, ManualshipmentEntity.class);
//                    循环生产每条导入数据的单据编号
                    for (ManualshipmentEntity entity : manualshipmentEntities) {
                        ManualshipmentVO VO = BeanMapper.map(entity, ManualshipmentVO.class);
                        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), VO);
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                        if (billCode.isSuccess()) {
                            entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                        }
                    }
                    service.saveBatch(manualshipmentEntities, successList.size());
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }
}
