package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.sale.bean.*;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.business.sale.vo.SalesorderdetilsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service("salesreconciliation") 
public class SalesreconciliationBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String CODE = "sale-salesorder";//销售单单据编码
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISalesreconciliationService service;
	@Autowired
	private ISalesorderService salesorderService;
	@Autowired
	private IProductorInfoService productorInfoService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		SalesreconciliationEntity entity = service.selectById(billId);
		entity.setStatus(2);
		service.updateById(entity);
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("---------进来啦--------");
		SalesreconciliationEntity entity = service.selectById(billId);
		entity.setStatus(1);
		service.updateById(entity);
		if(entity.getSalesreconciliationdetailList().size() > 0){
			logger.info("---------不为空--------");
			for(SalesreconciliationdetailEntity detailEntity : entity.getSalesreconciliationdetailList()){
				SalesorderEntity salesorderEntity = salesorderService.getById(detailEntity.getSalesorderId());
				salesorderEntity.setReceivableMoney(detailEntity.getAdjustedMoney());
				logger.info("---------已修改--------");
				salesorderService.updateById(salesorderEntity);
			}
		}else{
			//如果调账金额是正数自动生成销售单
			SalesorderVO salesorderVO = new SalesorderVO();
			salesorderVO.setSalesorderType(2);
			salesorderVO.setProjectId(entity.getProjectId());
			salesorderVO.setProjectName(entity.getProjectName());
			salesorderVO.setCustomerId(entity.getCustomerId().toString());
			salesorderVO.setCustomerName(entity.getCustomerName());
			salesorderVO.setSaleDate(new Date());
			salesorderVO.setIsSign(1);
			Calendar cal = Calendar.getInstance();
			int month = cal.get(Calendar.MONTH) + 1;
			int year = cal.get(Calendar.YEAR);
			String mon = "";
			if(month < 10){
				mon = "0"+ month;
			}else{
				mon = String.valueOf(month);
			}
			salesorderVO.setReceivablesTime(year + "-" + mon);
			salesorderVO.setReceivablesDate(new Date());
			salesorderVO.setProfitcenterId(entity.getProfitcenterId());
			salesorderVO.setProfitcenterName(entity.getProfitcenterName());
			salesorderVO.setOrgId(entity.getOrgId());
			salesorderVO.setOrgName(entity.getOrgName());
			salesorderVO.setSalesTotalMoney(entity.getAdjustmentAmount());
			salesorderVO.setReceivableMoney(entity.getAdjustmentAmount());
			salesorderVO.setReceivedMoeny(new BigDecimal(0.00));
			salesorderVO.setUncollectedMoeny(entity.getAdjustmentAmount());
			salesorderVO.setInvoiceMoeny(new BigDecimal(0.00));
			salesorderVO.setNotInvoiceMoeny(entity.getAdjustmentAmount());
			BillCodeParam codeParam = BillCodeParam.build(CODE,InvocationInfoProxy.getTenantid(),salesorderVO);
			CommonResponse<String> code = billCodeApi.generateBillCode(codeParam);
			SalesorderEntity salesorderEntity = BeanMapper.map(salesorderVO, SalesorderEntity.class);
			if(code.isSuccess()) {
				salesorderEntity.setBillCode(code.getData());
			}else{
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
			salesorderService.saveOrUpdate(salesorderEntity,false);
			logger.info("---------新增销售单成功--------");
//			if(entity.getProductId() == null){
//
//			}else{
//				//根据产品id和工程id查询产品信息
//				QueryWrapper<ProductorInfoEntity> queryWrapper = new QueryWrapper<>();
//				queryWrapper.eq("id",entity.getProductId());
//				queryWrapper.eq("project_id",entity.getProjectId());
//				ProductorInfoEntity productorInfoEntity = productorInfoService.getOne(queryWrapper);
//				List<SalesorderdetilsVO> list = new ArrayList<>();
				//将产品信息存入销售单子表
//				SalesorderdetilsVO salesorderdetilsVO = new SalesorderdetilsVO();
//				salesorderdetilsVO.setProductId(productorInfoEntity.getProductId());
//				salesorderdetilsVO.setProductName(productorInfoEntity.getProductName());
//				salesorderdetilsVO.setSpecName(productorInfoEntity.getSpecName());
//				salesorderdetilsVO.setStoneName(productorInfoEntity.getStoneName());
//				salesorderdetilsVO.setAsphaltName(productorInfoEntity.getAsphaltName());
//				salesorderdetilsVO.setCategoryId1(productorInfoEntity.getCategoryId1());
//				salesorderdetilsVO.setCategoryName1(productorInfoEntity.getCategoryName1());
//				salesorderdetilsVO.setThousandRate1(productorInfoEntity.getThousandRate1());
//				salesorderdetilsVO.setCategoryId2(productorInfoEntity.getCategoryId2());
//				salesorderdetilsVO.setCategoryName2(productorInfoEntity.getCategoryName2());
//				salesorderdetilsVO.setThousandRate2(productorInfoEntity.getThousandRate2());
//				salesorderdetilsVO.setCategoryId3(productorInfoEntity.getCategoryId3());
//				salesorderdetilsVO.setCategoryName3(productorInfoEntity.getCategoryName3());
//				salesorderdetilsVO.setThousandRate3(productorInfoEntity.getThousandRate3());
//				salesorderdetilsVO.setUnitPrice(productorInfoEntity.getUnitPrice());
//				salesorderdetilsVO.setRowState("add");
//				list.add(salesorderdetilsVO);
//				salesorderVO.setSalesorderdetilsList(list);
//				salesorderVO.setSalesTotalMoney(entity.getAdjustmentAmount());
//				salesorderVO.setReceivableMoney(entity.getAdjustmentAmount());
//				salesorderVO.setReceivedMoeny(new BigDecimal(0.00));
//				salesorderVO.setUncollectedMoeny(entity.getAdjustmentAmount());
//				salesorderVO.setInvoiceMoeny(new BigDecimal(0.00));
//				salesorderVO.setNotInvoiceMoeny(entity.getAdjustmentAmount());
//				salesorderVO.setSalesreconciliationId(entity.getId());
//				BillCodeParam codeParam = BillCodeParam.build(CODE,InvocationInfoProxy.getTenantid(),salesorderVO);
//				CommonResponse<String> code = billCodeApi.generateBillCode(codeParam);
//				SalesorderEntity salesorderEntity = BeanMapper.map(salesorderVO, SalesorderEntity.class);
//				if(code.isSuccess()) {
//					salesorderEntity.setBillCode(code.getData());
//				}else{
//					throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//				}
//				salesorderService.saveOrUpdate(salesorderEntity,false);
//			}
//			logger.info("---------新增销售单成功--------");
		}
		logger.info("---------结束--------");
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
