package com.ejianc.business.sale.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.base.bases.api.BaseApi;
import com.ejianc.business.production.task.vo.ShipperfareVO;
import com.ejianc.business.production.task.vo.TasktransportVO;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.bean.ProductorInfoEntity;
import com.ejianc.business.sale.controller.ManualshipmentController;
import com.ejianc.business.sale.salesorder.vo.ProductionTaskApiVo;
import com.ejianc.business.sale.salesorder.vo.WeighinginfoApiVO;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.IWeighinginfoService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.sale.mapper.WeighinginfoMapper;
import com.ejianc.business.sale.bean.WeighinginfoEntity;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * 无人值守称重信息
 * 
 * @author generator
 * 
 */
@Service("weighinginfoService")
public class WeighinginfoServiceImpl extends BaseServiceImpl<WeighinginfoMapper, WeighinginfoEntity> implements IWeighinginfoService {
    @Qualifier("com.ejianc.business.production.task.api.ProductionTaskApi")
    @Autowired
    private com.ejianc.business.production.task.api.ProductionTaskApi productionTaskApi;
    @Qualifier("com.ejianc.business.base.bases.api.BaseApi")
    @Autowired
    private BaseApi baseApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IManualshipmentService manualshipmentService;
    @Autowired
    private IProductorInfoService productorInfoService;
    @Autowired
    private ManualshipmentController manualshipmentController;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "sale-manualshipment";//此处需要根据实际修改

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CommonResponse<String> saveManualshipment(WeighinginfoApiVO weighinginfoApiVO) {
        BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),weighinginfoApiVO);
        CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
        //接口返回的信息
        ProductionTaskApiVo productionTaskApiVo = this.productionTaskApiVo(String.valueOf(weighinginfoApiVO.getProductiontaskId()),weighinginfoApiVO.getNumberPlate());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf1 = new SimpleDateFormat("HH:mm:ss");
        //称重方式 = 皮重 只需要保存数据就行
        if(weighinginfoApiVO.getWeighingMethod() == 2){
            //查询第一次进场时的皮重
            QueryWrapper<WeighinginfoEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("is_accounting",1);
            queryWrapper.eq("number_plate",weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq("org_id",weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = this.getOne(queryWrapper);
            if(weighinginfoEntity != null){
                weighinginfoEntity.setIsAccounting(0);
                this.updateById(weighinginfoEntity);
                WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
                weighinginfoEntitys.setIsAccounting(1);
                this.save(weighinginfoEntitys);
            }else {
                WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
                weighinginfoEntitys.setIsAccounting(1);
                this.save(weighinginfoEntitys);
            }
            return CommonResponse.success("保存成功!");
        }
        ManualshipmentEntity manualshipmentEntity = new ManualshipmentEntity();
        //称重方式 = 一次称重 调取主数据接口获取运输商信息和调取生产接口获取生产任务信息
        if(weighinginfoApiVO.getWeighingMethod() == 0){
            //生成自动发货单
            manualshipmentEntity.setBillCode(billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            Date date = new Date();
            String ship = sdf.format(productionTaskApiVo.getTaskTime()) + sdf1.format(date);
            System.out.println("时间="+ ship );
            try {
                manualshipmentEntity.setShipDate(DateUtils.parseDate(ship,"yyyy-MM-dd HH:ss:mm"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            manualshipmentEntity.setWeighingTime(new Date());//过磅时间
            manualshipmentEntity.setNumberPlateId(productionTaskApiVo.getTransPortId());
            manualshipmentEntity.setUnitId(productionTaskApiVo.getUnitId());
            manualshipmentEntity.setUnitName(productionTaskApiVo.getUnitName());
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setOrderName(productionTaskApiVo.getOrderName());
            manualshipmentEntity.setOrderMobile(productionTaskApiVo.getOrderMobile());
            manualshipmentEntity.setTransportRoute(productionTaskApiVo.getTransportRoute());
            manualshipmentEntity.setTaskId(weighinginfoApiVO.getProductiontaskId().toString());
            manualshipmentEntity.setUnitdistributeId(productionTaskApiVo.getUnitdistributeId().toString());
            manualshipmentEntity.setOldTaskId(productionTaskApiVo.getOldTaskId());
            //打印设置字段
            manualshipmentEntity.setPrintCustomer(productionTaskApiVo.getPrintCustomerName());
            manualshipmentEntity.setPrintConstruction(productionTaskApiVo.getPrintWorksiteName());
            manualshipmentEntity.setPrintProducts(productionTaskApiVo.getPrintProductName());
            manualshipmentEntity.setPrintSupplier(productionTaskApiVo.getPrintSupplyName());
            manualshipmentEntity.setInspection("合格");

            ProductorInfoEntity productorInfoEntity = productorInfoService.getById(manualshipmentEntity.getProductId());
            manualshipmentEntity.setProductUnitPrice(productorInfoEntity.getUnitPrice());//记录产品单价
            if(productorInfoEntity.getVarietiesId1() != null){
                manualshipmentEntity.setPrintAdmixture(productorInfoEntity.getVarietiesName1() + productorInfoEntity.getThousandRate1().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue()  + "‰");
                if(productorInfoEntity.getVarietiesId2() != null){
                    manualshipmentEntity.setPrintAdmixture(manualshipmentEntity.getPrintAdmixture() + "+" + productorInfoEntity.getVarietiesName2() + productorInfoEntity.getThousandRate2().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    if(productorInfoEntity.getVarietiesName3() != null){
                        manualshipmentEntity.setPrintAdmixture(manualshipmentEntity.getPrintAdmixture() + "+" + productorInfoEntity.getVarietiesName3() + productorInfoEntity.getThousandRate3().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    }
                }
            }

            manualshipmentEntity.setShipDates(sdf.format(productionTaskApiVo.getTaskTime()));
            //manualshipmentEntity.setFreightStatus(1);
            manualshipmentEntity.setReceiptStatus(1);
            //----------  保留 ----------
            // 接口返回的皮重
            //manualshipmentEntity.setTare(productionTaskApiVo.getTare());
            manualshipmentEntity.setTare(weighinginfoApiVO.getTare());
            // 净重 = 毛重 -皮重
            //manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(productionTaskApiVo.getTare()));
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getNetweight());
            manualshipmentEntity.setWeighingNumber(weighinginfoApiVO.getNetweight());//过磅数
            //-------  结束 ------------
            //manualshipmentEntity.setFreightStatus(1);
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            //计算金额 净重*单价
            manualshipmentEntity.setMoney(manualshipmentEntity.getProductUnitPrice().multiply(manualshipmentEntity.getNetWeight()));
            //当运输商子表大于0计算运费 否则默认运费0.00
            if(productionTaskApiVo.getTransportMethod().equals("代运")){
                manualshipmentEntity.setShippingMethod(0);
                manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
                manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
                manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
                manualshipmentEntity.setPrintShippersName(productionTaskApiVo.getShipperMName());
                //计算运费
                BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(),manualshipmentEntity.getNetWeight(),productionTaskApiVo.getShipperfareVOS());
                manualshipmentEntity.setFreight(freight);
            }else{
                manualshipmentEntity.setShippingMethod(1);
                manualshipmentEntity.setPrintShippersName(null);
                manualshipmentEntity.setFreight(new BigDecimal(0.00));
            }
            //保存数据
            manualshipmentService.save(manualshipmentEntity);
            //将本条数据保存到临时表中
            WeighinginfoEntity weighinginfoEntity = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
            weighinginfoEntity.setIsAccounting(0);
            this.save(weighinginfoEntity);
        }
        if(weighinginfoApiVO.getWeighingMethod() == 1){
            //生成自动发货单
            manualshipmentEntity.setBillCode(billCode.getData());
            manualshipmentEntity.setProductId(productionTaskApiVo.getProductId());
            manualshipmentEntity.setProductName(productionTaskApiVo.getProductName());
            manualshipmentEntity.setCustomerId(productionTaskApiVo.getCustomerManageId());
            manualshipmentEntity.setCustomerName(productionTaskApiVo.getCustomerManageName());
            manualshipmentEntity.setProjectId(productionTaskApiVo.getProjectId());
            manualshipmentEntity.setProjectName(productionTaskApiVo.getProjectName());
            manualshipmentEntity.setWorksiteId(productionTaskApiVo.getWorksiteId());
            manualshipmentEntity.setWorksiteName(productionTaskApiVo.getWorksiteName());
            manualshipmentEntity.setShipmentType(1);
            Date date = new Date();
            String ship = sdf.format(productionTaskApiVo.getTaskTime()) + sdf1.format(date);
            System.out.println("时间="+ ship );
            try {
                manualshipmentEntity.setShipDate(DateUtils.parseDate(ship,"yyyy-MM-dd HH:ss:mm"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            manualshipmentEntity.setWeighingTime(new Date());//过磅时间
            manualshipmentEntity.setNumberPlate(weighinginfoApiVO.getNumberPlate());
            manualshipmentEntity.setNumberPlateId(productionTaskApiVo.getTransPortId());
            manualshipmentEntity.setUnitId(productionTaskApiVo.getUnitId());
            manualshipmentEntity.setUnitName(productionTaskApiVo.getUnitName());
            manualshipmentEntity.setDistance(productionTaskApiVo.getDistance());
            manualshipmentEntity.setGrossWeight(weighinginfoApiVO.getWeight());
            manualshipmentEntity.setOrderName(productionTaskApiVo.getOrderName());
            manualshipmentEntity.setOrderMobile(productionTaskApiVo.getOrderMobile());
            manualshipmentEntity.setTransportRoute(productionTaskApiVo.getTransportRoute());
            manualshipmentEntity.setTaskId(weighinginfoApiVO.getProductiontaskId().toString());
            manualshipmentEntity.setUnitdistributeId(productionTaskApiVo.getUnitdistributeId().toString());
            manualshipmentEntity.setOldTaskId(productionTaskApiVo.getOldTaskId());
            //打印设置字段
            manualshipmentEntity.setPrintCustomer(productionTaskApiVo.getPrintCustomerName());
            manualshipmentEntity.setPrintConstruction(productionTaskApiVo.getPrintWorksiteName());
            manualshipmentEntity.setPrintProducts(productionTaskApiVo.getPrintProductName());
            manualshipmentEntity.setPrintSupplier(productionTaskApiVo.getPrintSupplyName());
            manualshipmentEntity.setInspection("合格");

            ProductorInfoEntity productorInfoEntity = productorInfoService.getById(manualshipmentEntity.getProductId());
            manualshipmentEntity.setProductUnitPrice(productorInfoEntity.getUnitPrice());//记录产品单价
            if(productorInfoEntity.getVarietiesId1() != null){
                manualshipmentEntity.setPrintAdmixture(productorInfoEntity.getVarietiesName1() + productorInfoEntity.getThousandRate1().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                if(productorInfoEntity.getVarietiesId2() != null){
                    manualshipmentEntity.setPrintAdmixture(manualshipmentEntity.getPrintAdmixture() +"+" + productorInfoEntity.getVarietiesName2() + productorInfoEntity.getThousandRate2().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    if(productorInfoEntity.getVarietiesName3() != null){
                        manualshipmentEntity.setPrintAdmixture(manualshipmentEntity.getPrintAdmixture() +"+" + productorInfoEntity.getVarietiesName3() + productorInfoEntity.getThousandRate3().setScale(0, BigDecimal.ROUND_HALF_UP).floatValue() + "‰");
                    }
                }
            }

            manualshipmentEntity.setShipDates(sdf.format(productionTaskApiVo.getTaskTime()));
            QueryWrapper<WeighinginfoEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("is_accounting",1);
            queryWrapper.eq("number_plate",weighinginfoApiVO.getNumberPlate());
            queryWrapper.eq("org_id",weighinginfoApiVO.getOrgId());
            WeighinginfoEntity weighinginfoEntity = this.getOne(queryWrapper);
//            manualshipmentEntity.setTare(weighinginfoEntity.getWeight());
//            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getWeight().subtract(weighinginfoEntity.getWeight()));
            //-----------  保留---------
            manualshipmentEntity.setTare(weighinginfoApiVO.getTare());
            manualshipmentEntity.setNetWeight(weighinginfoApiVO.getNetweight());
            manualshipmentEntity.setWeighingNumber(weighinginfoApiVO.getNetweight());//过磅数
            //----------   结束--------
            //manualshipmentEntity.setFreightStatus(1);
            manualshipmentEntity.setReceiptStatus(1);
            manualshipmentEntity.setOrgId(productionTaskApiVo.getOrgId());
            manualshipmentEntity.setOrgName(productionTaskApiVo.getOrgName());
            //计算金额 净重*单价
            manualshipmentEntity.setMoney(manualshipmentEntity.getProductUnitPrice().multiply(manualshipmentEntity.getNetWeight()));
            //当运输商子表大于0计算运费 否则默认运费0.00
            if(productionTaskApiVo.getTransportMethod().equals("代运")){
                manualshipmentEntity.setShippingMethod(0);
                manualshipmentEntity.setShippersId(productionTaskApiVo.getShipperId());
                manualshipmentEntity.setShippersName(productionTaskApiVo.getShipperMName());
                manualshipmentEntity.setCarId(productionTaskApiVo.getShipperVehicleId());
                manualshipmentEntity.setPrintShippersName(productionTaskApiVo.getShipperMName());
                // 计算运费
                BigDecimal freight = this.freightCount(productionTaskApiVo.getDistance(),manualshipmentEntity.getNetWeight(),productionTaskApiVo.getShipperfareVOS());
                manualshipmentEntity.setFreight(freight);
            }else{
                manualshipmentEntity.setShippingMethod(1);
                manualshipmentEntity.setPrintShippersName(null);
                manualshipmentEntity.setFreight(new BigDecimal(0.00));
            }
            //保存数据
            manualshipmentService.save(manualshipmentEntity);
            //将上条数据的核算信息修改
            weighinginfoEntity.setIsAccounting(0);
            this.updateById(weighinginfoEntity);
            //将本条数据保存到临时表中
            WeighinginfoEntity weighinginfoEntitys = BeanMapper.map(weighinginfoApiVO, WeighinginfoEntity.class);
            weighinginfoEntitys.setIsAccounting(1);
            weighinginfoEntitys.setFirstTimeId(weighinginfoEntity.getId());
            this.save(weighinginfoEntitys);
        }
        //生成销售单
        manualshipmentController.saveSale(manualshipmentEntity);
        //回写重量和发货时间到运输车辆 生产任务单状态 2=已发货
        TasktransportVO tasktransportVO = new TasktransportVO();
        tasktransportVO.setId(manualshipmentEntity.getNumberPlateId());
        tasktransportVO.setTransportCount(manualshipmentEntity.getNetWeight());
        tasktransportVO.setTransportTime(manualshipmentEntity.getShipDate());
        tasktransportVO.setTransportStatue(2);
        logger.info("打印数据=" + tasktransportVO);
        CommonResponse commonResponse2 = productionTaskApi.updateTransport(tasktransportVO);
        if(commonResponse2.getCode() != 0){
            throw new BusinessException(commonResponse2.getMsg());
        }
//        //回写生产任务单状态 2=已发货
//        CommonResponse commonResponse = productionTaskApi.updateTransportState(productionTaskApiVo.getTransPortId(), 2);
//        if(commonResponse.getCode() != 0){
//            throw new BusinessException(commonResponse.getMsg());
//        }
        //回写车辆状态 1= 无任务
        if(productionTaskApiVo.getShipperVehicleId() != null){
            CommonResponse commonResponse1 = baseApi.updatestatus(productionTaskApiVo.getShipperVehicleId(),1);
            if(commonResponse1.getCode() != 0){
                throw new BusinessException(commonResponse1.getMsg());
            }
        }

        return CommonResponse.success("生成成功!",billCode.getData());
    }

    //调用接口将接口数据放入返回数据vo中
    private ProductionTaskApiVo productionTaskApiVo(String taskId, String carCode){
        CommonResponse<com.ejianc.business.production.task.vo.ProductionTaskApiVo> productionTaskApiVo =  productionTaskApi.getproductiontask(taskId,carCode);
        ProductionTaskApiVo productionTaskVo = new ProductionTaskApiVo();
        if(productionTaskApiVo.getCode() == 0){
            productionTaskVo.setProductId(productionTaskApiVo.getData().getProductId());
            productionTaskVo.setProductName(productionTaskApiVo.getData().getProductName());
            productionTaskVo.setProjectId(productionTaskApiVo.getData().getProjectId());
            productionTaskVo.setProjectName(productionTaskApiVo.getData().getProjectName());
            productionTaskVo.setCustomerManageId(productionTaskApiVo.getData().getCustomerManageId());
            productionTaskVo.setCustomerManageName(productionTaskApiVo.getData().getCustomerManageName());
            productionTaskVo.setDistance(productionTaskApiVo.getData().getDistance());
            productionTaskVo.setShipperId(productionTaskApiVo.getData().getShipperId());
            productionTaskVo.setShipperMName(productionTaskApiVo.getData().getShipperMName());
            productionTaskVo.setShipperVehicleId(productionTaskApiVo.getData().getShipperVehicleId());
            productionTaskVo.setShipperVehicleName(productionTaskApiVo.getData().getShipperVehicleName());
            productionTaskVo.setWorksiteId(productionTaskApiVo.getData().getWorksiteId());
            productionTaskVo.setWorksiteName(productionTaskApiVo.getData().getWorksiteName());
            productionTaskVo.setShipperfareVOS(productionTaskApiVo.getData().getShippersfareVOS());
            productionTaskVo.setOrgId(productionTaskApiVo.getData().getOrgId());
            productionTaskVo.setOrgName(productionTaskApiVo.getData().getOrgName());
            productionTaskVo.setTransportMethod(productionTaskApiVo.getData().getTransportMethod());
            productionTaskVo.setTare(productionTaskApiVo.getData().getTare());
            productionTaskVo.setTransPortId(productionTaskApiVo.getData().getTransPortId());
            productionTaskVo.setUnitId(productionTaskApiVo.getData().getUnitId());
            productionTaskVo.setUnitName(productionTaskApiVo.getData().getUnitName());
            productionTaskVo.setOrderName(productionTaskApiVo.getData().getOrderName());
            productionTaskVo.setOrderMobile(productionTaskApiVo.getData().getOrderMobile());
            productionTaskVo.setTransportRoute(productionTaskApiVo.getData().getTransportRoute());
            productionTaskVo.setPrintCustomerName(productionTaskApiVo.getData().getPrintCustomerName());
            productionTaskVo.setPrintSupplyName(productionTaskApiVo.getData().getPrintSupplyName());
            productionTaskVo.setPrintWorksiteName(productionTaskApiVo.getData().getWorksiteName());
            productionTaskVo.setPrintProductName(productionTaskApiVo.getData().getPrintProductName());
            productionTaskVo.setUnitdistributeId(productionTaskApiVo.getData().getUnitdistributeId());
            productionTaskVo.setOldTaskId(productionTaskApiVo.getData().getOldTaskCode());
            productionTaskVo.setTaskTime(productionTaskApiVo.getData().getTaskTime());
        }else{
            throw  new BusinessException(productionTaskApiVo.getMsg());
        }
        return productionTaskVo;
    }
    //计算运费
    private BigDecimal freightCount(BigDecimal distance, BigDecimal netWeight, List<ShipperfareVO> shippersfareVO){
        BigDecimal freight = new BigDecimal(0.0);
//        if(distance.equals(freight)){
//            freight = new BigDecimal(0.00);
//        }else{
//
//        }
        if(distance.compareTo(shippersfareVO.get(0).getEndDistance()) <= 0){
            freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
            return freight;
        }else{
            for (int i = 0; i < shippersfareVO.size(); i++) {
                if(i == 0){
                    freight = netWeight.multiply(shippersfareVO.get(0).getTransportFare());
                    continue;
                }else {
                    if(distance.compareTo(shippersfareVO.get(i).getEndDistance()) >= 0){
                        //最终距离 - 开始距离
                        BigDecimal distan = shippersfareVO.get(i).getEndDistance().subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        continue;
                    }else {
                        //最终距离 - 开始距离
                        BigDecimal distan = distance.subtract(shippersfareVO.get(i).getStartDistance());
                        //净重 * 当前区间运费 * 距离
                        BigDecimal fee = netWeight.multiply(shippersfareVO.get(i).getTransportFare()).multiply(distan);
                        //运费 = 起步价运费 + 净重 * 当前区间运费 * 距离
                        freight = freight.add(fee);
                        break;
                    }
                }
            }
        }
        return freight;
    }


}
