package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 销售调账子表
 * 
 * @author generator
 * 
 */
public class SalesreconciliationdetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long mid; // 主表id
    private Integer salesorderType; // 销售类型 0-自动销售单  1-手动销售单 2-销售调账生成
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date saleDate; // 销售日期
    private Long worksiteId; // 工地主键
    private String worksiteName; // 工地名称
    private BigDecimal salesTotalMoney; // 销售总金额
    private BigDecimal unpaidMoney; // 应收未收金额
    private BigDecimal distributionMoney; // 分配金额
    private BigDecimal adjustedMoney; // 调整后金额
    private Long salesorderId; // 销售单主键
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private String billCode; // 单据编号
    

    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public Integer getSalesorderType() {
        return salesorderType;
    }

    public void setSalesorderType(Integer salesorderType) {
        this.salesorderType = salesorderType;
    }
    public Date getSaleDate() {
        return saleDate;
    }

    public void setSaleDate(Date saleDate) {
        this.saleDate = saleDate;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }

    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    public BigDecimal getSalesTotalMoney() {
        return salesTotalMoney;
    }

    public void setSalesTotalMoney(BigDecimal salesTotalMoney) {
        this.salesTotalMoney = salesTotalMoney;
    }
    public BigDecimal getUnpaidMoney() {
        return unpaidMoney;
    }

    public void setUnpaidMoney(BigDecimal unpaidMoney) {
        this.unpaidMoney = unpaidMoney;
    }
    public BigDecimal getDistributionMoney() {
        return distributionMoney;
    }

    public void setDistributionMoney(BigDecimal distributionMoney) {
        this.distributionMoney = distributionMoney;
    }
    public BigDecimal getAdjustedMoney() {
        return adjustedMoney;
    }

    public void setAdjustedMoney(BigDecimal adjustedMoney) {
        this.adjustedMoney = adjustedMoney;
    }
    public Long getSalesorderId() {
        return salesorderId;
    }

    public void setSalesorderId(Long salesorderId) {
        this.salesorderId = salesorderId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    
}
