package com.ejianc.business.sale.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.business.sale.bean.SigndetailEtity;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 签认单
 * 
 * @author generator
 * 
 */
public class SignVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 工程主键
    private String projectName; // 工程名称
    private Long customerId; // 客户名称
    private String customerName; // 客户名称
    private Long worksiteId; // 工地主键
    private String worksiteName; // 工地名称
    private Long profitcenterId; // 利润中心id
    private String profitcenterName; // 利润中心名称
    private BigDecimal bookTotalMoney; // 账面总额
    private BigDecimal receivablesMoney; // 收款金额
    private BigDecimal bookBalance; // 账面余额
    private BigDecimal signMoney; // 签认金额
    private BigDecimal signBalance; // 签认余额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signTime; // 签认日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date failureTime; // 失效日期
    private Integer signStatus; // 签认状态 0-已签认,1-未签认
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String billCode; // 单据编号
    private Integer isSign; // 是否签认: 0是1否
    private Integer isRefund; // 是否退款: 0是1否
    private Integer isDistribution; // 是否分配: 0是1否
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM", timezone = "GMT+8")
    private Date signMonth; // 签认月份

    private List<SigndetailVO> signdetailList = new ArrayList<>(); // 销售签认单子表


    @ReferSerialTransfer(referCode="ProjectInfoRef")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="CustomermanageRef")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="ConstructionsiteRef")
    public Long getWorksiteId() {
        return worksiteId;
    }

    @ReferDeserialTransfer
    public void setWorksiteId(Long worksiteId) {
        this.worksiteId = worksiteId;
    }
    public String getWorksiteName() {
        return worksiteName;
    }

    public void setWorksiteName(String worksiteName) {
        this.worksiteName = worksiteName;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProfitcenterId() {
        return profitcenterId;
    }

    @ReferDeserialTransfer
    public void setProfitcenterId(Long profitcenterId) {
        this.profitcenterId = profitcenterId;
    }
    public String getProfitcenterName() {
        return profitcenterName;
    }

    public void setProfitcenterName(String profitcenterName) {
        this.profitcenterName = profitcenterName;
    }
    public BigDecimal getBookTotalMoney() {
        return bookTotalMoney;
    }

    public void setBookTotalMoney(BigDecimal bookTotalMoney) {
        this.bookTotalMoney = bookTotalMoney;
    }
    public BigDecimal getReceivablesMoney() {
        return receivablesMoney;
    }

    public void setReceivablesMoney(BigDecimal receivablesMoney) {
        this.receivablesMoney = receivablesMoney;
    }
    public BigDecimal getBookBalance() {
        return bookBalance;
    }

    public void setBookBalance(BigDecimal bookBalance) {
        this.bookBalance = bookBalance;
    }
    public BigDecimal getSignMoney() {
        return signMoney;
    }

    public void setSignMoney(BigDecimal signMoney) {
        this.signMoney = signMoney;
    }
    public BigDecimal getSignBalance() {
        return signBalance;
    }

    public void setSignBalance(BigDecimal signBalance) {
        this.signBalance = signBalance;
    }
    public Date getSignTime() {
        return signTime;
    }

    public void setSignTime(Date signTime) {
        this.signTime = signTime;
    }
    public Date getFailureTime() {
        return failureTime;
    }

    public void setFailureTime(Date failureTime) {
        this.failureTime = failureTime;
    }
    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getIsSign() {
        return isSign;
    }

    public void setIsSign(Integer isSign) {
        this.isSign = isSign;
    }
    public Integer getIsRefund() {
        return isRefund;
    }

    public void setIsRefund(Integer isRefund) {
        this.isRefund = isRefund;
    }
    public Integer getIsDistribution() {
        return isDistribution;
    }

    public void setIsDistribution(Integer isDistribution) {
        this.isDistribution = isDistribution;
    }


    public Date getSignMonth() {
        return signMonth;
    }

    public void setSignMonth(Date signMonth) {
        this.signMonth = signMonth;
    }

    public List<SigndetailVO> getSigndetailList() {
        return signdetailList;
    }

    public void setSigndetailList(List<SigndetailVO> signdetailList) {
        this.signdetailList = signdetailList;
    }
}
