/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sale.service.IBentitaService;
import com.ejianc.business.sale.utils.DateUtils;
import com.ejianc.business.sale.vo.BentitaVo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bentita"})
public class BentitaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBentitaService service;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BentitaVo>> queryReportList(@RequestBody QueryParam param) {
        ArrayList<BentitaVo> vo = new ArrayList<BentitaVo>();
        List<BentitaVo> bentitaVoIPage = this.service.selectAll();
        for (BentitaVo bentitaVo : bentitaVoIPage) {
            bentitaVo.setId(IdWorker.getId());
            bentitaVo.setSalesorderId(bentitaVo.getSalesorderId());
            bentitaVo.setSaleDate(bentitaVo.getSaleDate());
            bentitaVo.setCustomerNames(bentitaVo.getCustomerNames());
            bentitaVo.setPrintCustomerName(bentitaVo.getPrintCustomerName());
            bentitaVo.setProjectName(bentitaVo.getProjectName());
            bentitaVo.setWorksiteName(bentitaVo.getWorksiteName());
            bentitaVo.setProfitcenterName(bentitaVo.getProfitcenterName());
            bentitaVo.setProductName(bentitaVo.getProductName());
            bentitaVo.setUnitPrice(bentitaVo.getUnitPrice());
            bentitaVo.setSalesVolume(bentitaVo.getSalesVolume());
            bentitaVo.setSalesAmount(bentitaVo.getSalesAmount());
            bentitaVo.setOwnerName(bentitaVo.getOwnerName());
            vo.add(bentitaVo);
        }
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)bentitaVoIPage.size());
        pageData.setRecords(bentitaVoIPage);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("saleDate");
        fuzzyFields.add("creatTime");
        fuzzyFields.add("customerNames");
        fuzzyFields.add("ownerName");
        fuzzyFields.add("printCustomerName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("worksiteName");
        fuzzyFields.add("productName");
        fuzzyFields.add("salesVolume");
        fuzzyFields.add("unitPrice");
        fuzzyFields.add("salesAmount");
        fuzzyFields.add("profitcenterName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        BigDecimal salesAmountAll = new BigDecimal("0.00");
        BigDecimal salesVolumeAll = new BigDecimal("0.00");
        ArrayList<BentitaVo> vo = new ArrayList<BentitaVo>();
        List<BentitaVo> bentitaVoIPage = this.service.selectAll();
        for (BentitaVo bentitaVo : bentitaVoIPage) {
            bentitaVo.setId(IdWorker.getId());
            bentitaVo.setSalesorderId(bentitaVo.getSalesorderId());
            bentitaVo.setCreatTime(DateUtils.dateSimple(bentitaVo.getSaleDate()));
            bentitaVo.setCustomerNames(bentitaVo.getCustomerNames());
            bentitaVo.setPrintCustomerName(bentitaVo.getPrintCustomerName());
            bentitaVo.setProjectName(bentitaVo.getProjectName());
            bentitaVo.setWorksiteName(bentitaVo.getWorksiteName());
            bentitaVo.setProfitcenterName(bentitaVo.getProfitcenterName());
            bentitaVo.setProductName(bentitaVo.getProductName());
            bentitaVo.setUnitPrice(bentitaVo.getUnitPrice());
            bentitaVo.setSalesVolume(bentitaVo.getSalesVolume());
            bentitaVo.setSalesAmount(bentitaVo.getSalesAmount());
            bentitaVo.setOwnerName(bentitaVo.getOwnerName());
            if (bentitaVo.getSalesAmount() != null) {
                salesAmountAll = salesAmountAll.add(bentitaVo.getSalesAmount());
            }
            if (bentitaVo.getSalesVolume() != null) {
                salesVolumeAll = salesVolumeAll.add(bentitaVo.getSalesVolume());
            }
            vo.add(bentitaVo);
        }
        HashMap<String, Serializable> beans = new HashMap<String, Serializable>();
        beans.put("records", vo);
        beans.put("salesAmountAll", salesAmountAll);
        beans.put("salesVolumeAll", salesVolumeAll);
        ExcelExport.getInstance().export("BentitaVo-export.xlsx", beans, response);
    }
}

