/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.excel;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.sale.bean.ManualshipmentEntity;
import com.ejianc.business.sale.service.IManualshipmentService;
import com.ejianc.business.sale.utils.DateUtil;
import com.ejianc.business.sale.vo.ManualshipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"manualshipmentController"})
public class ExcelManualshipmentController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IManualshipmentService iManualshipmentService;
    @Autowired
    private IManualshipmentService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "sale-manualshipment";

    @RequestMapping(value={"/downloadManualshipment"})
    @ResponseBody
    public void downloadManualshipment(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"manualshipment-import.xlsx", (String)"\u53d1\u8d27\u7ba1\u7406\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportManualshipment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportManualshipment(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<ManualshipmentVO> successList = new ArrayList<ManualshipmentVO>();
        ArrayList<ManualshipmentVO> errorList = new ArrayList<ManualshipmentVO>();
        HashMap map = new HashMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List data = (List)result.get(i);
                ManualshipmentVO VO = new ManualshipmentVO();
                VO.setId(IdWorker.getId());
                if ("\u81ea\u52a8\u53d1\u8d27".equals(data.get(1))) {
                    VO.setShipmentType(1);
                } else {
                    VO.setShipmentType(0);
                }
                VO.setShipDate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(1))) ? DateUtil.DoubleToDate(Double.valueOf((String)data.get(1))) : null);
                VO.setCustomerName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(2))) ? (String)data.get(2) : null);
                VO.setProjectName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(3))) ? (String)data.get(3) : null);
                VO.setNumberPlate(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(4))) ? (String)data.get(4) : null);
                VO.setProductName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(5))) ? (String)data.get(5) : null);
                VO.setWorksiteName(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(6))) ? (String)data.get(6) : null);
                if ("\u81ea\u8fd0".equals(data.get(7))) {
                    VO.setShippingMethod(1);
                } else {
                    VO.setShippingMethod(0);
                }
                VO.setNetWeight(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(8))) ? new BigDecimal((String)data.get(9)) : null);
                VO.setConfirmNumber(StringUtils.isNotBlank((CharSequence)((CharSequence)data.get(9))) ? new BigDecimal((String)data.get(9)) : null);
                if ("\u5df2\u786e\u8ba4".equals(data.get(10))) {
                    VO.setReceiptStatus(0);
                } else {
                    VO.setReceiptStatus(1);
                }
                VO.setTenantId(InvocationInfoProxy.getTenantid());
                VO.setOrgId(InvocationInfoProxy.getOrgId());
                VO.setCreateUserCode(InvocationInfoProxy.getUsercode());
                VO.setCreateTime(new Date());
                if (StringUtils.isEmpty((CharSequence)((CharSequence)data.get(4))) || data.get(4) == null) {
                    VO.setErrorMsg("'\u8f66\u724c'\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorList.add(VO);
                    continue;
                }
                successList.add(VO);
            }
            if (errorList.size() == 0) {
                List manualshipmentEntities = BeanMapper.mapList(successList, ManualshipmentEntity.class);
                for (ManualshipmentEntity entity : manualshipmentEntities) {
                    ManualshipmentVO VO = (ManualshipmentVO)((Object)BeanMapper.map((Object)((Object)entity), ManualshipmentVO.class));
                    BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)VO);
                    CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                    if (!billCode.isSuccess()) continue;
                    entity.setBillCode((String)billCode.getData());
                }
                this.service.saveBatch(manualshipmentEntities, successList.size());
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }
}

