/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sale.service.impl;

import com.ejianc.business.sale.bean.SalesorderEntity;
import com.ejianc.business.sale.bean.SalesreconciliationEntity;
import com.ejianc.business.sale.bean.SalesreconciliationdetailEntity;
import com.ejianc.business.sale.service.IProductorInfoService;
import com.ejianc.business.sale.service.ISalesorderService;
import com.ejianc.business.sale.service.ISalesreconciliationService;
import com.ejianc.business.sale.vo.SalesorderVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="salesreconciliation")
public class SalesreconciliationBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CODE = "sale-salesorder";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISalesreconciliationService service;
    @Autowired
    private ISalesorderService salesorderService;
    @Autowired
    private IProductorInfoService productorInfoService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        SalesreconciliationEntity entity = (SalesreconciliationEntity)((Object)this.service.selectById(billId));
        entity.setStatus(2);
        this.service.updateById((Object)entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("---------\u8fdb\u6765\u5566--------");
        SalesreconciliationEntity entity = (SalesreconciliationEntity)((Object)this.service.selectById(billId));
        entity.setStatus(1);
        this.service.updateById((Object)entity);
        if (entity.getSalesreconciliationdetailList().size() > 0) {
            this.logger.info("---------\u4e0d\u4e3a\u7a7a--------");
            for (SalesreconciliationdetailEntity detailEntity : entity.getSalesreconciliationdetailList()) {
                SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)this.salesorderService.getById(detailEntity.getSalesorderId()));
                salesorderEntity.setReceivableMoney(detailEntity.getAdjustedMoney());
                this.logger.info("---------\u5df2\u4fee\u6539--------");
                this.salesorderService.updateById((Object)salesorderEntity);
            }
        } else {
            SalesorderVO salesorderVO = new SalesorderVO();
            salesorderVO.setSalesorderType(2);
            salesorderVO.setProjectId(entity.getProjectId());
            salesorderVO.setProjectName(entity.getProjectName());
            salesorderVO.setCustomerId(entity.getCustomerId().toString());
            salesorderVO.setCustomerName(entity.getCustomerName());
            salesorderVO.setSaleDate(new Date());
            salesorderVO.setIsSign(1);
            Calendar cal = Calendar.getInstance();
            int month = cal.get(2) + 1;
            int year = cal.get(1);
            String mon = "";
            mon = month < 10 ? "0" + month : String.valueOf(month);
            salesorderVO.setReceivablesTime(year + "-" + mon);
            salesorderVO.setReceivablesDate(new Date());
            salesorderVO.setProfitcenterId(entity.getProfitcenterId());
            salesorderVO.setProfitcenterName(entity.getProfitcenterName());
            salesorderVO.setOrgId(entity.getOrgId());
            salesorderVO.setOrgName(entity.getOrgName());
            salesorderVO.setSalesTotalMoney(entity.getAdjustmentAmount());
            salesorderVO.setReceivableMoney(entity.getAdjustmentAmount());
            salesorderVO.setReceivedMoeny(new BigDecimal(0.0));
            salesorderVO.setUncollectedMoeny(entity.getAdjustmentAmount());
            salesorderVO.setInvoiceMoeny(new BigDecimal(0.0));
            salesorderVO.setNotInvoiceMoeny(entity.getAdjustmentAmount());
            BillCodeParam codeParam = BillCodeParam.build((String)CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)salesorderVO);
            CommonResponse code = this.billCodeApi.generateBillCode(codeParam);
            SalesorderEntity salesorderEntity = (SalesorderEntity)((Object)BeanMapper.map((Object)((Object)salesorderVO), SalesorderEntity.class));
            if (!code.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            salesorderEntity.setBillCode((String)code.getData());
            this.salesorderService.saveOrUpdate((Object)salesorderEntity, false);
            this.logger.info("---------\u65b0\u589e\u9500\u552e\u5355\u6210\u529f--------");
        }
        this.logger.info("---------\u7ed3\u675f--------");
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

