package com.ejianc.business.scene.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工期计划视图
 * 
 * @author generator
 * 
 */
public class ScenePlanViewVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 父id
    private String nodeName; // 节点名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planStartTime; // 节点开始时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planFinishTime; // 节点结束时间
    private String keyNodes; // 是否关键节点
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishTime; // 实际完成时间
    private String lagDays; // 目前进度情况（滞后天数）
    private String influenceFactor; // 主要影响因素
    private String solutions; // 应对措施
    private String emergency; // 急需集团协调解决事项
    private String earlyWarning; // 
    private String remarks; // 备注
    private String detailFlag; // 明细状态，0：待处理，2：已通知公司，3：已通知项目，4：已处理
    private Long projectId; // 项目Id
    private String projectCode; // 项目编号
    private Date countDate; // 统计日期
    private String projectName; // 项目名称
    private Long planDetailId; // 主键ID
    private Long orgId; // 项目部id
    private Long departmentId; // 经办（申请人）部门id
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getNodeName() {
        return nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }
    public Date getPlanStartTime() {
        return planStartTime;
    }

    public void setPlanStartTime(Date planStartTime) {
        this.planStartTime = planStartTime;
    }
    public Date getPlanFinishTime() {
        return planFinishTime;
    }

    public void setPlanFinishTime(Date planFinishTime) {
        this.planFinishTime = planFinishTime;
    }
    public String getKeyNodes() {
        return keyNodes;
    }

    public void setKeyNodes(String keyNodes) {
        this.keyNodes = keyNodes;
    }
    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }
    public String getLagDays() {
        return lagDays;
    }

    public void setLagDays(String lagDays) {
        this.lagDays = lagDays;
    }
    public String getInfluenceFactor() {
        return influenceFactor;
    }

    public void setInfluenceFactor(String influenceFactor) {
        this.influenceFactor = influenceFactor;
    }
    public String getSolutions() {
        return solutions;
    }

    public void setSolutions(String solutions) {
        this.solutions = solutions;
    }
    public String getEmergency() {
        return emergency;
    }

    public void setEmergency(String emergency) {
        this.emergency = emergency;
    }
    public String getEarlyWarning() {
        return earlyWarning;
    }

    public void setEarlyWarning(String earlyWarning) {
        this.earlyWarning = earlyWarning;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public String getDetailFlag() {
        return detailFlag;
    }

    public void setDetailFlag(String detailFlag) {
        this.detailFlag = detailFlag;
    }
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Date getCountDate() {
        return countDate;
    }

    public void setCountDate(Date countDate) {
        this.countDate = countDate;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getPlanDetailId() {
        return planDetailId;
    }

    public void setPlanDetailId(Long planDetailId) {
        this.planDetailId = planDetailId;
    }
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    
}
