package com.ejianc.business.scene.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息类型
 * @date 2021/10/20
 */
public enum NoticeEnum {

    /**
     * 检查单审批
     * 通过
     * 整改责任人，相关人员
     */
    CHECK_COMMIT_PASS("检查单审批通知整改人", "现场检查整改通知", "请及时整改", "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    CHECK_COMMIT_PASS_REVIEW("检查单审批通知相关人", "现场检查通知", "请及时查看", "收到编号为【#BILLCODE#】的检查单，请及时安排相关人员处理，<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    /**
     * 整改任务全部提交
     * 复查人
     */
    REFORM_COMMIT("整改任务对应复查人员", "现场检查复查通知", "请及时复查", "收到编号为【#BILLCODE#】的复查单，请及时处理，<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    REVIEW_COMMIT_UNPASS("复查提交（含有不合格）", "现场检查整改通知", "请及时整改", "你有 #NUM# 条新的整改任务需要处理，检查单【#CHECKNAME#】<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    REVIEW_COMMIT_PASS("复查提交（全部合格）", "现场检查通知", "请及时查看", "收到编号为【#BILLCODE#】的检查单，请及时处理，<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    REFORM_OVERTIME("整改逾期提醒", "现场检查整改逾期提醒", "请及时整改", "你有 #NUM# 条整改任务即将逾期，请及时处理，<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#"),

    REVIEW_OVERTIME("复查逾期提醒", "现场检查复查逾期提醒", "请及时复查", "你有 #NUM# 条复查任务即将逾期，请及时处理，<a href=" + '"' + "#URL#" + '"' + ">点击查看详情</a>", "#BASEHOST#ejc-oa-frontend/#/workLog/card?id=#ID#");

    private String desc;

    private String subject;

    private String key1;

    private String content;

    private String url;

    public static NoticeEnum instance(NoticeEnum notice, Map<String, String> map) {
        String content = notice.getContent();
        content = content.replace("#URL#", notice.getUrl());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            content = content.replace(entry.getKey(), entry.getValue());
        }
        notice.setContent(content);
        return notice;
    }

    NoticeEnum(String desc, String subject, String key1, String content, String url) {
        this.desc = desc;
        this.subject = subject;
        this.content = content;
        this.url = url;
    }


    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getKey1() {
        return key1;
    }

    public void setKey1(String key1) {
        this.key1 = key1;
    }

    public static void main(String[] args) {
        HashMap<String, String> keyMap = new HashMap<>();
        keyMap.put("#NUM#", "1");
        keyMap.put("#BILLCODE#", "BIL001");
        keyMap.put("#CHECKNAME#", "检查单");
        keyMap.put("#ID#", String.valueOf(505474252989415479L));
        keyMap.put("#BASEHOST#", "https://dev.17elian.com/");
        NoticeEnum notice = NoticeEnum.instance(NoticeEnum.CHECK_COMMIT_PASS, keyMap);
        System.out.println(notice.getContent());
    }
}
