package com.ejianc.business.scene.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static net.logstash.logback.encoder.org.apache.commons.lang.StringUtils.split;

/**
 * 检查单待检复检子表
 *
 * @author generator
 */
@ApiModel("检查单待检复检子表")
public class SceneCheckDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("检查单id")
    private Long pid;
    @ApiModelProperty("检查项编号")
    private String billCode;
    @ApiModelProperty("检查名称")
    private String checkName;
    @ApiModelProperty("项目名")
    private String projectName;
    @ApiModelProperty("检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；")
    private Long checkType;
    @ApiModelProperty("检查类型名称")
    private String checkTypeName;
    private Integer checkAttr; // 检查属性 1 质量 2安全 3其他
    private String checkAttrName;// 检查属性 1 质量 2安全 3其他
    private Integer checkLevel; // 检查级别1项目2公司
    private Long checkCategoryId; // 检查项分类
    private String checkCategory; // 检查项分类

    private Long checkItemId; // 检查项
    @ApiModelProperty("检查项")
    private String checkItem;
    @ApiModelProperty("问题照片id")
    private String problemImgIds;
    @ApiModelProperty("问题照片")
    private String problemImgUrl;
    @ApiModelProperty("隐患等级  0、一般；1、严重；2、紧急")
    private Integer dangerLevel;
    @ApiModelProperty("检查人 id")
    private String checkId;
    @ApiModelProperty("检查人")
    private String checkPerson;
    @ApiModelProperty("复查人 id")
    private String reviewId;
    @ApiModelProperty("复查人")
    private String reviewPerson;
    @ApiModelProperty("检查日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date checkDate;
    @ApiModelProperty("当前整改人id")
    private Long currentRectificationId;
    @ApiModelProperty("当前整改人")
    private String currentRectificationPerson;
    @ApiModelProperty("整改人id")
    private String rectificationId;
    @ApiModelProperty("整改人")
    private String rectificationPerson;
    @ApiModelProperty("是否逾期")
    private Integer isOverdue;
    @ApiModelProperty("要求完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date finishDate;
    @ApiModelProperty("整改日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reformDate;
    @ApiModelProperty("整改照片id")
    private String reformImgIds;
    @ApiModelProperty("整改照片")
    private String reformImgUrl;
    @ApiModelProperty("整改次数")
    private Integer reformNumber;
    @ApiModelProperty("复查结果")
    private Integer reviewResult;
    @ApiModelProperty("复查描述")
    private String reviewDescribe;
    @ApiModelProperty("复查图片id")
    private String reviewImgIds;
    @ApiModelProperty("复查图片")
    private String reviewImgUrl;
    @ApiModelProperty("整改描述")
    private String reformMsg;
    @ApiModelProperty("整改信息")
    private String reformNews;
    @ApiModelProperty("单据状态")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @ApiModelProperty("检查项整改状态")
    private Integer isReform; // 检查项整改状态：1-待整改，2-已整改，3-整改不合格
    @ApiModelProperty("复查信息")
    private String reviewMsg; // 复查信息
    @ApiModelProperty("任务状态")
    private String taskState; // 任务状态
    @ApiModelProperty("整改复查记录表")
    private List<SceneCheckRecordVO> sceneCheckRecords = new ArrayList<>();
    @ApiModelProperty("复检时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date reviewDate; // 复检时间
    @ApiModelProperty("是否支持修改") //是否支持修改 0 支持 1 不支持
    private Integer isModify; //是否支持修改 0 支持 1不支持 (用于前端控制 复查结果等字段)
    @ApiModelProperty("实际复查人")
    private String actualReviewer;
    @ApiModelProperty("图片的基础路径")
    private String baseImgUrl;
    private String part;//部位
    @ApiModelProperty(value="备注")
    private String memo;

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getCheckCategoryId() {
        return checkCategoryId;
    }

    public void setCheckCategoryId(Long checkCategoryId) {
        this.checkCategoryId = checkCategoryId;
    }

    public String getCheckCategory() {
        return checkCategory;
    }

    public void setCheckCategory(String checkCategory) {
        this.checkCategory = checkCategory;
    }

    public Long getCheckItemId() {
        return checkItemId;
    }

    public void setCheckItemId(Long checkItemId) {
        this.checkItemId = checkItemId;
    }

    public Integer getCheckAttr() {
        return checkAttr;
    }

    public void setCheckAttr(Integer checkAttr) {
        this.checkAttr = checkAttr;
    }

    public String getCheckAttrName() {
        return checkAttrName;
    }

    public String getPart() {
        return part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public void setCheckAttrName(String checkAttrName) {
        this.checkAttrName = checkAttrName;
    }

    public Integer getCheckLevel() {
        return checkLevel;
    }

    public void setCheckLevel(Integer checkLevel) {
        this.checkLevel = checkLevel;
    }

    /**
     * 检查单id
     */
    public Long getPid() {
        return pid;
    }

    /**
     * 检查单id
     */
    public void setPid(Long pid) {
        this.pid = pid;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    /**
     * 检查名称(来源检查单)
     */
    public String getCheckName() {
        return checkName;
    }

    /**
     * 检查名称(来源检查单)
     */
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    /**
     * 项目名
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public Long getCheckType() {
        return checkType;
    }

    /**
     * 检查类型 1、综合检查；2、安全检查；3、质量检查；4、进度检查；5、其他检查；
     */
    public void setCheckType(Long checkType) {
        this.checkType = checkType;
    }

    /**
     * 检查类型名称
     */
    public String getCheckTypeName() {
        return checkTypeName;
    }

    /**
     * 检查类型名称
     */
    public void setCheckTypeName(String checkTypeName) {
        this.checkTypeName = checkTypeName;
    }

    /**
     * 检查项
     */
    public String getCheckItem() {
        return checkItem;
    }

    /**
     * 检查项
     */
    public void setCheckItem(String checkItem) {
        this.checkItem = checkItem;
    }

    /**
     * 问题照片id
     */
    public String getProblemImgIds() {
        return problemImgIds;
    }

    /**
     * 问题照片id
     */
    public void setProblemImgIds(String problemImgIds) {
        this.problemImgIds = problemImgIds;
    }

    /**
     * 问题照片
     */
    public String getProblemImgUrl() {
        return problemImgUrl;
    }

    /**
     * 问题照片
     */
    public void setProblemImgUrl(String problemImgUrl) {
        this.problemImgUrl = problemImgUrl;
    }

    /**
     * 隐患等级  0、一般；1、严重；2、紧急
     */
    public Integer getDangerLevel() {
        return dangerLevel;
    }

    /**
     * 隐患等级  0、一般；1、严重；2、紧急
     */
    public void setDangerLevel(Integer dangerLevel) {
        this.dangerLevel = dangerLevel;
    }

    /**
     * 检查人 id
     */
    public String getCheckId() {
        return checkId;
    }

    /**
     * 检查人 id
     */
    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    /**
     * 检查人
     */
    public String getCheckPerson() {
        return checkPerson;
    }

    /**
     * 检查人
     */
    public void setCheckPerson(String checkPerson) {
        this.checkPerson = checkPerson;
    }

    /**
     * 复查人 id
     */
    public String getReviewId() {
        return reviewId;
    }

    /**
     * 复查人 id
     */
    public void setReviewId(String reviewId) {
        this.reviewId = reviewId;
    }

    /**
     * 复查人
     */
    public String getReviewPerson() {
        return reviewPerson;
    }

    /**
     * 复查人
     */
    public void setReviewPerson(String reviewPerson) {
        this.reviewPerson = reviewPerson;
    }

    /**
     * 检查日期
     */
    public java.util.Date getCheckDate() {
        return checkDate;
    }

    /**
     * 检查日期
     */
    public void setCheckDate(java.util.Date checkDate) {
        this.checkDate = checkDate;
    }

    /**
     * 当前整改人id
     */
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getCurrentRectificationId() {
        return currentRectificationId;
    }

    /**
     * 当前整改人id
     */
    @ReferDeserialTransfer
    public void setCurrentRectificationId(Long currentRectificationId) {
        this.currentRectificationId = currentRectificationId;
    }

    /**
     * 当前整改人
     */
    public String getCurrentRectificationPerson() {
        return currentRectificationPerson;
    }

    /**
     * 当前整改人
     */
    public void setCurrentRectificationPerson(String currentRectificationPerson) {
        this.currentRectificationPerson = currentRectificationPerson;
    }

    /**
     * 整改人id
     */
    public String getRectificationId() {
        return rectificationId;
    }

    /**
     * 整改人id
     */
    public void setRectificationId(String rectificationId) {
        this.rectificationId = rectificationId;
    }

    /**
     * 整改人
     */
    public String getRectificationPerson() {
        return rectificationPerson;
    }

    /**
     * 整改人
     */
    public void setRectificationPerson(String rectificationPerson) {
        this.rectificationPerson = rectificationPerson;
    }

    /**
     * 是否逾期
     */
    public Integer getIsOverdue() {
        return isOverdue;
    }

    /**
     * 是否逾期
     */
    public void setIsOverdue(Integer isOverdue) {
        this.isOverdue = isOverdue;
    }


    /**
     * 要求完成日期
     */
    public java.util.Date getFinishDate() {
        return finishDate;
    }

    /**
     * 要求完成日期
     */
    public void setFinishDate(java.util.Date finishDate) {
        this.finishDate = finishDate;
    }

    /**
     * 整改日期
     */
    public java.util.Date getReformDate() {
        return reformDate;
    }

    /**
     * 整改日期
     */
    public void setReformDate(java.util.Date reformDate) {
        this.reformDate = reformDate;
    }

    /**
     * 整改照片id
     */
    public String getReformImgIds() {
        return reformImgIds;
    }

    /**
     * 整改照片id
     */
    public void setReformImgIds(String reformImgIds) {
        this.reformImgIds = reformImgIds;
    }

    /**
     * 整改照片
     */
    public String getReformImgUrl() {
        return reformImgUrl;
    }

    /**
     * 整改照片
     */
    public void setReformImgUrl(String reformImgUrl) {
        this.reformImgUrl = reformImgUrl;
    }

    /**
     * 整改次数
     */
    public Integer getReformNumber() {
        return reformNumber;
    }

    /**
     * 整改次数
     */
    public void setReformNumber(Integer reformNumber) {
        this.reformNumber = reformNumber;
    }

    /**
     * 复查结果
     */
    public Integer getReviewResult() {
        return reviewResult;
    }

    /**
     * 复查结果
     */
    public void setReviewResult(Integer reviewResult) {
        this.reviewResult = reviewResult;
    }

    /**
     * 复查描述
     */
    public String getReviewDescribe() {
        return reviewDescribe;
    }

    /**
     * 复查描述
     */
    public void setReviewDescribe(String reviewDescribe) {
        this.reviewDescribe = reviewDescribe;
    }

    /**
     * 复查图片id
     */
    public String getReviewImgIds() {
        return reviewImgIds;
    }

    /**
     * 复查图片id
     */
    public void setReviewImgIds(String reviewImgIds) {
        this.reviewImgIds = reviewImgIds;
    }

    /**
     * 复查图片
     */
    public String getReviewImgUrl() {
        return reviewImgUrl;
    }

    /**
     * 复查图片
     */
    public void setReviewImgUrl(String reviewImgUrl) {
        this.reviewImgUrl = reviewImgUrl;
    }

    /**
     * 整改复查记录表
     */
    public List<SceneCheckRecordVO> getSceneCheckRecords() {
        return sceneCheckRecords;
    }

    /**
     * 整改复查记录表
     */
    public void setSceneCheckRecords(List<SceneCheckRecordVO> sceneCheckRecords) {
        this.sceneCheckRecords = sceneCheckRecords;
    }

    public String getReformMsg() {
        return reformMsg;
    }

    public void setReformMsg(String reformMsg) {
        this.reformMsg = reformMsg;
    }

    public String getReformNews() {
        return reformNews;
    }

    public void setReformNews(String reformNews) {
        this.reformNews = reformNews;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getIsReform() {
        return isReform;
    }

    public void setIsReform(Integer isReform) {
        this.isReform = isReform;
    }

    /**
     * 复查信息
     */
    public String getReviewMsg() {
        return reviewMsg;
    }

    /**
     * 复查信息
     */
    public void setReviewMsg(String reviewMsg) {
        this.reviewMsg = reviewMsg;
    }

    /**
     * 任务状态
     */
    public String getTaskState() {
        return taskState;
    }

    /**
     * 任务状态
     */
    public void setTaskState(String taskState) {
        this.taskState = taskState;
    }

    /**
     * 复检时间
     */
    public Date getReviewDate() {
        return reviewDate;
    }

    /**
     * 复检时间
     */
    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    /**
     * 是否支持修改 0 支持 1 不支持
     */
    public Integer getIsModify() {
        return isModify;
    }

    /**
     * 是否支持修改 0 支持 1 不支持
     */
    public void setIsModify(Integer isModify) {
        this.isModify = isModify;
    }

    public String getActualReviewer() {
        return actualReviewer;
    }

    public void setActualReviewer(String actualReviewer) {
        this.actualReviewer = actualReviewer;
    }

    public void setSceneCheckRecords(List<SceneCheckRecordVO> sceneCheckRecordVO, String fileServerPath) {
        for (SceneCheckRecordVO s : sceneCheckRecordVO) {
            String imgIds = s.getImgIds();
            if (StringUtils.isNotEmpty(imgIds)) {
                String[] ids = imgIds.split(",");
                ArrayList<ImgFileVO> imgFileVOS = new ArrayList<>();
                for (int i = 0; i < ids.length; i++) {
                    String url = fileServerPath + "ejc-file-web/attachment/filePreview?fileId=" + ids[i];
                    imgFileVOS.add(new ImgFileVO(ids[i], url));
                }
                s.setImgArr(imgFileVOS);
            }

        }
        this.sceneCheckRecords = sceneCheckRecordVO;
    }

    public String getBaseImgUrl() {
        return baseImgUrl;
    }

    public void setBaseImgUrl(String baseImgUrl) {
        this.baseImgUrl = baseImgUrl;
    }
}
