/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.GetAutoCode;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.vo.SceneCheckDetailVO;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"sceneCheck"})
@Api(value="\u68c0\u67e5\u5355\u4e3b\u8868", tags={"\u68c0\u67e5\u5355\u4e3b\u8868"})
public class SceneCheckController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "SCENE_CHECK_CODE";
    @Autowired
    private ISceneCheckService service;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${oms.fileServerPath}")
    private String baseImgUrl;
    @Autowired
    ICommonBusinessService sceneCheck;

    @ApiOperation(value="\u6d4b\u8bd5\u6d88\u606f")
    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> test(@RequestParam Long id) {
        this.sceneCheck.afterApprovalProcessor(id, null, null);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SceneCheckVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SceneCheckVO saveorUpdateVO) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, SceneCheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setReformStatus(Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
        }
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        int count = 1;
        for (SceneCheckDetailEntity sceneCheckDetail : sceneCheckDetails) {
            if (StringUtils.isBlank((CharSequence)sceneCheckDetail.getBillCode())) {
                sceneCheckDetail.setBillCode(entity.getBillCode() + "-" + GetAutoCode.getTowPipelineNumbers((int)count));
            }
            ++count;
            if (StringUtils.isBlank((CharSequence)sceneCheckDetail.getCheckName())) {
                sceneCheckDetail.setCheckName(entity.getCheckName());
            }
            if (StringUtils.isBlank((CharSequence)sceneCheckDetail.getProjectName())) {
                sceneCheckDetail.setProjectName(entity.getProjectName());
            }
            if (sceneCheckDetail.getIsReform() == null) {
                sceneCheckDetail.setIsReform(Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
            }
            if (sceneCheckDetail.getCheckType() == null) {
                sceneCheckDetail.setCheckType(entity.getCheckType());
                sceneCheckDetail.setCheckTypeName(entity.getCheckTypeName());
            }
            if (sceneCheckDetail.getReformNumber() != null) continue;
            sceneCheckDetail.setReformNumber(0);
        }
        if (!entity.getCheckId().endsWith(",")) {
            entity.setCheckId(entity.getCheckId() + ",");
        }
        if (!entity.getReformDutyId().endsWith(",")) {
            entity.setReformDutyId(entity.getReformDutyId() + ",");
        }
        if (!entity.getReviewId().endsWith(",")) {
            entity.setReviewId(entity.getReviewId() + ",");
        }
        if (!entity.getNotifRelevantId().endsWith(",")) {
            entity.setNotifRelevantId(entity.getNotifRelevantId() + ",");
        }
        this.service.saveOrUpdate((Object)entity, false);
        List<SceneCheckDetailEntity> sceneCheckDetails1 = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails1, SceneCheckDetailVO.class);
        sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SceneCheckVO> queryDetail(@RequestParam Long id) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)this.service.selectById(id));
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetailVOList.forEach(item -> item.setBaseImgUrl(this.baseImgUrl));
        }
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneCheckVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u68c0\u67e5\u5355\u5217\u8868\u67e5\u8be2")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkName");
        fuzzyFields.add("checkPerson");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneCheck-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refSceneCheckData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SceneCheckVO>> refSceneCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SceneCheckVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

