/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.mapper.SceneCheckMapper;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.service.ISceneCheckDetailService;
import com.ejianc.business.scene.service.ISceneCheckRecordService;
import com.ejianc.business.scene.service.ISceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.util.ModifyState;
import com.ejianc.business.scene.util.NoticeEnum;
import com.ejianc.business.scene.util.OperationState;
import com.ejianc.business.scene.util.ReformState;
import com.ejianc.business.scene.util.ReviewState;
import com.ejianc.business.scene.util.SubmitState;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sceneCheckService")
public class SceneCheckServiceImpl
extends BaseServiceImpl<SceneCheckMapper, SceneCheckEntity>
implements ISceneCheckService {
    @Autowired
    private ISceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private ISceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SceneCheckMapper sceneCheckMapper;
    @Autowired
    private CheckMessageService checkMessageService;
    @Autowired
    private ISceneCheckService service;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public void checkSubmitHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REFORM_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.NO_SUBMITTED.getCode()));
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_STATE.getDescription());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            ArrayList list = new ArrayList();
            List<SceneCheckDetailEntity> sceneCheckDetaillist = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetaillist.forEach(item -> {
                SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                sceneCheckRecord.setPid(item.getId());
                sceneCheckRecord.setCheckId(item.getPid());
                sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.CHECK_STATE.getCode()));
                sceneCheckRecord.setReviewPerson(item.getReviewPerson());
                sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                sceneCheckRecord.setReviewResult(item.getReviewResult());
                sceneCheckRecord.setImgIds(item.getProblemImgIds());
                sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                sceneCheckRecord.setCheckItem(item.getCheckItem());
                sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                list.add(sceneCheckRecord);
            });
            this.sceneCheckRecordService.saveBatch(list, list.size());
            sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)sceneCheckEntity), SceneCheckVO.class);
            String reformDutyId = vo.getReformDutyId();
            String notifRelevantId = vo.getNotifRelevantId();
            vo.setMsgNum(Integer.valueOf(vo.getSceneCheckDetails().size()));
            vo.setMsgBillCode(vo.getBillCode());
            vo.setMsgId(vo.getId());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reformDutyId)) {
                String[] reformDuty = reformDutyId.split(",");
                this.checkMessageService.sendMsg(vo, reformDuty, NoticeEnum.CHECK_COMMIT_PASS);
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)notifRelevantId)) {
                String[] notifRelevant = notifRelevantId.split(",");
                this.checkMessageService.sendMsg(vo, notifRelevant, NoticeEnum.CHECK_COMMIT_PASS_REVIEW);
            }
        }
    }

    @Override
    public boolean checkRevokeBeforeHandle(Long billId) {
        boolean flag = true;
        SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter("eq", (Object)sceneCheckEntity.getId()));
        param.getParams().put("operationType", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
        List list = this.sceneCheckRecordService.queryList(param, false);
        if (list.size() > 0) {
            flag = false;
        }
        return flag;
    }

    @Override
    public void checkRevokeAfterHandle(Long billId) {
        if (billId != null) {
            SceneCheckEntity sceneCheckEntity = (SceneCheckEntity)((Object)this.selectById(billId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)billId);
            updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.INITIAL_STATE.getCode()));
            updateWrapper.set(SceneCheckEntity::getReviewItem, (Object)sceneCheckEntity.getSceneCheckDetails().size());
            updateWrapper.set(SceneCheckEntity::getReviewStatus, null);
            this.update((Wrapper)updateWrapper);
            List<SceneCheckDetailEntity> sceneCheckDetails = sceneCheckEntity.getSceneCheckDetails();
            sceneCheckDetails.forEach(d -> {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)d.getId());
                wrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.DEFULT_STATE.getCode()));
                wrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.DEFULT_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)wrapper);
            });
            LambdaUpdateWrapper deleteWrapper = new LambdaUpdateWrapper();
            deleteWrapper.set(SceneCheckRecordEntity::getCheckId, (Object)sceneCheckEntity.getId());
            deleteWrapper.set(SceneCheckRecordEntity::getOperationType, (Object)Integer.parseInt(OperationState.CHECK_STATE.getCode()));
            this.sceneCheckRecordService.remove((Wrapper)deleteWrapper);
        }
    }

    @Override
    public void updateSceneCheckOverdue() {
        this.sceneCheckMapper.updateSceneCheckOverdue();
    }

    @Override
    public void updateSceneCheckOverdueNumber() {
        this.sceneCheckMapper.updateSceneCheckOverdueNumber();
    }

    @Override
    public CommonResponse<SceneCheckVO> submitReviewNews(SceneCheckVO sceneCheckVO) {
        SceneCheckEntity entity = (SceneCheckEntity)((Object)BeanMapper.map((Object)sceneCheckVO, SceneCheckEntity.class));
        SceneCheckVO vo = (SceneCheckVO)BeanMapper.map((Object)((Object)entity), SceneCheckVO.class);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
        List<SceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            int size;
            List reviewResults = sceneCheckDetails.stream().map(SceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            ArrayList list = new ArrayList();
            List<SceneCheckDetailEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(Integer.valueOf(sceneCheckDetailList.size()));
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId != null) {
                    String[] reformDutyIds = reformDutyId.split(",");
                    this.checkMessageService.sendMsg(vo, reformDutyIds, NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            if ((size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size()) == sceneCheckDetails.size()) {
                updateWrapper.set(SceneCheckEntity::getReformStatus, (Object)Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId != null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(Integer.valueOf(0));
                    this.checkMessageService.sendMsg(vo, notifRelevantIds, NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform() == Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    SceneCheckRecordEntity sceneCheckRecord = new SceneCheckRecordEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                this.sceneCheckRecordService.saveBatch(list, list.size());
            }
            sceneCheckDetails.forEach(sceneCheckitem -> {
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("pid", new Parameter("eq", (Object)sceneCheckitem.getId()));
                queryParam.getOrderMap().put("createTime", "desc");
                queryParam.getParams().put("operation_type", new Parameter("eq", (Object)Integer.parseInt(OperationState.REFORM_STATE.getCode())));
                List sceneCheckRecords = this.sceneCheckRecordService.queryList(queryParam);
                if (CollectionUtils.isNotEmpty((Collection)sceneCheckRecords)) {
                    System.out.println(sceneCheckRecords);
                    SceneCheckRecordEntity sceneCheckRecordEntity = (SceneCheckRecordEntity)((Object)((Object)sceneCheckRecords.get(0)));
                    if (sceneCheckRecordEntity.getImgIds() != null) {
                        List<String> imgids = Arrays.asList(sceneCheckRecordEntity.getImgIds().split(","));
                        ArrayList attachIds = new ArrayList();
                        imgids.forEach(item -> attachIds.add(Long.parseLong(item)));
                        this.iAttachmentApi.updateAttachRef(sceneCheckRecordEntity.getId(), attachIds);
                    }
                }
            });
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper updateReviewMsgWrapper = new LambdaUpdateWrapper();
                updateReviewMsgWrapper.eq(BaseEntity::getId, (Object)item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty((String)item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SceneCheckDetailEntity::getReviewMsg, (Object)(item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe));
                Integer reviewResult = item.getReviewResult();
                this.sceneCheckDetailService.update((Wrapper)updateReviewMsgWrapper);
            });
        }
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper isModifyWrapper = new LambdaUpdateWrapper();
                isModifyWrapper.eq(BaseEntity::getId, (Object)item.getId());
                isModifyWrapper.set(SceneCheckDetailEntity::getIsModify, (Object)Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                this.sceneCheckDetailService.update((Wrapper)isModifyWrapper);
            }
        });
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper sceneUpdateWrapper = new LambdaUpdateWrapper();
                sceneUpdateWrapper.eq(BaseEntity::getId, (Object)item.getId());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewDate, (Object)new Date());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(SceneCheckDetailEntity::getReviewResult, (Object)ReviewState.REVIEW_FAILED_STATE.getCode());
                this.sceneCheckDetailService.update((Wrapper)sceneUpdateWrapper);
            }
            if (item.getReviewResult() != null && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper successWrapper = new LambdaUpdateWrapper();
                successWrapper.eq(BaseEntity::getId, (Object)item.getId());
                successWrapper.set(SceneCheckDetailEntity::getTaskState, (Object)CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());
                successWrapper.set(SceneCheckDetailEntity::getReviewResult, (Object)ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(SceneCheckDetailEntity::getIsReform, (Object)Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate() == null) {
                    successWrapper.set(SceneCheckDetailEntity::getReviewDate, (Object)new Date());
                }
                this.sceneCheckDetailService.update((Wrapper)successWrapper);
            }
        });
        Map<Integer, List<SceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null).collect(Collectors.groupingBy(SceneCheckDetailEntity::getReviewResult));
        updateWrapper.set(SceneCheckEntity::getReviewStatus, (Object)Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFinishedWrapper = new LambdaUpdateWrapper();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(SceneCheckEntity::getReviewPass, (Object)reviewFinished);
                revieweFinishedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                this.service.update((Wrapper)revieweFinishedWrapper);
            }
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper revieweFailedWrapper = new LambdaUpdateWrapper();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(SceneCheckEntity::getReviewedNum, (Object)size);
                revieweFailedWrapper.eq(BaseEntity::getId, (Object)entity.getId());
                this.service.update((Wrapper)revieweFailedWrapper);
            }
        }
        this.service.update((Wrapper)updateWrapper);
        SceneCheckEntity checkenEntity = (SceneCheckEntity)((Object)this.service.selectById(entity.getId()));
        SceneCheckVO scenecheckvo = (SceneCheckVO)BeanMapper.map((Object)((Object)checkenEntity), SceneCheckVO.class);
        return CommonResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01", (Object)scenecheckvo);
    }
}

