package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.scene.bean.SceneNotificationEntity;
import com.ejianc.business.scene.bean.ScenePlanDetailEntity;
import com.ejianc.business.scene.bean.ScenePlanEntity;
import com.ejianc.business.scene.bean.ScenePlantotalDetailEntity;
import com.ejianc.business.scene.bean.ScenePlantotalEntity;
import com.ejianc.business.scene.service.ISceneNotificationService;
import com.ejianc.business.scene.service.IScenePlanDetailService;
import com.ejianc.business.scene.service.IScenePlanService;
import com.ejianc.business.scene.service.IScenePlantotalDetailService;
import com.ejianc.business.scene.service.IScenePlantotalService;
import com.ejianc.business.scene.vo.SceneNotificationVO;
import com.ejianc.business.scene.vo.ScenePlanDetailVO;


/**
 * 工期预警通知单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sceneNotification")
public class SceneNotificationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SceneNotificationNO";//此处需要根据实际修改

    @Autowired
    private ISceneNotificationService service;

    @Autowired
    private SessionManager sessionManager;
    
    @Autowired
    private IScenePlantotalDetailService scenePlantotalDetailService;
    
    @Autowired
    private IScenePlantotalService scenePlantotalService;
    

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SceneNotificationVO> saveOrUpdate(@RequestBody SceneNotificationVO saveOrUpdateVO) {
    	SceneNotificationEntity entity = BeanMapper.map(saveOrUpdateVO, SceneNotificationEntity.class);
    	if(entity.getBillCode() == null){
           
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	SceneNotificationVO vo = BeanMapper.map(entity, SceneNotificationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneNotificationVO> queryDetail(Long id) {
    	SceneNotificationEntity entity = service.selectById(id);
    	SceneNotificationVO vo = BeanMapper.map(entity, SceneNotificationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SceneNotificationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SceneNotificationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SceneNotificationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneNotificationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SceneNotificationEntity> page = service.queryPage(param,false);
        IPage<SceneNotificationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneNotificationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * @Description queryProjectList 查询项目列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProjectList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneNotificationVO>> queryProjectList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        param.getParams().put("notificationType", new Parameter(QueryParam.IN, "2,3"));
        param.getParams().put("id", new Parameter(QueryParam.SQL, "id not in (select notification_Id from ejc_scene_handle where dr=0 and  bill_state in(1,3))"));
        IPage<SceneNotificationEntity> page = service.queryPage(param,false);
        IPage<SceneNotificationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneNotificationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    
    /**
     * @Description queryCompanyList 查询公司列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryCompanyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SceneNotificationVO>> queryCompanyList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("notificationOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        param.getParams().put("notificationType", new Parameter(QueryParam.EQ, "1"));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("id", new Parameter(QueryParam.SQL, "id not in (select plantotal_detail_id from ejc_scene_notification where dr=0 and  bill_state in(1,3) and notification_type=3)"));
        IPage<SceneNotificationEntity> page = service.queryPage(param,false);
        IPage<SceneNotificationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneNotificationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryDetail 复制
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneNotificationVO> queryCopyDetail(Long id,String status) {
    	QueryWrapper<SceneNotificationEntity> QuerWrapper=new QueryWrapper<>();
    	QuerWrapper.eq("plantotal_detail_id", id);
    	QuerWrapper.eq("dr", "0");
    	List<String> billState=new ArrayList<String>();
//    	billState.add("1");
//    	billState.add("3");
//    	QuerWrapper.in("bill_state", billState);
    	if("1".equals(status)) {
    		QuerWrapper.eq("notification_type","1");
    	}else if("2".equals(status)) {
    		QuerWrapper.eq("notification_type","2");
    	}
    	SceneNotificationEntity sceneNotificationEntity=service.getOne(QuerWrapper);
    	if(sceneNotificationEntity != null) {
    		SceneNotificationVO vo = BeanMapper.map(sceneNotificationEntity, SceneNotificationVO.class);
    		return CommonResponse.success("查询详情数据成功！",vo);
    	}else {
    	ScenePlantotalDetailEntity entity= scenePlantotalDetailService.getById(id);
    	ScenePlantotalEntity mainEntity=scenePlantotalService.getById(entity.getPid());
    	SceneNotificationVO vo=new SceneNotificationVO();
    	vo.setOrgCode(mainEntity.getOrgCode());
    	vo.setOrgId(mainEntity.getOrgId());
    	vo.setOrgName(mainEntity.getOrgName());
    	vo.setProjectId(mainEntity.getProjectId());
    	vo.setProjectName(mainEntity.getProjectName());
    	vo.setProjectCode(mainEntity.getProjectCode());
    	vo.setParentOrgId(mainEntity.getParentOrgId());
    	vo.setParentOrgName(mainEntity.getParentOrgName());
    	vo.setEarlyWarning(entity.getEarlyWarning());
    	vo.setId(IdWorker.getId());
    	if("1".equals(status)) {
    		vo.setNotificationOrgId(mainEntity.getParentOrgId());
    		vo.setNotificationOrgName(mainEntity.getParentOrgName());
    	}else if("2".equals(status)) {
    		vo.setNotificationOrgId(mainEntity.getOrgId());
    		vo.setNotificationOrgName(mainEntity.getOrgName());
    	}
    	vo.setReleaseOrgId(Long.valueOf("1406795679670312962"));
    	vo.setReleaseOrgName("青岛市政空间开发集团有限责任公司");
    	vo.setNotificationType(status);
    	vo.setPlantotalDetailId(entity.getId());
        return CommonResponse.success("查询详情数据成功！",vo);
    	}
    }
    /**
     * @Description queryDetail 复制
     * @param id
     */
    @RequestMapping(value = "/copyDetailCompanyToProject",method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SceneNotificationVO> copyDetailCompanyToProject(Long id,String status) {
    	QueryWrapper<SceneNotificationEntity> QuerWrapper=new QueryWrapper<>();
    	QuerWrapper.eq("plantotal_detail_id", id);
    	QuerWrapper.eq("dr", "0");
    	QuerWrapper.eq("notification_type","3");
    	SceneNotificationEntity sceneNotificationEntity=service.getOne(QuerWrapper);
    	if(sceneNotificationEntity != null) {
    		SceneNotificationVO vo = BeanMapper.map(sceneNotificationEntity, SceneNotificationVO.class);
    		return CommonResponse.success("查询详情数据成功！",vo);
    	}else {
        	QuerWrapper=new QueryWrapper<>();
        	QuerWrapper.eq("id", id);
        	QuerWrapper.eq("dr", "0");
        	sceneNotificationEntity=service.getOne(QuerWrapper);
    		SceneNotificationVO vo = BeanMapper.map(sceneNotificationEntity, SceneNotificationVO.class);
    		Long releaseOrgId=vo.getNotificationOrgId();
    		String releaseOrgName=vo.getNotificationOrgName();
    		Long notificationOrgId=vo.getProjectId();
    		String notificationOrgName=vo.getProjectName();
    		vo.setReleaseOrgId(releaseOrgId);
    		vo.setReleaseOrgName(releaseOrgName);
    		vo.setNotificationOrgId(notificationOrgId);
    		vo.setNotificationOrgName(notificationOrgName);
    		vo.setId(null);
    		vo.setPlantotalDetailId(id);
    		vo.setNotificationType("3");
    		vo.setBillState(null);
    		vo.setBillCode(null);
    		return CommonResponse.success("查询详情数据成功！",vo);
    	}
    }
    
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SceneNotificationEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("SceneNotification-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSceneNotificationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SceneNotificationVO>> refSceneNotificationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SceneNotificationEntity> page = service.queryPage(param,false);
        IPage<SceneNotificationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SceneNotificationVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
