package com.ejianc.business.scene.controller;

import java.io.Serializable;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.scene.bean.ScenePlanDetailEntity;
import com.ejianc.business.scene.bean.ScenePlanEntity;
import com.ejianc.business.scene.bean.ScenePlantotalDetailEntity;
import com.ejianc.business.scene.bean.ScenePlantotalEntity;
import com.ejianc.business.scene.service.IScenePlanDetailService;
import com.ejianc.business.scene.service.IScenePlantotalDetailService;
import com.ejianc.business.scene.service.IScenePlantotalService;
import com.ejianc.business.scene.vo.ScenePlanDetailVO;
import com.ejianc.business.scene.vo.ScenePlanVO;
import com.ejianc.business.scene.vo.ScenePlantotalDetailVO;
import com.ejianc.business.scene.vo.ScenePlantotalVO;

/**
 * 工期计划统计
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scenePlantotal")
public class ScenePlantotalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCENE_PlANTOTAL_CODE";//此处需要根据实际修改

    @Autowired
    private IScenePlantotalService service;
    
    @Autowired
    private IScenePlantotalDetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScenePlantotalVO> saveOrUpdate(@RequestBody ScenePlantotalVO saveOrUpdateVO) {
    	ScenePlantotalEntity entity = BeanMapper.map(saveOrUpdateVO, ScenePlantotalEntity.class);
    	QueryWrapper<ScenePlantotalEntity> listQuerWrapper=new QueryWrapper<>();
    	listQuerWrapper.eq("project_id",entity.getProjectId());
    	listQuerWrapper.eq("dr",0);
    	if(saveOrUpdateVO.getBillCode() != null) {
    		listQuerWrapper.ne("id",entity.getId());
    	}
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        	QueryWrapper<ScenePlantotalEntity> queryWrappers=new QueryWrapper<>();
        	queryWrappers.eq("project_id",entity.getProjectId());
        	List<String> billState=new ArrayList<String>();
        	billState.add("1");
        	billState.add("3");
        	queryWrappers.notIn("bill_state",billState);
        	List<ScenePlantotalEntity> scenePlantotalList =service.list(queryWrappers);
        	if(scenePlantotalList.size() != 0 ) {
        		throw new BusinessException("一个项目只能存在一个未生效单据！");
        	}
        	
        	queryWrappers=new QueryWrapper<>();
        	queryWrappers.eq("project_id",entity.getProjectId());
        	queryWrappers.ge("count_date", entity.getCountDate());
        	List<ScenePlantotalEntity> scenePlantotalList1 =service.list(queryWrappers);
        	if(scenePlantotalList1.size() != 0) {
        		throw new BusinessException("已存在大于或者等于所选日期的计划统"
        				+ " 计单据，请重新选择");
        	}
        }
    	entity.getDetailList().forEach(i->{
    		i.setProjectId(entity.getProjectId());
    		i.setProjectName(entity.getProjectName());
    		i.setCountDate(entity.getCountDate());
    		if(StringUtils.isEmpty(i.getDetailFlag())) {
    			i.setDetailFlag("0");
    		}
    	});
    	service.saveOrUpdate(entity, false);
    	ScenePlantotalVO vo = BeanMapper.map(entity, ScenePlantotalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScenePlantotalVO> queryDetail(Long id) {
    	ScenePlantotalEntity entity = service.selectById(id);
    	ScenePlantotalVO vo = BeanMapper.map(entity, ScenePlantotalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScenePlantotalVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScenePlantotalVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ScenePlantotalVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ScenePlantotalEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if(!orgListResp.isSuccess()) {
        	throw new BusinessException("合同分页列表查询失败，查询组织信息失败！");
        }
        List<ScenePlantotalEntity> list = service.queryList(param);
        com.alibaba.fastjson.JSONObject page = new com.alibaba.fastjson.JSONObject();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(list, ScenePlantotalVO.class));
        ExcelExport.getInstance().export("ScenePlantotal-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refScenePlantotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> refScenePlantotalData(
    		@RequestParam Integer pageNumber, 
    		@RequestParam Integer pageSize,
    		@RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchText(searchText);
        param.getFuzzyFields().add("nodeName");
        param.getFuzzyFields().add("remarks");
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        QueryWrapper<ScenePlantotalEntity> scenePlantotalWrapper=new QueryWrapper<>();
        if(StringUtils.isNotEmpty(condition)){
            JSONObject con = JSONObject.parseObject(condition);
            if(condition.contains("projectId")){
            	scenePlantotalWrapper.eq("project_id",con.getLong("projectId"));
            }
            if(condition.contains("orgId")){
            	scenePlantotalWrapper.eq("org_id",con.getLong("orgId"));
            }
        }
        scenePlantotalWrapper.in("bill_state", "1,3");
        scenePlantotalWrapper.eq("dr", 0);
        scenePlantotalWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        scenePlantotalWrapper.orderByDesc("create_time");
        
        ScenePlantotalEntity plantotalEntity=service.getOne(scenePlantotalWrapper);
        if(plantotalEntity !=null) {
            long planId=plantotalEntity.getId();
            param.getParams().put("pid",new Parameter(QueryParam.EQ,planId));
            param.getParams().put("keyNodes",new Parameter(QueryParam.EQ,"Y"));
            IPage<ScenePlantotalDetailEntity> page = detailService.queryPage(param,false);
            IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            List<ScenePlantotalDetailVO> detailVOList=BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class);
            detailVOList.forEach(i->{
            	if("Y".equals(i.getKeyNodes())) {
            		i.setKeyNodes("是");
            	}else {
            		i.setKeyNodes("否");
            	}
            });
            pageData.setRecords(detailVOList);
            return CommonResponse.success("查询参照数据成功！",pageData);
        }else {
        	throw new BusinessException("未有生效的工期计划！");
        }

     }

//    /**
//     * @Description queryMaxDate 查询详情
//     * @param countDate
//     */
//    @RequestMapping(value = "/queryMaxDate", method = RequestMethod.GET)
//    @ResponseBody
//    public ScenePlantotalVO queryMaxDate(Date countDate) {
//    	ScenePlantotalEntity entity = service.selectByDate(countDate);
//    	ScenePlantotalVO vo = BeanMapper.map(entity, ScenePlantotalVO.class);
//        return vo;
//    }
    
}

