package com.ejianc.business.scene.controller;

import java.io.Serializable;
import java.lang.reflect.Method;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.scene.bean.ScenePlanEntity;
import com.ejianc.business.scene.bean.ScenePlantotalDetailEntity;
import com.ejianc.business.scene.bean.ScenePlantotalEntity;
import com.ejianc.business.scene.service.IScenePlantotalDetailService;
import com.ejianc.business.scene.service.IScenePlantotalService;
import com.ejianc.business.scene.vo.ScenePlantotalDetailVO;
import com.ejianc.business.scene.vo.ScenePlantotalVO;

/**
 * 工期统计子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scenePlantotalDetail")
public class ScenePlantotalDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IScenePlantotalDetailService service;
    
    @Autowired
    private IScenePlantotalService scenePlantotalService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScenePlantotalDetailVO> saveOrUpdate(@RequestBody ScenePlantotalDetailVO saveOrUpdateVO) {
    	ScenePlantotalDetailEntity entity = BeanMapper.map(saveOrUpdateVO, ScenePlantotalDetailEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
    	service.saveOrUpdate(entity, false);
    	ScenePlantotalDetailVO vo = BeanMapper.map(entity, ScenePlantotalDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScenePlantotalDetailVO> queryDetail(Long id) {
    	ScenePlantotalDetailEntity entity = service.selectById(id);
    	ScenePlantotalDetailVO vo = BeanMapper.map(entity, ScenePlantotalDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScenePlantotalDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScenePlantotalDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ScenePlantotalDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description PendingList 获取列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/PendingList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> PendingList(@RequestBody QueryParam param) {
        //构建主表查询
        QueryParam mainParam= new QueryParam();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("nodeName");
        fuzzyFields.add("remarks");
        fuzzyFields.add("projectName");
        mainParam.setPageIndex(1);
        mainParam.setPageSize(-1);
        mainParam.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        mainParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        /** 租户隔离 */
        mainParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
        	mainParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        //查询主表
        IPage<ScenePlantotalEntity> mainPage = scenePlantotalService.queryPage(mainParam,false);
        List<Long> pIdList=new ArrayList<Long>();
        mainPage.getRecords().forEach(i->{
        	pIdList.add(i.getId());
        });
        if(pIdList.size() >0) {
            param.getParams().put("pid", new Parameter(QueryParam.IN, pIdList));
        }else {
        	return CommonResponse.success("查询列表数据成功！",null);
        }
        param.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        param.getParams().put("detailFlag", new Parameter(QueryParam.EQ, 0));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("earlyWarning", new Parameter(QueryParam.IN, "Y,O,R"));
        param.getParams().put("id", new Parameter(QueryParam.SQL, "id not in (select plantotal_detail_id from ejc_scene_notification where dr=0 and  bill_state in(1,3))"));
        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        page.getRecords().forEach(i->{
//        	ScenePlantotalEntity scenePlantotal= scenePlantotalService.getById(i.getPid());
//        	i.setProjectId(scenePlantotal.getProjectId());
//        	i.setProjectName(scenePlantotal.getProjectName());
//        	i.setCountDate(scenePlantotal.getCountDate());
//        });
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    
    /**
     * @Description PendingList 获取已通知公司列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/CompanyList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> CompanyList(@RequestBody QueryParam param) {
        //构建主表查询
        QueryParam mainParam= new QueryParam();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("nodeName");
        fuzzyFields.add("remarks");
        fuzzyFields.add("projectName");
        mainParam.setPageIndex(1);
        mainParam.setPageSize(-1);
        mainParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 租户隔离 */
        mainParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
        	mainParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        //查询主表
        IPage<ScenePlantotalEntity> mainPage = scenePlantotalService.queryPage(mainParam,false);
        List<Long> pIdList=new ArrayList<Long>();
        mainPage.getRecords().forEach(i->{
        	pIdList.add(i.getId());
        });
        
        if(pIdList.size() >0) {
            param.getParams().put("pid", new Parameter(QueryParam.IN, pIdList));
        }else {
        	return CommonResponse.success("查询列表数据成功！",null);
        }
        param.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
//        param.getParams().put("detailFlag", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("earlyWarning", new Parameter(QueryParam.IN, "Y,O,R"));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        param.getParams().put("id", new Parameter(QueryParam.SQL, "id in (select plantotal_detail_id from ejc_scene_notification where dr=0 and  bill_state in(1,3) and notification_type=1)"));
        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        page.getRecords().forEach(i->{
//        	ScenePlantotalEntity scenePlantotal= scenePlantotalService.getById(i.getPid());
//        	i.setProjectId(scenePlantotal.getProjectId());
//        	i.setProjectName(scenePlantotal.getProjectName());
//        	i.setCountDate(scenePlantotal.getCountDate());
//        });
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    
    /**
     * @Description PendingList 获取已通知项目列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/ProjectList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> ProjectList(@RequestBody QueryParam param) {
        //构建主表查询
        QueryParam mainParam= new QueryParam();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("nodeName");
        fuzzyFields.add("remarks");
        fuzzyFields.add("projectName");
        mainParam.setPageIndex(1);
        mainParam.setPageSize(-1);
        /** 租户隔离 */
        mainParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        mainParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
        	mainParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        //查询主表
        IPage<ScenePlantotalEntity> mainPage = scenePlantotalService.queryPage(mainParam,false);
        List<Long> pIdList=new ArrayList<Long>();
        mainPage.getRecords().forEach(i->{
        	pIdList.add(i.getId());
        });
        
        if(pIdList.size() >0) {
            param.getParams().put("pid", new Parameter(QueryParam.IN, pIdList));
        }else {
        	return CommonResponse.success("查询列表数据成功！",null);
        }
        param.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        //param.getParams().put("detailFlag", new Parameter(QueryParam.EQ, 2));
        param.getParams().put("earlyWarning", new Parameter(QueryParam.IN, "Y,O,R"));
        param.getParams().put("id", new Parameter(QueryParam.SQL, "id in (select plantotal_detail_id from ejc_scene_notification where dr=0 and  bill_state in(1,3) and notification_type=2)"));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        page.getRecords().forEach(i->{
//        	ScenePlantotalEntity scenePlantotal= scenePlantotalService.getById(i.getPid());
//        	i.setProjectId(scenePlantotal.getProjectId());
//        	i.setProjectName(scenePlantotal.getProjectName());
//        	i.setCountDate(scenePlantotal.getCountDate());
//        });
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    
    /**
     * @Description PendingList 获取已处理理列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/ProcessedList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> ProcessedList(@RequestBody QueryParam param) {
        //构建主表查询
        QueryParam mainParam= new QueryParam();

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("nodeName");
        fuzzyFields.add("remarks");
        fuzzyFields.add("projectName");
        mainParam.setPageIndex(1);
        mainParam.setPageSize(-1);
        /** 租户隔离 */
        mainParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        mainParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
        	mainParam.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        
        //查询主表
        IPage<ScenePlantotalEntity> mainPage = scenePlantotalService.queryPage(mainParam,false);
        List<Long> pIdList=new ArrayList<Long>();
        mainPage.getRecords().forEach(i->{
        	pIdList.add(i.getId());
        });
        
        if(pIdList.size() >0) {
            param.getParams().put("pid", new Parameter(QueryParam.IN, pIdList));
        }else {
        	return CommonResponse.success("查询列表数据成功！",null);
        }
        param.getParams().put("dr", new Parameter(QueryParam.EQ, "0"));
        param.getParams().put("detailFlag", new Parameter(QueryParam.EQ, 3));
        param.getParams().put("earlyWarning", new Parameter(QueryParam.IN, "Y,O,R"));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        page.getRecords().forEach(i->{
//        	ScenePlantotalEntity scenePlantotal= scenePlantotalService.getById(i.getPid());
//        	i.setProjectId(scenePlantotal.getProjectId());
//        	i.setProjectName(scenePlantotal.getProjectName());
//        	i.setCountDate(scenePlantotal.getCountDate());
//        });
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ScenePlantotalDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ScenePlantotalDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refScenePlantotalDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScenePlantotalDetailVO>> refScenePlantotalDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ScenePlantotalDetailEntity> page = service.queryPage(param,false);
        IPage<ScenePlantotalDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScenePlantotalDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
