package com.ejianc.business.scene.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scene.bean.ScenePlanDetailEntity;
import com.ejianc.business.scene.bean.ScenePlanEntity;
import com.ejianc.business.scene.bean.ScenePlantotalDetailEntity;
import com.ejianc.business.scene.bean.ScenePlantotalEntity;
import com.ejianc.business.scene.service.IScenePlanDetailService;
import com.ejianc.business.scene.service.IScenePlanService;
import com.ejianc.business.scene.service.IScenePlantotalDetailService;
import com.ejianc.business.scene.service.IScenePlantotalService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

@Service("scenePlantotal") 
public class ScenePlantotalBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IScenePlantotalService scenePlantotalService;
	@Autowired
	private IScenePlanService scenePlanService;
	@Autowired
	private IScenePlantotalDetailService scenePlantotalDetailService;
	@Autowired
	private IScenePlanDetailService scenePlanDetailService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		getFinshTime(billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		getFinshTime(billId);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		getFinshTime(billId);
		return CommonResponse.success();
	}
	
	public void getFinshTime(Long id) {
		ScenePlantotalEntity scenePlantotalEntity=scenePlantotalService.getById(id);
		Long projectId=scenePlantotalEntity.getProjectId();
		
		QueryWrapper<ScenePlanEntity> queryWrapper=new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		ScenePlanEntity scenePlanEntity=scenePlanService.getOne(queryWrapper);
		List<ScenePlanDetailEntity> planDetailList=scenePlanEntity.getDetailList();
		planDetailList.forEach(i->{
			List<ScenePlantotalDetailEntity> finshTimeList=scenePlantotalDetailService.getFinshTime(i.getId());
			if(finshTimeList.size()>0 && finshTimeList!=null) {
				i.setFinishTime(finshTimeList.get(0).getFinishTime());
				i.setLagDays(finshTimeList.get(0).getLagDays());
				scenePlanDetailService.saveOrUpdate(i);
			}
		});
	}
}
