package com.ejianc.business.scene.service.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.ScenePlantotalMapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.scene.bean.ScenePlanDetailEntity;
import com.ejianc.business.scene.bean.ScenePlanEntity;
import com.ejianc.business.scene.bean.ScenePlantotalDetailEntity;
import com.ejianc.business.scene.bean.ScenePlantotalEntity;
import com.ejianc.business.scene.service.IScenePlanDetailService;
import com.ejianc.business.scene.service.IScenePlanService;
import com.ejianc.business.scene.service.IScenePlantotalDetailService;
import com.ejianc.business.scene.service.IScenePlantotalService;
import com.ejianc.business.scene.vo.ScenePlantotalVO;

/**
 * 工期计划统计
 * 
 * @author generator
 * 
 */
@Service("scenePlantotalService")
public class ScenePlantotalServiceImpl extends BaseServiceImpl<ScenePlantotalMapper, ScenePlantotalEntity> implements IScenePlantotalService{
	
	@Autowired
	private IScenePlanService scenePlanService;
	@Autowired
	private IScenePlantotalDetailService scenePlantotalDetailService;
	@Autowired
	private IScenePlanDetailService scenePlanDetailService;
	
	@Override
	public void getFinshTime(Long id) {
		ScenePlantotalEntity scenePlantotalEntity=this.getById(id);
		Long projectId=scenePlantotalEntity.getProjectId();
		
		QueryWrapper<ScenePlanEntity> queryWrapper=new QueryWrapper<>();
		queryWrapper.eq("project_id", projectId);
		ScenePlanEntity scenePlanEntity=scenePlanService.getOne(queryWrapper);
		List<ScenePlanDetailEntity> planDetailList=scenePlanEntity.getDetailList();
		planDetailList.forEach(i->{
			List<ScenePlantotalDetailEntity> finshTimeList=scenePlantotalDetailService.getFinshTime(i.getId());
			if(finshTimeList.size()>0 && finshTimeList!=null) {
				i.setFinishTime(finshTimeList.get(0).getFinishTime());
				i.setLagDays(finshTimeList.get(0).getLagDays());
				scenePlanDetailService.saveOrUpdate(i);
			}
		});
	}
}
